/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import org.jboss.logging.Logger;
import org.jboss.tm.JBossXATerminator;
import org.jboss.tm.TransactionImpl;
import org.jboss.tm.TxManager;
import org.jboss.tm.XAExceptionFormatter;
import org.jboss.tm.XidFactoryBase;
import org.jboss.tm.integrity.TransactionIntegrityFactory;
import org.jboss.tm.recovery.RecoveryLogger;

public class TransactionManagerInitializer
implements XAExceptionFormatter,
ObjectFactory {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$tm$TransactionManagerInitializer == null ? (class$org$jboss$tm$TransactionManagerInitializer = TransactionManagerInitializer.class$("org.jboss.tm.TransactionManagerInitializer")) : class$org$jboss$tm$TransactionManagerInitializer));
    public static String JNDI_NAME = "java:/TransactionManager";
    public static String JNDI_IMPORTER = "java:/TransactionPropagationContextImporter";
    public static String JNDI_EXPORTER = "java:/TransactionPropagationContextExporter";
    private boolean globalIdsEnabled = false;
    private boolean interruptThreads = false;
    private int timeout = 300;
    private int xaRetryTimeout;
    private int preparedTimeout;
    private final Map xaExceptionFormatters = new HashMap();
    private RecoveryLogger recoveryLogger;
    private XidFactoryBase xidFactory;
    private TransactionIntegrityFactory integrityFactory;
    private InitialContext initialContext;
    protected Hashtable initialContextProperties;
    static TxManager tm;
    static /* synthetic */ Class class$org$jboss$tm$TransactionManagerInitializer;
    static /* synthetic */ Class class$javax$transaction$xa$XAException;

    public void setInitialContextProperties(Hashtable initialContextProperties) {
        this.initialContextProperties = initialContextProperties;
    }

    public void start() throws Exception {
        this.initialContext = this.initialContextProperties == null ? new InitialContext() : new InitialContext(this.initialContextProperties);
        TransactionImpl.xidFactory = this.xidFactory;
        TransactionImpl.xaExceptionFormatter = this;
        tm = TxManager.getInstance();
        tm.setDefaultTransactionTimeout(this.timeout);
        tm.setXARetryTimeout(this.xaRetryTimeout);
        tm.setPreparedTimeout(this.preparedTimeout);
        tm.setGlobalIdsEnabled(this.globalIdsEnabled);
        tm.setInterruptThreads(this.interruptThreads);
        if (this.integrityFactory != null) {
            tm.setTransactionIntegrity(this.integrityFactory.createTransactionIntegrity());
        } else {
            tm.setTransactionIntegrity(null);
        }
        this.bindRef(JNDI_NAME, "org.jboss.tm.TxManager");
        this.bindRef(JNDI_IMPORTER, "org.jboss.tm.TransactionPropagationContextImporter");
        this.bindRef(JNDI_EXPORTER, "org.jboss.tm.TransactionPropagationContextFactory");
    }

    public void stop() {
        try {
            InitialContext ctx = this.initialContext;
            ctx.unbind(JNDI_NAME);
            ctx.unbind(JNDI_IMPORTER);
            ctx.unbind(JNDI_EXPORTER);
        }
        catch (Exception e) {
            log.error((Object)"Failed to clear JNDI bindings", (Throwable)e);
        }
    }

    public void setRecoveryLogger(RecoveryLogger recoveryLogger) {
        this.recoveryLogger = recoveryLogger;
        TxManager.getInstance().setRecoveryLogger(this.recoveryLogger);
    }

    public void setTransactionIntegrityFactory(TransactionIntegrityFactory factory) {
        this.integrityFactory = factory;
        if (tm != null) {
            if (factory != null) {
                tm.setTransactionIntegrity(factory.createTransactionIntegrity());
            } else {
                tm.setTransactionIntegrity(null);
            }
        }
    }

    public boolean getGlobalIdsEnabled() {
        return this.globalIdsEnabled;
    }

    public void setGlobalIdsEnabled(boolean newValue) {
        this.globalIdsEnabled = newValue;
        if (tm != null) {
            tm.setGlobalIdsEnabled(newValue);
        }
    }

    public boolean isInterruptThreads() {
        return this.interruptThreads;
    }

    public void setInterruptThreads(boolean interruptThreads) {
        this.interruptThreads = interruptThreads;
        if (tm != null) {
            tm.setInterruptThreads(interruptThreads);
        }
    }

    public int getTransactionTimeout() {
        if (tm != null) {
            this.timeout = tm.getDefaultTransactionTimeout();
        }
        return this.timeout;
    }

    public void setTransactionTimeout(int timeout) {
        this.timeout = timeout;
        if (tm != null) {
            tm.setDefaultTransactionTimeout(timeout);
        }
    }

    public void setXARetryTimeout(int xaRetryTimeout) {
        this.xaRetryTimeout = xaRetryTimeout;
        if (tm != null) {
            tm.setXARetryTimeout(xaRetryTimeout);
        }
    }

    public int getXARetryTimeout() {
        return this.xaRetryTimeout;
    }

    public void setPreparedTimeout(int preparedTimeout) {
        this.preparedTimeout = preparedTimeout;
        if (tm != null) {
            tm.setPreparedTimeout(preparedTimeout);
        }
    }

    public int getPreparedTimeout() {
        return this.preparedTimeout;
    }

    public XidFactoryBase getXidFactory() {
        return this.xidFactory;
    }

    public void setXidFactory(XidFactoryBase xidFactory) {
        this.xidFactory = xidFactory;
    }

    public TransactionManager getTransactionManager() {
        return tm;
    }

    public JBossXATerminator getXATerminator() {
        return tm;
    }

    public long getTransactionCount() {
        return tm.getTransactionCount();
    }

    public long getCommitCount() {
        return tm.getCommitCount();
    }

    public long getRollbackCount() {
        return tm.getRollbackCount();
    }

    public void registerXAExceptionFormatter(Class clazz, XAExceptionFormatter formatter) {
        this.xaExceptionFormatters.put(clazz, formatter);
    }

    public void unregisterXAExceptionFormatter(Class clazz) {
        this.xaExceptionFormatters.remove(clazz);
    }

    public void formatXAException(XAException xae, Logger log) {
        for (Class<?> clazz = xae.getClass(); clazz != (class$javax$transaction$xa$XAException == null ? TransactionManagerInitializer.class$("javax.transaction.xa.XAException") : class$javax$transaction$xa$XAException); clazz = clazz.getSuperclass()) {
            XAExceptionFormatter formatter = (XAExceptionFormatter)this.xaExceptionFormatters.get(clazz);
            if (formatter == null) continue;
            formatter.formatXAException(xae, log);
            return;
        }
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        return tm;
    }

    private void bindRef(String jndiName, String className) throws Exception {
        Reference ref = new Reference(className, this.getClass().getName(), null);
        this.initialContext.bind(jndiName, (Object)ref);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

