/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jboss.tm.XidImpl;

public class LocalId
implements Externalizable {
    static final long serialVersionUID = 2076780468014328911L;
    private long value;
    private static final int TX_GEN_SIZE = 20;
    private static final int LONG_SIZE = 64;
    private static final int TX_NUM_SIZE = 44;
    private static final long TX_GEN_MASK = 1048575L;
    private static final long TX_NUM_MASK = 0xFFFFFFFFFFFL;

    public static long assemble(int genNumber, long txNumber) {
        return (long)genNumber << 44 | txNumber & 0xFFFFFFFFFFFL;
    }

    public static int toGenerationNumber(long localIdValue) {
        return (int)(localIdValue >> 44 & 0xFFFFFL);
    }

    public static long toTransactionNumber(long localIdValue) {
        return localIdValue & 0xFFFFFFFFFFFL;
    }

    public static String toString(long l) {
        return "" + LocalId.toGenerationNumber(l) + ":" + LocalId.toTransactionNumber(l);
    }

    public static void toByteArray(long localIdValue, byte[] dst, int dstBegin) {
        dst[dstBegin + 0] = (byte)(0xFFL & localIdValue >>> 56);
        dst[dstBegin + 1] = (byte)(0xFFL & localIdValue >>> 48);
        dst[dstBegin + 2] = (byte)(0xFFL & localIdValue >>> 40);
        dst[dstBegin + 3] = (byte)(0xFFL & localIdValue >>> 32);
        dst[dstBegin + 4] = (byte)(0xFFL & localIdValue >>> 24);
        dst[dstBegin + 5] = (byte)(0xFFL & localIdValue >>> 16);
        dst[dstBegin + 6] = (byte)(0xFFL & localIdValue >>> 8);
        dst[dstBegin + 7] = (byte)(0xFFL & localIdValue >>> 0);
    }

    public static long fromByteArray(byte[] src, int srcBegin) {
        return (long)(src[srcBegin + 0] & 0xFF) << 56 | (long)(src[srcBegin + 1] & 0xFF) << 48 | (long)(src[srcBegin + 2] & 0xFF) << 40 | (long)(src[srcBegin + 3] & 0xFF) << 32 | (long)(src[srcBegin + 4] & 0xFF) << 24 | (long)(src[srcBegin + 5] & 0xFF) << 16 | (long)(src[srcBegin + 6] & 0xFF) << 8 | (long)(src[srcBegin + 7] & 0xFF);
    }

    public LocalId() {
    }

    public LocalId(long value) {
        this.value = value;
    }

    public LocalId(XidImpl xid) {
        this(xid.getLocalIdValue());
    }

    public long getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        return obj instanceof LocalId ? this.value == ((LocalId)obj).value : false;
    }

    public int hashCode() {
        return (int)this.value;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.value);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.value = in.readLong();
    }
}

