/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.taglib.html.facelets;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletException;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagAttributeException;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagHandler;
import java.io.IOException;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.ajax4jsf.framework.util.message.Messages;

public class KeepAliveHandler
extends TagHandler {
    private final TagAttribute beanName = this.getRequiredAttribute("beanName");
    private final TagAttribute ajaxOnly;

    public KeepAliveHandler(TagConfig config) {
        super(config);
        if (this.beanName != null && !this.beanName.isLiteral()) {
            throw new TagAttributeException(this.tag, this.beanName, Messages.getMessage("MUST_BE_LITERAL_ERROR"));
        }
        this.ajaxOnly = this.getAttribute("ajaxOnly");
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        String name = this.beanName.getValue();
        boolean isAjaxOnly = this.ajaxOnly != null ? this.ajaxOnly.getBoolean(ctx) : false;
        FacesContext facesContext = ctx.getFacesContext();
        String beanExpression = "#{" + name + "}";
        ValueBinding valueBinding = facesContext.getApplication().createValueBinding(beanExpression);
        Object bean = valueBinding.getValue(facesContext);
        String beanAttributeName = isAjaxOnly ? "org.ajax4jsf.ajaxviewbean:" : "org.ajax4jsf.viewbean:" + name;
        facesContext.getViewRoot().getAttributes().put(beanAttributeName, bean);
    }
}

