/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderkit.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.ajax.UIAjaxStatus;
import org.ajax4jsf.framework.renderer.RendererBase;
import org.ajax4jsf.framework.util.javascript.JSFunctionDefinition;

public class AjaxStatusRenderer
extends RendererBase {
    public static final String RENDERER_TYPE = "org.ajax4jsf.components.AjaxStatusRenderer";
    public static final String START_STYLE = "display: none";

    public void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        String statusId = component.getClientId(context);
        String tag = this.getTag(component);
        writer.startElement(tag, component);
        writer.writeAttribute("id", (Object)statusId, null);
        this.encodeSpan(writer, context, component, statusId, "start", tag);
        this.encodeSpan(writer, context, component, statusId, "stop", tag);
        writer.endElement(tag);
    }

    protected void encodeSpan(ResponseWriter writer, FacesContext context, UIComponent component, String id, String state, String tag) throws IOException {
        String styleClass;
        writer.startElement(tag, component);
        String spanId = id + "." + state;
        writer.writeAttribute("id", (Object)spanId, null);
        String style = this.getNamedAttribute(component, "Style", state);
        if ("start".equals(state)) {
            style = null == style ? START_STYLE : style + "; display: none";
        }
        if (null != style) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (null != (styleClass = this.getNamedAttribute(component, "StyleClass", state))) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        this.getUtils().encodePassThru(context, component);
        UIComponent facet = component.getFacet(state);
        if (null != facet) {
            this.renderChild(context, facet);
        } else {
            String namedAttribute = this.getNamedAttribute(component, "Text", state);
            if (null != namedAttribute) {
                writer.writeText((Object)namedAttribute, "text");
            }
        }
        writer.endElement(tag);
        Object eventHandler = component.getAttributes().get("on" + state);
        if (null != eventHandler) {
            StringBuffer script = new StringBuffer("\n");
            script.append("window.document.getElementById('").append(spanId).append("').on").append(state).append("=");
            JSFunctionDefinition function = new JSFunctionDefinition();
            function.addToBody(eventHandler).addToBody(";").appendScript(script);
            script.append(";\n");
            this.getUtils().writeScript(context, component, script);
        }
    }

    protected String getNamedAttribute(UIComponent component, String name, String state) {
        String fullName = state + name;
        return (String)component.getAttributes().get(fullName);
    }

    protected Class getComponentClass() {
        return UIAjaxStatus.class;
    }

    private String getTag(UIComponent status) {
        return "block".equals(status.getAttributes().get("layout")) ? "div" : "span";
    }

    public boolean getRendersChildren() {
        return true;
    }
}

