/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.component.UISelectMany;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.ValueBinding;
import javax.faces.model.SelectItem;
import org.ajax4jsf.framework.util.InputUtils;
import org.ajax4jsf.framework.util.message.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SelectUtils {
    private static final Log log = LogFactory.getLog((Class)SelectUtils.class);

    public static List getSelectItems(FacesContext context, UIComponent component) {
        ArrayList<Object> list = new ArrayList<Object>();
        Iterator kids = component.getChildren().iterator();
        while (kids.hasNext()) {
            String valueClass;
            Object value;
            UIComponent kid = (UIComponent)kids.next();
            if (kid instanceof UISelectItem) {
                value = ((UISelectItem)kid).getValue();
                if (value == null) {
                    UISelectItem item = (UISelectItem)kid;
                    list.add(new SelectItem(item.getItemValue(), item.getItemLabel(), item.getItemDescription(), item.isItemDisabled()));
                    continue;
                }
                if (value instanceof SelectItem) {
                    list.add(value);
                    continue;
                }
                valueClass = value != null ? "'" + value.getClass().getName() + "'" : "";
                throw new IllegalArgumentException(Messages.getMessage("INVALID_ATTRIBUTE_VALUE", valueClass, "<selectItem>"));
            }
            if (!(kid instanceof UISelectItems) || null == context) continue;
            value = ((UISelectItems)kid).getValue();
            if (value instanceof SelectItem) {
                list.add(value);
                continue;
            }
            if (value instanceof SelectItem[]) {
                SelectItem[] items = (SelectItem[])value;
                for (int i = 0; i < items.length; ++i) {
                    list.add(items[i]);
                }
                continue;
            }
            if (value instanceof Collection) {
                Iterator elements = ((Collection)value).iterator();
                while (elements.hasNext()) {
                    list.add(elements.next());
                }
                continue;
            }
            if (value instanceof Map) {
                Iterator keys = ((Map)value).keySet().iterator();
                while (keys.hasNext()) {
                    Object val;
                    Object key = keys.next();
                    if (key == null || (val = ((Map)value).get(key)) == null) continue;
                    list.add(new SelectItem((Object)val.toString(), key.toString(), null));
                }
                continue;
            }
            valueClass = value != null ? "'" + value.getClass().getName() + "'" : "";
            throw new IllegalArgumentException(Messages.getMessage("INVALID_ATTRIBUTE_VALUE", valueClass, "<selectItems>"));
        }
        return list;
    }

    public static Object getConvertedUISelectManyValue(FacesContext facesContext, UISelectMany component, String[] submittedValue) throws ConverterException {
        Converter converter;
        if (submittedValue == null) {
            throw new NullPointerException("submittedValue");
        }
        ValueBinding vb = component.getValueBinding("value");
        Class valueType = null;
        Class arrayComponentType = null;
        if (vb != null && (valueType = vb.getType(facesContext)) != null && valueType.isArray()) {
            arrayComponentType = valueType.getComponentType();
        }
        if ((converter = component.getConverter()) == null) {
            if (valueType == null) {
                return submittedValue;
            }
            if (List.class.isAssignableFrom(valueType)) {
                int len = submittedValue.length;
                ArrayList<String> lst = new ArrayList<String>(len);
                for (int i = 0; i < len; ++i) {
                    lst.add(submittedValue[i]);
                }
                return lst;
            }
            if (arrayComponentType == null) {
                throw new IllegalArgumentException(Messages.getMessage("VALUE_BINDING_TYPE_ERROR"));
            }
            if (String.class.equals(arrayComponentType)) {
                return submittedValue;
            }
            if (Object.class.equals(arrayComponentType)) {
                return submittedValue;
            }
            try {
                converter = facesContext.getApplication().createConverter(arrayComponentType);
            }
            catch (FacesException e) {
                log.error((Object)Messages.getMessage("NO_CONVERTER_FOUND_ERROR", arrayComponentType.getName()), (Throwable)e);
                return submittedValue;
            }
        }
        if (valueType == null) {
            int len = submittedValue.length;
            Object[] convertedValues = (Object[])Array.newInstance(arrayComponentType == null ? Object.class : arrayComponentType, len);
            for (int i = 0; i < len; ++i) {
                convertedValues[i] = converter.getAsObject(facesContext, (UIComponent)component, submittedValue[i]);
            }
            return convertedValues;
        }
        if (List.class.isAssignableFrom(valueType)) {
            int len = submittedValue.length;
            ArrayList<Object> lst = new ArrayList<Object>(len);
            for (int i = 0; i < len; ++i) {
                lst.add(converter.getAsObject(facesContext, (UIComponent)component, submittedValue[i]));
            }
            return lst;
        }
        if (arrayComponentType == null) {
            throw new IllegalArgumentException(Messages.getMessage("VALUE_BINDING_TYPE_ERROR"));
        }
        if (arrayComponentType.isPrimitive()) {
            int len = submittedValue.length;
            Object convertedValues = Array.newInstance(arrayComponentType, len);
            for (int i = 0; i < len; ++i) {
                Array.set(convertedValues, i, converter.getAsObject(facesContext, (UIComponent)component, submittedValue[i]));
            }
            return convertedValues;
        }
        int len = submittedValue.length;
        ArrayList<Object> convertedValues = new ArrayList<Object>(len);
        for (int i = 0; i < len; ++i) {
            convertedValues.add(i, converter.getAsObject(facesContext, (UIComponent)component, submittedValue[i]));
        }
        return convertedValues.toArray((Object[])Array.newInstance(arrayComponentType, len));
    }

    public static Object getConvertedUIInputValue(FacesContext facesContext, UIInput component, String submittedValue) throws ConverterException {
        Object convertedValue = null;
        if (InputUtils.EMPTY_STRING.equals(submittedValue)) {
            return null;
        }
        Converter converter = SelectUtils.getConverterForProperty(facesContext, (UIOutput)component, "value");
        convertedValue = converter != null ? converter.getAsObject(facesContext, (UIComponent)component, submittedValue) : submittedValue;
        return convertedValue;
    }

    public static Converter getConverterForProperty(FacesContext facesContext, UIOutput component, String property) {
        Class valueType;
        ValueBinding valueBinding;
        Converter converter = component.getConverter();
        if (converter == null && (valueBinding = component.getValueBinding(property)) != null && (valueType = valueBinding.getType(facesContext)) != null && !String.class.equals(valueType) && !Object.class.equals(valueType) && (converter = facesContext.getApplication().createConverter(valueType)) == null) {
            throw new ConverterException(Messages.getMessage("NO_CONVERTER_FOUND_ERROR", valueType.getName()));
        }
        return converter;
    }
}

