/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.ajax.xmlfilter.nekko;

import java.util.EmptyStackException;
import org.ajax4jsf.framework.ajax.xmlfilter.BaseXMLFilter;
import org.ajax4jsf.framework.ajax.xmlfilter.HtmlParser;
import org.ajax4jsf.framework.ajax.xmlfilter.nekko.NekkoParser;
import org.ajax4jsf.io.parser.FastHtmlParser;
import org.apache.commons.collections.ArrayStack;

public class NekkoXMLFilter
extends BaseXMLFilter {
    private static final int STACK_SIZE = 100;
    private static ArrayStack _xhtmlParsersPool = new ArrayStack(100);

    protected HtmlParser getParser(String mimetype, boolean isAjax) {
        HtmlParser parser = null;
        if (isAjax) {
            parser = this.getXmlParser();
        } else if (mimetype.startsWith("text/html") || mimetype.startsWith("application/xhtml+xml")) {
            parser = new FastHtmlParser();
        } else {
            return null;
        }
        return parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reuseParser(HtmlParser parser) {
        if (null != parser && parser instanceof NekkoParser) {
            ArrayStack arrayStack = _xhtmlParsersPool;
            synchronized (arrayStack) {
                if (_xhtmlParsersPool.size() < 100) {
                    ((NekkoParser)parser).reset();
                    _xhtmlParsersPool.push((Object)parser);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HtmlParser getXmlParser() {
        NekkoParser parser;
        try {
            ArrayStack arrayStack = _xhtmlParsersPool;
            synchronized (arrayStack) {
                parser = (NekkoParser)_xhtmlParsersPool.pop();
            }
        }
        catch (EmptyStackException e) {
            parser = new NekkoParser();
            parser.setPublicId(this.getPublicid());
            parser.setSystemid(this.getSystemid());
            parser.setNamespace(this.getNamespace());
        }
        return parser;
    }
}

