/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.ajax;

import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.ajax4jsf.framework.ajax.AjaxComponent;
import org.ajax4jsf.framework.ajax.AjaxContext;
import org.ajax4jsf.framework.ajax.AjaxEvent;
import org.ajax4jsf.framework.ajax.AjaxListener;
import org.ajax4jsf.framework.ajax.AjaxSingleEvent;
import org.ajax4jsf.framework.ajax.AjaxSingleException;
import org.ajax4jsf.framework.ajax.AjaxSource;

public abstract class AjaxActionComponent
extends UICommand
implements AjaxComponent,
AjaxSource {
    public static final String FOCUS_DATA_ID = "_A4J.AJAX.focus";

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof AjaxSingleEvent) {
            throw new AjaxSingleException(this.getSingleComponent());
        }
        super.broadcast(event);
        if (event instanceof AjaxEvent) {
            String focus;
            FacesContext context = this.getFacesContext();
            this.setupReRender(context);
            Object data = this.getData();
            AjaxContext ajaxContext = AjaxContext.getCurrentInstance(context);
            if (null != data) {
                ajaxContext.setResponseData(data);
            }
            if (null != (focus = this.getFocus())) {
                UIComponent focusComponent = this.findComponent(focus);
                if (null != focusComponent) {
                    focus = focusComponent.getClientId(context);
                }
                ajaxContext.getResponseDataMap().put(FOCUS_DATA_ID, focus);
            }
        }
    }

    protected void setupReRender() {
    }

    protected void setupReRender(FacesContext facesContext) {
        AjaxContext.getCurrentInstance(facesContext).addRegionsFromComponent((UIComponent)this);
        this.setupReRender();
    }

    public void queueEvent(FacesEvent event) {
        if (event instanceof ActionEvent && event.getComponent() == this) {
            if (this.isImmediate()) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else if (this.isBypassUpdates()) {
                event.setPhaseId(PhaseId.PROCESS_VALIDATIONS);
            } else {
                event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
            this.getParent().queueEvent(event);
            if (this.isAjaxSingle()) {
                super.queueEvent((FacesEvent)new AjaxSingleEvent((UIComponent)this));
            }
        } else {
            super.queueEvent(event);
        }
    }

    public void addAjaxListener(AjaxListener listener) {
        this.addFacesListener(listener);
    }

    public AjaxListener[] getAjaxListeners() {
        AjaxListener[] al = (AjaxListener[])this.getFacesListeners(AjaxListener.class);
        return al;
    }

    public void removeAjaxListener(AjaxListener listener) {
        this.removeFacesListener(listener);
    }

    protected UIComponent getSingleComponent() {
        return this;
    }
}

