/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.engines.javascript;

import java.rmi.RemoteException;
import org.apache.bsf.debug.jsdi.JsCode;
import org.apache.bsf.debug.jsdi.JsContext;
import org.apache.bsf.debug.jsdi.JsEngine;
import org.apache.bsf.debug.jsdi.JsObject;
import org.apache.bsf.debug.jsdi.JsdiException;
import org.apache.bsf.debug.util.Skeleton;
import org.apache.bsf.engines.javascript.RhinoContextProxy;
import org.apache.bsf.engines.javascript.RhinoEngineDebugger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.debug.DebugFrame;

public class JsContextStub
extends Skeleton
implements JsContext {
    RhinoContextProxy m_rcp;
    RhinoEngineDebugger m_rhinoDbg;
    DebugFrame m_frame;
    int m_frameno;
    boolean m_atBreakpoint;
    boolean m_invalid;

    public JsContextStub(RhinoContextProxy rhinoContextProxy, DebugFrame debugFrame, int n) throws RemoteException {
        super(106);
        this.m_rhinoDbg = rhinoContextProxy.getRhinoEngineDebugger();
        this.m_rcp = rhinoContextProxy;
        this.m_frame = debugFrame;
        this.m_frameno = n;
        this.m_invalid = false;
        this.m_atBreakpoint = true;
    }

    void atBreakpoint(boolean bl) {
        this.m_atBreakpoint = bl;
    }

    public JsObject bind(String string) throws RemoteException {
        try {
            Context.enter();
            for (Scriptable scriptable = this.m_frame.getVariableObject(); scriptable != null; scriptable = scriptable.getParentScope()) {
                Scriptable scriptable2 = scriptable;
                do {
                    if (!scriptable2.has(string, scriptable)) continue;
                    JsObject jsObject = this.m_rhinoDbg.marshallScriptable(scriptable);
                    return jsObject;
                } while ((scriptable2 = scriptable2.getPrototype()) != null);
            }
            throw new JsdiException("Name not in scope.");
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsCode getCode() {
        if (this.m_invalid) {
            throw new JsdiException("This context no longer exists.");
        }
        if (!this.m_atBreakpoint) {
            throw new JsdiException("Resumed context, can't get the code.");
        }
        try {
            Context.enter();
            JsCode jsCode = null;
            return jsCode;
        }
        finally {
            Context.exit();
        }
    }

    public int getDepth() {
        return this.m_frameno;
    }

    public JsEngine getEngine() {
        RhinoEngineDebugger rhinoEngineDebugger = this.m_rcp.getRhinoEngineDebugger();
        return (JsEngine)rhinoEngineDebugger.getDebugInterface();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineNumber() {
        if (this.m_invalid) {
            throw new JsdiException("This context no longer exists.");
        }
        if (!this.m_atBreakpoint) {
            throw new JsdiException("Resumed context, can't get line number.");
        }
        try {
            Context.enter();
            int n = this.m_frame.getLineNumber();
            return n;
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsObject getScope() throws RemoteException {
        if (this.m_invalid) {
            throw new JsdiException("This context no longer exists.");
        }
        if (!this.m_atBreakpoint) {
            throw new JsdiException("Resumed context, can't get line number.");
        }
        try {
            JsObject jsObject;
            Context.enter();
            Scriptable scriptable = this.m_frame.getVariableObject();
            JsObject jsObject2 = jsObject = this.m_rhinoDbg.marshallScriptable(scriptable);
            return jsObject2;
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSourceName() {
        if (this.m_invalid) {
            throw new JsdiException("This context no longer exists.");
        }
        if (!this.m_atBreakpoint) {
            throw new JsdiException("Resumed context, can't get line number.");
        }
        try {
            Context.enter();
            String string = this.m_frame.getSourceName();
            return string;
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsObject getThis() throws RemoteException {
        if (this.m_invalid) {
            throw new JsdiException("This context no longer exists.");
        }
        if (!this.m_atBreakpoint) {
            throw new JsdiException("Resumed context, can't get line number.");
        }
        try {
            Context.enter();
            JsObject jsObject = null;
            Scriptable scriptable = null;
            NativeCall nativeCall = null;
            Scriptable scriptable2 = this.m_frame.getVariableObject();
            if (scriptable2 instanceof NativeCall) {
                nativeCall = (NativeCall)scriptable2;
                scriptable = nativeCall.getThisObj();
                jsObject = this.m_rhinoDbg.marshallScriptable(scriptable2);
            }
            JsObject jsObject2 = jsObject;
            return jsObject2;
        }
        finally {
            Context.exit();
        }
    }

    void invalidate() {
        this.m_invalid = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEvalContext() {
        if (this.m_invalid) {
            throw new JsdiException("This context no longer exists.");
        }
        if (!this.m_atBreakpoint) {
            throw new JsdiException("Resumed context, can't get line number.");
        }
        try {
            Context.enter();
            boolean bl = false;
            return bl;
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFunctionContext() {
        if (this.m_invalid) {
            throw new JsdiException("This context no longer exists.");
        }
        if (!this.m_atBreakpoint) {
            throw new JsdiException("Resumed context, can't get line number.");
        }
        try {
            Context.enter();
            boolean bl = false;
            return bl;
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isScriptContext() {
        if (this.m_invalid) {
            throw new JsdiException("This context no longer exists.");
        }
        if (!this.m_atBreakpoint) {
            throw new JsdiException("Resumed context, can't get line number.");
        }
        try {
            Context.enter();
            boolean bl = true;
            return bl;
        }
        finally {
            Context.exit();
        }
    }

    public Object lookupName(String string) {
        try {
            Context.enter();
            for (Scriptable scriptable = this.m_frame.getVariableObject(); scriptable != null; scriptable = scriptable.getParentScope()) {
                Scriptable scriptable2 = scriptable;
                do {
                    Object object;
                    if ((object = scriptable2.get(string, scriptable)) == Scriptable.NOT_FOUND) continue;
                    Object object2 = object;
                    return object2;
                } while ((scriptable2 = scriptable2.getPrototype()) != null);
            }
            throw new JsdiException("Name is not in scope.");
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookupName(Scriptable scriptable, String string) {
        try {
            Scriptable scriptable2;
            Context.enter();
            for (Scriptable scriptable3 = scriptable; scriptable3 != null; scriptable3 = scriptable3.getParentScope()) {
                scriptable2 = scriptable3;
                do {
                    Object object;
                    if ((object = scriptable2.get(string, scriptable3)) == Scriptable.NOT_FOUND) continue;
                    Object object2 = object;
                    return object2;
                } while ((scriptable2 = scriptable2.getPrototype()) != null);
            }
            scriptable2 = null;
            return scriptable2;
        }
        finally {
            Context.exit();
        }
    }
}

