/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.debug.clientImpl;

public class CircularBuffer {
    Object[] m_elements = new Object[256];
    int m_pos;
    int m_end;

    private void grow() {
        Object[] objectArray = this.m_elements;
        this.m_elements = new Object[2 * this.m_elements.length];
        if (this.m_pos <= this.m_end) {
            for (int i = this.m_pos; i < this.m_end; ++i) {
                this.m_elements[i] = objectArray[i];
            }
        } else {
            int n;
            for (n = 0; n < this.m_end; ++n) {
                this.m_elements[n] = objectArray[n];
            }
            for (n = this.m_pos; n < objectArray.length; ++n) {
                this.m_elements[n + objectArray.length] = objectArray[n];
            }
            this.m_pos += objectArray.length;
        }
    }

    public synchronized void push(Object object) {
        if (this.m_end == this.m_elements.length) {
            if (this.m_pos == 0) {
                this.grow();
            } else {
                this.m_end = 0;
            }
            this.m_elements[this.m_end++] = object;
            return;
        }
        if (this.m_pos <= this.m_end) {
            this.m_elements[this.m_end++] = object;
            return;
        }
        if (this.m_end == this.m_pos - 1) {
            this.grow();
        }
        this.m_elements[this.m_end++] = object;
    }

    public boolean isEmpty() {
        return this.m_pos == this.m_end;
    }

    public Object pop() {
        if (this.m_pos == this.m_end) {
            return null;
        }
        Object object = this.m_elements[this.m_pos++];
        if (this.m_pos == this.m_elements.length && this.m_pos != this.m_end) {
            this.m_pos = 0;
        }
        return object;
    }
}

