/*
 * Decompiled with CFR 0.152.
 */
package xjavadoc;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import xjavadoc.AbstractClass;
import xjavadoc.BinaryClass;
import xjavadoc.ClassIterator;
import xjavadoc.ConstructorImpl;
import xjavadoc.DefaultXTag;
import xjavadoc.MethodImpl;
import xjavadoc.PackageIterator;
import xjavadoc.ParameterImpl;
import xjavadoc.Primitive;
import xjavadoc.SimpleNode;
import xjavadoc.SourceClass;
import xjavadoc.SourceSet;
import xjavadoc.UnknownClass;
import xjavadoc.XClass;
import xjavadoc.XCollections;
import xjavadoc.XDoc;
import xjavadoc.XJavaDocException;
import xjavadoc.XMethod;
import xjavadoc.XPackage;
import xjavadoc.filesystem.AbstractFile;

public final class XJavaDoc {
    public static final String IS_UNICODE = "true";
    public static final List PRIMITIVES = Collections.unmodifiableList(Arrays.asList("void", "byte", "short", "int", "long", "char", "float", "double", "boolean"));
    public static final int NO_IMPORTED_PACKAGES = 0;
    public static final int ONE_OR_MORE_IMPORTED_PACKAGES = 1;
    private static HashMap _primitiveClasses = new HashMap();
    private static XJavaDoc _instance = new XJavaDoc();
    private final Map _binaryClasses = new HashMap();
    private final Map _unknownClasses = new HashMap();
    private final Map _packages = new HashMap();
    private final Set _sourceSets = new HashSet();
    private final Map _sourceSetSourceClasses = new HashMap();
    private final Map _allSourceClasses = new HashMap();
    private Collection _sourceSetSourceClassesWithInnerClasses = new ArrayList();
    private long _birthday;
    private List _logMessages = new LinkedList();
    private boolean _useNodeParser = false;
    private Set _sourceSetClassNames = new TreeSet();
    private Map _properties = new HashMap();
    private Map _abstractFileClasses = new HashMap();

    private XJavaDoc() {
        this._birthday = System.currentTimeMillis();
    }

    public static boolean isUnicodeSupported() {
        if (IS_UNICODE.equals(IS_UNICODE)) {
            return true;
        }
        if (IS_UNICODE.equals("false")) {
            return false;
        }
        throw new Error("This XJavaDoc wasn't built with Ant, so it's impossible to tell whether we support unicode or not");
    }

    public static XJavaDoc getInstance() {
        return _instance;
    }

    public static void printMemoryStatus() {
        System.out.println("ParameterImpl instances:   " + ParameterImpl.instanceCount);
        System.out.println("MethodImpl instances:      " + MethodImpl.instanceCount);
        System.out.println("ConstructorImpl instances: " + ConstructorImpl.instanceCount);
        System.out.println("SimpleNode instances:      " + SimpleNode.instanceCount);
        System.out.println("SourceClass instances:     " + SourceClass.instanceCount);
        System.out.println("XDoc instances:            " + XDoc.instanceCount);
        System.out.println("DefaultXTag instances:     " + DefaultXTag.instanceCount);
        System.out.println("BinaryClass instances:     " + BinaryClass.instanceCount);
        System.out.println("UnknownClass instances:    " + UnknownClass.instanceCount);
        System.out.println("Total memory:    " + Runtime.getRuntime().totalMemory() / 0x100000L);
        System.out.println("Free memory:    " + Runtime.getRuntime().freeMemory() / 0x100000L);
    }

    public static String replaceProperties(String value, Map keys) {
        if (value == null) {
            return null;
        }
        ArrayList fragments = new ArrayList();
        ArrayList propertyRefs = new ArrayList();
        XJavaDoc.parsePropertyString(value, fragments, propertyRefs);
        StringBuffer sbuf = new StringBuffer();
        Iterator i = fragments.iterator();
        Iterator j = propertyRefs.iterator();
        while (i.hasNext()) {
            String fragment = (String)i.next();
            if (fragment == null) {
                String propertyName = (String)j.next();
                fragment = keys.containsKey(propertyName) ? (String)keys.get(propertyName) : "${" + propertyName + '}';
            }
            sbuf.append(fragment);
        }
        return sbuf.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static void parsePropertyString(String value, List fragments, List propertyRefs) {
        String fragment;
        int pos;
        int prev = 0;
        while ((pos = value.indexOf(36, prev)) >= 0) {
            void var4_4;
            if (var4_4 > 0) {
                fragment = value.substring(prev, (int)var4_4);
                fragments.add(fragment);
            }
            if (var4_4 == value.length() - 1) {
                fragments.add("$");
                prev = var4_4 + true;
                continue;
            }
            if (value.charAt((int)(var4_4 + true)) != '{') {
                fragments.add(value.substring((int)var4_4, (int)(var4_4 + true)));
                prev = var4_4 + true;
                continue;
            }
            int endName = value.indexOf(125, (int)var4_4);
            if (endName < 0) {
                String fragment2 = value.substring((int)var4_4);
                fragments.add(fragment2);
                continue;
            }
            String propertyName = value.substring((int)(var4_4 + 2), endName);
            fragments.add(null);
            propertyRefs.add(propertyName);
            prev = endName + 1;
        }
        if (prev < value.length()) {
            fragment = value.substring(prev);
            fragments.add(fragment);
        }
    }

    static Primitive getPrimitive(String name) {
        return (Primitive)_primitiveClasses.get(name);
    }

    private static final void addPrimitive(String name) {
        _primitiveClasses.put(name, new Primitive(name));
    }

    public Collection getSourceClasses(Predicate predicate) {
        return CollectionUtils.select((Collection)this.getSourceClasses(), (Predicate)predicate);
    }

    public Collection getSourceClasses(boolean useNodeParser, boolean inner) {
        if (inner) {
            return this.getSourceClasses();
        }
        return this.getSourceClasses(new NoInnerClassesPredicate());
    }

    public Collection getSourceClasses(boolean useNodeParser) {
        return this.getSourceClasses();
    }

    public Collection getSourceClasses() {
        if (this._sourceSetSourceClassesWithInnerClasses.isEmpty()) {
            this._sourceSetSourceClassesWithInnerClasses.addAll(this.getOuterSourceClasses());
            ClassIterator outers = XCollections.classIterator(this.getOuterSourceClasses());
            while (outers.hasNext()) {
                this.addInnerClassRecursive(outers.next(), this._sourceSetSourceClassesWithInnerClasses);
            }
        }
        return Collections.unmodifiableCollection(this._sourceSetSourceClassesWithInnerClasses);
    }

    public Collection getSourcePackages() {
        TreeSet<XPackage> packages = new TreeSet<XPackage>();
        Collection classes = this.getSourceClasses();
        ClassIterator i = XCollections.classIterator(classes);
        while (i.hasNext()) {
            packages.add(i.next().getContainingPackage());
        }
        return Collections.unmodifiableCollection(packages);
    }

    public Map getPropertyMap() {
        return Collections.unmodifiableMap(this._properties);
    }

    public XClass getXClass(String qualifiedName) {
        if (qualifiedName.equals("")) {
            throw new IllegalStateException("Classname can't be empty String");
        }
        AbstractClass result = null;
        Primitive primitive = XJavaDoc.getPrimitive(qualifiedName);
        if (primitive != null) {
            result = primitive;
        } else {
            SourceClass sourceClass = (SourceClass)this._allSourceClasses.get(qualifiedName);
            if (sourceClass != null) {
                result = sourceClass;
            } else {
                BinaryClass binaryClass = (BinaryClass)this._binaryClasses.get(qualifiedName);
                if (binaryClass != null) {
                    result = binaryClass;
                } else {
                    UnknownClass unknownClass = (UnknownClass)this._unknownClasses.get(qualifiedName);
                    if (unknownClass != null) {
                        result = unknownClass;
                    } else if (this.sourceExists(qualifiedName)) {
                        sourceClass = this.scanAndPut(qualifiedName);
                        result = sourceClass;
                    } else {
                        Class clazz = this.getClass(qualifiedName);
                        if (clazz != null) {
                            binaryClass = new BinaryClass(clazz);
                            this._binaryClasses.put(qualifiedName, binaryClass);
                            result = binaryClass;
                        } else {
                            result = new UnknownClass(qualifiedName);
                            this._unknownClasses.put(qualifiedName, result);
                        }
                    }
                }
            }
        }
        return result;
    }

    public XPackage getSourcePackage(String packageName) {
        Iterator i = this.getSourcePackages().iterator();
        while (i.hasNext()) {
            XPackage p = (XPackage)i.next();
            if (!p.getName().equals(packageName)) continue;
            return p;
        }
        return null;
    }

    public void setUseNodeParser(boolean useNodeParser) {
        this._useNodeParser = useNodeParser;
    }

    public void setPropertyMap(Map _properties) {
        this._properties = _properties;
    }

    public void printLogMessages(PrintStream out, int level) {
        boolean printedHeader = false;
        Iterator i = this._logMessages.iterator();
        while (i.hasNext()) {
            LogMessage m = (LogMessage)i.next();
            if (m._level != level) continue;
            if (!printedHeader) {
                if (level == 1) {
                    out.println("WARNING: Some classes refer to other classes that were not found among the sources or on the classpath.");
                    out.println("         (Perhaps the referred class doesn't exist? Hasn't been generated yet?)");
                    out.println("         The referring classes do not import any fully qualified classes matching these classes.");
                    out.println("         Since at least one package is imported, it is impossible for xjavadoc to figure out");
                    out.println("         what package the referred classes belong to. The classes are:");
                } else {
                    out.println("INFO:    Some classes refer to other classes that were not found among the sources or on the classpath.");
                    out.println("         (Perhaps the referred class doesn't exist? Hasn't been generated yet?)");
                    out.println("         The referring classes do not import any fully qualified classes matching these classes.");
                    out.println("         However, since no packages are imported, xjavadoc has assumed that the referred classes");
                    out.println("         belong to the same package as the referring class. The classes are:");
                }
                printedHeader = true;
            }
            out.println(m._sourceClass.getQualifiedName() + " --> " + m._unqualifiedClassName + " qualified to " + m._unknownClass.getQualifiedName());
        }
    }

    public void addSourceSet(SourceSet sourceSet) {
        this._sourceSets.add(sourceSet);
        int j = 0;
        while (j < sourceSet.getSize()) {
            String qualifiedName = sourceSet.getQualifiedName(j);
            if (this._sourceSetClassNames.contains(qualifiedName)) {
                String msg = "The class \"" + qualifiedName + "\" occurs more than once. That's illegal.";
                System.err.println(msg);
            }
            this._sourceSetClassNames.add(qualifiedName);
            ++j;
        }
    }

    public void addAbstractFile(String qualifiedName, AbstractFile file) {
        this._abstractFileClasses.put(qualifiedName, file);
        if (this._sourceSetClassNames.contains(qualifiedName)) {
            String msg = "The class \"" + qualifiedName + "\" occurs more than once. That's illegal.";
            System.err.println(msg);
        }
        this._sourceSetClassNames.add(qualifiedName);
    }

    public void reset() {
        PackageIterator iterator = XCollections.packageIterator(this._packages.values());
        while (iterator.hasNext()) {
            XPackage xPackage = iterator.next();
            Collection classes = xPackage.getClasses();
            ClassIterator i = XCollections.classIterator(classes);
            while (i.hasNext()) {
                AbstractClass clazz = (AbstractClass)i.next();
                clazz.reset();
            }
        }
        this._logMessages.clear();
        this._sourceSetClassNames.clear();
        this._allSourceClasses.clear();
        this._sourceSetSourceClasses.clear();
        this._binaryClasses.clear();
        this._unknownClasses.clear();
        this._packages.clear();
        this._sourceSets.clear();
        this._properties.clear();
        this._abstractFileClasses.clear();
        this._sourceSetSourceClassesWithInnerClasses.clear();
        SourceClass._qualifiedClasses.clear();
        this._birthday = System.currentTimeMillis();
    }

    public XClass updateMethodTag(String className, String methodNameWithSignature, String tagName, String parameterName, String parameterValue, int tagIndex) throws XJavaDocException {
        XClass clazz = this.getXClass(className);
        XMethod method = clazz.getMethod(methodNameWithSignature);
        XDoc doc = method.getDoc();
        doc.updateTagValue(tagName, parameterName, parameterValue, tagIndex);
        return clazz;
    }

    public XClass updateClassTag(String className, String tagName, String parameterName, String parameterValue, int tagIndex) throws XJavaDocException {
        XClass clazz = this.getXClass(className);
        XDoc doc = clazz.getDoc();
        doc.updateTagValue(tagName, parameterName, parameterValue, tagIndex);
        return clazz;
    }

    public String dereferenceProperties(String value) {
        return XJavaDoc.replaceProperties(value, this._properties);
    }

    final boolean classExists(String qualifiedClassName) {
        if (this.sourceExists(qualifiedClassName)) {
            return true;
        }
        return this.getClass(qualifiedClassName) != null;
    }

    void logMessage(SourceClass clazz, UnknownClass unknownClass, String unqualifiedClassName, int level) {
        this._logMessages.add(new LogMessage(clazz, unknownClass, unqualifiedClassName, level));
    }

    XPackage addPackageMaybe(String packageName) {
        XPackage result = (XPackage)this._packages.get(packageName);
        if (result == null) {
            result = new XPackage(packageName);
            this._packages.put(packageName, result);
        }
        return result;
    }

    void addSourceClass(SourceClass sourceClass) {
        this._allSourceClasses.put(sourceClass.getQualifiedName(), sourceClass);
        if (this._sourceSetClassNames.contains(sourceClass.getQualifiedName()) || sourceClass.isExtraClass()) {
            this._sourceSetSourceClasses.put(sourceClass.getQualifiedName(), sourceClass);
        }
    }

    private final Class getClass(String qualifiedName) {
        try {
            return Class.forName(qualifiedName, false, this.getClass().getClassLoader());
        }
        catch (Throwable e) {
            return null;
        }
    }

    private Collection getOuterSourceClasses() {
        if (this._sourceSetSourceClasses.isEmpty()) {
            Iterator i = this._sourceSetClassNames.iterator();
            while (i.hasNext()) {
                String qualifiedName = (String)i.next();
                this.getXClass(qualifiedName);
            }
            Iterator iterator = this._abstractFileClasses.keySet().iterator();
            while (iterator.hasNext()) {
                String fqcn = (String)iterator.next();
                this.getXClass(fqcn);
            }
        }
        ArrayList new_collection = new ArrayList(this._sourceSetSourceClasses.values());
        return Collections.unmodifiableCollection(new_collection);
    }

    private AbstractFile getSourceFile(String qualifiedName) {
        AbstractFile found = null;
        Iterator i = this._sourceSets.iterator();
        while (i.hasNext()) {
            SourceSet sourceSet = (SourceSet)i.next();
            AbstractFile javaFile = sourceSet.getSourceFile(qualifiedName);
            if (javaFile == null) continue;
            found = javaFile;
        }
        return found;
    }

    private void addInnerClassRecursive(XClass outer, Collection c) {
        ClassIterator inners = XCollections.classIterator(outer.getInnerClasses());
        while (inners.hasNext()) {
            XClass inner = inners.next();
            c.add(inner);
            this.addInnerClassRecursive(inner, c);
        }
    }

    private boolean sourceExists(String qualifiedName) {
        boolean sourceFileExists;
        AbstractFile sourceFile = this.getSourceFile(qualifiedName);
        if (sourceFile != null && sourceFile.lastModified() > this._birthday) {
            return false;
        }
        boolean bl = sourceFileExists = sourceFile != null;
        if (!sourceFileExists) {
            sourceFileExists = this._abstractFileClasses.containsKey(qualifiedName);
        }
        return sourceFileExists;
    }

    private SourceClass scanAndPut(String qualifiedName) {
        AbstractFile sourceFile = this.getSourceFile(qualifiedName);
        AbstractFile abstractFile = sourceFile = sourceFile != null ? sourceFile : (AbstractFile)this._abstractFileClasses.get(qualifiedName);
        if (sourceFile == null) {
            throw new IllegalStateException("No source found for " + qualifiedName);
        }
        SourceClass sourceClass = new SourceClass(sourceFile, this._useNodeParser);
        return sourceClass;
    }

    static {
        int i = 0;
        while (i < PRIMITIVES.size()) {
            XJavaDoc.addPrimitive((String)PRIMITIVES.get(i));
            ++i;
        }
    }

    class LogMessage {
        public final SourceClass _sourceClass;
        public final UnknownClass _unknownClass;
        public final String _unqualifiedClassName;
        public final int _level;

        LogMessage(SourceClass sourceClass, UnknownClass unknownClass, String unqualifiedClassName, int level) {
            this._sourceClass = sourceClass;
            this._unknownClass = unknownClass;
            this._unqualifiedClassName = unqualifiedClassName;
            this._level = level;
        }
    }

    public static final class NoInnerClassesPredicate
    implements Predicate {
        public boolean evaluate(Object o) {
            XClass clazz = (XClass)o;
            return !clazz.isInner();
        }
    }
}

