/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.state;

import com.arjuna.ats.arjuna.logging.tsLogger;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class InputBuffer {
    protected boolean _valid;
    private DataInputStream _input;
    private ByteArrayInputStream _inputStream;
    private byte[] _byteArray;

    public InputBuffer() {
        this._byteArray = null;
        this._valid = false;
        this._inputStream = null;
        this._input = null;
    }

    public InputBuffer(byte[] b) {
        this._valid = true;
        this._byteArray = new byte[b.length];
        System.arraycopy(b, 0, this._byteArray, 0, b.length);
        try {
            this._inputStream = new ByteArrayInputStream(this._byteArray);
            this._input = new DataInputStream(this._inputStream);
            this.skipHeader();
        }
        catch (IOException e) {
            this._valid = false;
        }
    }

    public InputBuffer(InputBuffer buff) {
        this._byteArray = null;
        this._valid = false;
        this._inputStream = null;
        this._input = null;
        this.copy(buff);
    }

    public final synchronized boolean valid() {
        return this._valid;
    }

    public synchronized void copy(InputBuffer buff) {
        if (buff._valid) {
            this._byteArray = new byte[buff._byteArray.length];
            this._valid = true;
            System.arraycopy(buff._byteArray, 0, this._byteArray, 0, buff._byteArray.length);
            try {
                this._inputStream = new ByteArrayInputStream(this._byteArray);
                this._input = new DataInputStream(this._inputStream);
                this.skipHeader();
            }
            catch (IOException e) {
                this._valid = false;
            }
        }
    }

    public final synchronized int length() {
        return this._byteArray == null ? 0 : this._byteArray.length;
    }

    public final synchronized byte[] buffer() {
        return this._byteArray;
    }

    public final synchronized void setBuffer(byte[] b) {
        this._byteArray = new byte[b.length];
        System.arraycopy(b, 0, this._byteArray, 0, b.length);
        try {
            this._inputStream = new ByteArrayInputStream(this._byteArray);
            this._input = new DataInputStream(this._inputStream);
            this._valid = true;
            this.skipHeader();
        }
        catch (Exception e) {
            this._byteArray = null;
            this._valid = false;
        }
    }

    public final synchronized byte unpackByte() throws IOException {
        if (!this._valid) {
            throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.state.InputBuffer_1"));
        }
        int i = this.unpackInt();
        return (byte)i;
    }

    public final synchronized byte[] unpackBytes() throws IOException {
        if (!this._valid) {
            throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.state.InputBuffer_2"));
        }
        int index = this.unpackInt();
        int size = this.unpackInt();
        byte[] b = new byte[size];
        if (size > 0) {
            this._input.readFully(b);
            this.realign(size);
        }
        return b;
    }

    public final synchronized boolean unpackBoolean() throws IOException {
        if (!this._valid) {
            throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.state.InputBuffer_3"));
        }
        this._valid = false;
        this._inputStream.skip(3L);
        boolean b = this._input.readBoolean();
        this._valid = true;
        return b;
    }

    public final synchronized char unpackChar() throws IOException {
        if (!this._valid) {
            throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.state.InputBuffer_4"));
        }
        int i = this.unpackInt();
        return (char)i;
    }

    public final synchronized short unpackShort() throws IOException {
        if (!this._valid) {
            throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.state.InputBuffer_5"));
        }
        int i = this.unpackInt();
        return (short)i;
    }

    public final synchronized int unpackInt() throws IOException {
        if (!this._valid) {
            throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.state.InputBuffer_6"));
        }
        this._valid = false;
        int i = this._input.readInt();
        this._valid = true;
        return i;
    }

    public final synchronized long unpackLong() throws IOException {
        if (!this._valid) {
            throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.state.InputBuffer_7"));
        }
        this._valid = false;
        long l = this._input.readLong();
        this._valid = true;
        return l;
    }

    public final synchronized float unpackFloat() throws IOException {
        if (!this._valid) {
            throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.state.InputBuffer_8"));
        }
        this._valid = false;
        float f = this._input.readFloat();
        this._valid = true;
        return f;
    }

    public final synchronized double unpackDouble() throws IOException {
        if (!this._valid) {
            throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.state.InputBuffer_9"));
        }
        this._valid = false;
        double d = this._input.readDouble();
        this._valid = true;
        return d;
    }

    public final synchronized String unpackString() throws IOException {
        if (!this._valid) {
            throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.state.InputBuffer_10"));
        }
        int index = this.unpackInt();
        int length = this.unpackInt();
        if (length == 0) {
            return null;
        }
        byte[] b = new byte[length - 1];
        byte[] dummy = new byte[1];
        this._input.read(b, 0, length - 1);
        this._input.read(dummy, 0, 1);
        this.realign(length);
        return new String(b);
    }

    public synchronized void unpackFrom(InputBuffer buff) throws IOException {
        if (buff == null) {
            throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.state.InputBuffer_11"));
        }
        this._valid = false;
        int i = buff.unpackInt();
        this._byteArray = new byte[i];
        for (int j = 0; j < i; ++j) {
            this._byteArray[j] = buff.unpackByte();
        }
        this._valid = true;
        try {
            this._inputStream = new ByteArrayInputStream(this._byteArray);
            this._input = new DataInputStream(this._inputStream);
            this.skipHeader();
        }
        catch (IOException e) {
            this._valid = false;
        }
    }

    public final boolean reread() {
        if (!this._valid) {
            return false;
        }
        try {
            this._inputStream = new ByteArrayInputStream(this._byteArray);
            this._input = new DataInputStream(this._inputStream);
            this.skipHeader();
        }
        catch (IOException e) {
            this._valid = false;
        }
        return this._valid;
    }

    public void print(PrintWriter strm) {
        if (this._valid) {
            strm.println("InputBuffer : \n");
            strm.println("InputBuffer : \n");
            for (int i = 0; i < this._byteArray.length; ++i) {
                strm.write((char)this._byteArray[i]);
            }
        } else {
            strm.println("InputBuffer : invalid.");
        }
    }

    private final void realign(int amount) throws IOException {
        if (amount % 4 > 0) {
            int excess = 4 - amount % 4;
            if (this._inputStream.available() < excess) {
                excess = this._inputStream.available();
            }
            this._input.skipBytes(excess);
        }
    }

    private final void skipHeader() throws IOException {
        this._inputStream.skip(8L);
    }
}

