/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.SVGFontFace;
import org.apache.batik.bridge.SVGFontFaceElementBridge;
import org.apache.batik.bridge.SVGFontFamily;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.svg.XMLBaseSupport;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.gvt.font.GVTFontFamily;
import org.apache.batik.gvt.font.UnresolvedFontFamily;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class SVGFontUtilities
implements SVGConstants {
    public static GVTFontFamily getFontFamily(Element textElement, BridgeContext ctx, String fontFamilyName, String fontWeight, String fontStyle) {
        String fontKeyName = fontFamilyName.toLowerCase() + " " + fontWeight + " " + fontStyle;
        Map fontFamilyMap = ctx.getFontFamilyMap();
        GVTFontFamily fontFamily = (GVTFontFamily)fontFamilyMap.get(fontKeyName);
        if (fontFamily != null) {
            return fontFamily;
        }
        Document doc = textElement.getOwnerDocument();
        NodeList fontFaceElements = doc.getElementsByTagNameNS("http://www.w3.org/2000/svg", "font-face");
        Vector<SVGFontFamily> svgFontFamilies = new Vector<SVGFontFamily>();
        int i = 0;
        while (i < fontFaceElements.getLength()) {
            Element fontFaceElement = (Element)fontFaceElements.item(i);
            Element fontElement = SVGFontUtilities.findFontElement(fontFaceElement, fontFamilyName, ctx);
            if (fontElement != null) {
                SVGFontFaceElementBridge fontFaceBridge;
                SVGFontFace fontFace;
                String fontFaceStyle;
                Element fontFaceChild = null;
                Node n = fontElement.getFirstChild();
                while (n != null) {
                    if (n.getNodeType() == 1 && n.getNamespaceURI().equals("http://www.w3.org/2000/svg") && n.getLocalName().equals("font-face")) {
                        fontFaceChild = (Element)n;
                        break;
                    }
                    n = n.getNextSibling();
                }
                if (fontFaceChild != null && ((fontFaceStyle = (fontFace = (fontFaceBridge = (SVGFontFaceElementBridge)ctx.getBridge(fontFaceChild)).createFontFace(ctx, fontFaceChild)).getFontStyle()).equals("all") || fontFaceStyle.indexOf(fontStyle) != -1)) {
                    SVGFontFamily gvtFontFamily = new SVGFontFamily(fontFace, fontElement, ctx);
                    svgFontFamilies.add(gvtFontFamily);
                }
            }
            ++i;
        }
        if (svgFontFamilies.size() == 1) {
            fontFamilyMap.put(fontKeyName, svgFontFamilies.elementAt(0));
            return (GVTFontFamily)svgFontFamilies.elementAt(0);
        }
        if (svgFontFamilies.size() > 1) {
            String fontWeightNumber = SVGFontUtilities.getFontWeightNumberString(fontWeight);
            Vector<String> fontFamilyWeights = new Vector<String>();
            int i2 = 0;
            while (i2 < svgFontFamilies.size()) {
                SVGFontFace fontFace = ((SVGFontFamily)svgFontFamilies.get(i2)).getFontFace();
                String fontFaceWeight = fontFace.getFontWeight();
                fontFaceWeight = SVGFontUtilities.getFontWeightNumberString(fontFaceWeight);
                fontFamilyWeights.add(fontFaceWeight);
                ++i2;
            }
            Vector newFontFamilyWeights = (Vector)fontFamilyWeights.clone();
            int i3 = 100;
            while (i3 <= 900) {
                String weightString = String.valueOf(i3);
                boolean matched = false;
                int minDifference = 1000;
                int minDifferenceIndex = 0;
                int j = 0;
                while (j < fontFamilyWeights.size()) {
                    String fontFamilyWeight = (String)fontFamilyWeights.get(j);
                    if (fontFamilyWeight.indexOf(weightString) > -1) {
                        matched = true;
                        break;
                    }
                    StringTokenizer st = new StringTokenizer(fontFamilyWeight, " ,");
                    while (st.hasMoreTokens()) {
                        int weightNum = Integer.parseInt(st.nextToken());
                        int difference = Math.abs(weightNum - i3);
                        if (difference >= minDifference) continue;
                        minDifference = difference;
                        minDifferenceIndex = j;
                    }
                    ++j;
                }
                if (!matched) {
                    String newFontFamilyWeight = newFontFamilyWeights.elementAt(minDifferenceIndex) + ", " + weightString;
                    newFontFamilyWeights.setElementAt(newFontFamilyWeight, minDifferenceIndex);
                }
                i3 += 100;
            }
            int i4 = 0;
            while (i4 < svgFontFamilies.size()) {
                String fontFaceWeight = (String)newFontFamilyWeights.get(i4);
                if (fontFaceWeight.indexOf(fontWeightNumber) > -1) {
                    fontFamilyMap.put(fontKeyName, svgFontFamilies.get(i4));
                    return (GVTFontFamily)svgFontFamilies.elementAt(i4);
                }
                ++i4;
            }
            fontFamilyMap.put(fontKeyName, svgFontFamilies.elementAt(0));
            return (GVTFontFamily)svgFontFamilies.elementAt(0);
        }
        UnresolvedFontFamily gvtFontFamily = new UnresolvedFontFamily(fontFamilyName);
        fontFamilyMap.put(fontKeyName, gvtFontFamily);
        return gvtFontFamily;
    }

    protected static String getFontWeightNumberString(String fontWeight) {
        if (fontWeight.equals("normal")) {
            return "400";
        }
        if (fontWeight.equals("bold")) {
            return "700";
        }
        if (fontWeight.equals("all")) {
            return "100, 200, 300, 400, 500, 600, 700, 800, 900";
        }
        return fontWeight;
    }

    protected static Element findFontElement(Element ffElt, String family, BridgeContext ctx) {
        SVGOMDocument rdoc;
        Element fontElt;
        String ffname = ffElt.getAttributeNS(null, "font-family");
        if (ffname.length() < family.length()) {
            return null;
        }
        int idx = (ffname = ffname.toLowerCase()).indexOf(family.toLowerCase());
        if (idx == -1) {
            return null;
        }
        if (ffname.length() > family.length()) {
            int i;
            char c;
            boolean quote = false;
            if (idx > 0) {
                c = ffname.charAt(idx - 1);
                block0 : switch (c) {
                    default: {
                        return null;
                    }
                    case ' ': {
                        i = idx - 2;
                        while (i >= 0) {
                            switch (ffname.charAt(i)) {
                                default: {
                                    return null;
                                }
                                case ' ': {
                                    break;
                                }
                                case '\"': 
                                case '\'': {
                                    quote = true;
                                    break block0;
                                }
                            }
                            --i;
                        }
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        quote = true;
                    }
                    case ',': 
                }
            }
            if (idx + family.length() < ffname.length()) {
                c = ffname.charAt(idx + family.length());
                block9 : switch (c) {
                    default: {
                        return null;
                    }
                    case ' ': {
                        i = idx + family.length() + 1;
                        while (i < ffname.length()) {
                            switch (ffname.charAt(i)) {
                                default: {
                                    return null;
                                }
                                case ' ': {
                                    break;
                                }
                                case '\"': 
                                case '\'': {
                                    if (quote) break block9;
                                    return null;
                                }
                            }
                            ++i;
                        }
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        if (quote) break;
                        return null;
                    }
                    case ',': 
                }
            }
        }
        if ((fontElt = SVGUtilities.getParentElement(ffElt)).getNamespaceURI() == "http://www.w3.org/2000/svg" && fontElt.getLocalName().equals("font")) {
            return fontElt;
        }
        Node ffsrc = null;
        Node n = ffElt.getFirstChild();
        while (n != null) {
            if (n.getNodeType() == 1 && n.getNamespaceURI().equals("http://www.w3.org/2000/svg") && n.getLocalName().equals("font-face-src")) {
                ffsrc = (Element)n;
                break;
            }
            n = n.getNextSibling();
        }
        if (ffsrc == null) {
            return null;
        }
        Element ffuri = null;
        Node n2 = ffsrc.getFirstChild();
        while (n2 != null) {
            if (n2.getNodeType() == 1 && n2.getNamespaceURI().equals("http://www.w3.org/2000/svg") && n2.getLocalName().equals("font-face-uri")) {
                ffuri = (Element)n2;
                break;
            }
            n2 = n2.getNextSibling();
        }
        if (ffuri == null) {
            return null;
        }
        String uri = XLinkSupport.getXLinkHref(ffuri);
        Element ref = ctx.getReferencedElement(ffuri, uri);
        if (ref.getNamespaceURI() != "http://www.w3.org/2000/svg" || ref.getLocalName() != "font") {
            return null;
        }
        SVGOMDocument doc = (SVGOMDocument)ffuri.getOwnerDocument();
        boolean isLocal = doc == (rdoc = (SVGOMDocument)ref.getOwnerDocument());
        Element element = fontElt = isLocal ? ref : (Element)doc.importNode(ref, true);
        if (!isLocal) {
            String base = XMLBaseSupport.getCascadedXMLBase(ffuri);
            Element g = doc.createElementNS("http://www.w3.org/2000/svg", "g");
            g.appendChild(fontElt);
            g.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:base", base);
            CSSUtilities.computeStyleAndURIs(ref, fontElt, uri);
        }
        return fontElt;
    }
}

