/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.engine.sound;

import com.octo.captcha.CaptchaFactory;
import com.octo.captcha.engine.CaptchaEngineException;
import com.octo.captcha.engine.sound.SoundCaptchaEngine;
import com.octo.captcha.image.ImageCaptchaFactory;
import com.octo.captcha.sound.SoundCaptcha;
import com.octo.captcha.sound.SoundCaptchaFactory;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Random;

public class DefaultSoundCaptchaEngine
extends SoundCaptchaEngine {
    private SoundCaptchaFactory[] factories;
    private Random myRandom = new SecureRandom();

    public DefaultSoundCaptchaEngine(SoundCaptchaFactory[] factories) {
        this.factories = factories;
        if (factories == null || factories.length == 0) {
            throw new CaptchaEngineException("DefaultSoundCaptchaEngine cannot be constructed with a null or empty factories array");
        }
    }

    public final SoundCaptchaFactory getSoundCaptchaFactory() {
        return this.factories[this.myRandom.nextInt(this.factories.length)];
    }

    public final SoundCaptcha getNextSoundCaptcha() {
        return this.getSoundCaptchaFactory().getSoundCaptcha();
    }

    public SoundCaptcha getNextSoundCaptcha(Locale locale) {
        return this.getSoundCaptchaFactory().getSoundCaptcha(locale);
    }

    public CaptchaFactory[] getFactories() {
        return this.factories;
    }

    public void setFactories(CaptchaFactory[] factories) throws CaptchaEngineException {
        if (factories == null || factories.length == 0) {
            throw new CaptchaEngineException("impossible to set null or empty factories");
        }
        ArrayList<CaptchaFactory> tempFactories = new ArrayList<CaptchaFactory>();
        for (int i = 0; i < factories.length; ++i) {
            if (ImageCaptchaFactory.class.isAssignableFrom(factories[i].getClass())) {
                throw new CaptchaEngineException("This factory is not a sound captcha factory " + factories[i].getClass());
            }
            tempFactories.add(factories[i]);
        }
        this.factories = tempFactories.toArray(new SoundCaptchaFactory[factories.length]);
    }
}

