/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.engine.bufferedengine;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import com.octo.captcha.engine.CaptchaEngine;
import com.octo.captcha.engine.bufferedengine.BufferedEngineContainer;
import com.octo.captcha.engine.bufferedengine.ContainerConfiguration;
import com.octo.captcha.engine.bufferedengine.buffer.CaptchaBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;

public class SimpleBufferedEngineContainer
extends BufferedEngineContainer {
    private static final Log log = LogFactory.getLog((String)SimpleBufferedEngineContainer.class.getName());
    private ClockDaemon clockDaemonFeed;
    private ClockDaemon clockDaemonSwap;
    private Long feedPeriod = new Long(10000L);
    private Long swapPeriod = new Long(1000L);
    protected BeanFactory factory = null;

    public SimpleBufferedEngineContainer(CaptchaEngine engine, CaptchaBuffer memoryBuffer, CaptchaBuffer diskBuffer, ContainerConfiguration containerConfiguration, int feedPeriod, int swapPeriod) {
        super(engine, memoryBuffer, diskBuffer, containerConfiguration);
        this.swapPeriod = new Long(swapPeriod);
        this.feedPeriod = new Long(feedPeriod);
        this.startScheduler();
    }

    protected void startScheduler() {
        this.clockDaemonFeed = new ClockDaemon();
        this.clockDaemonSwap = new ClockDaemon();
        log.debug((Object)"daemons initialized");
        this.startDaemon();
    }

    protected void stopDaemon() {
        this.clockDaemonFeed.shutDown();
        this.clockDaemonSwap.shutDown();
    }

    protected void startDaemon() {
        this.clockDaemonFeed.executePeriodically(this.feedPeriod.longValue(), (Runnable)new SimpleDiskFeeder(), true);
        this.clockDaemonSwap.executePeriodically(this.swapPeriod.longValue(), (Runnable)new SimpleDiskToMemory(), true);
    }

    public class SimpleDiskToMemory
    implements Runnable {
        public void diskToMemory() {
            SimpleBufferedEngineContainer.this.swapCaptchasFromPersistentToVolatileMemory();
        }

        public void run() {
            this.diskToMemory();
        }
    }

    public class SimpleDiskFeeder
    implements Runnable {
        public void feedDisk() {
            SimpleBufferedEngineContainer.this.feedPersistentBuffer();
        }

        public void run() {
            this.feedDisk();
        }
    }
}

