//$Id: InterceptorTest.java 3838 2007-02-13 07:10:52Z gavin $
package org.jboss.seam.test;

import java.lang.reflect.Method;

import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;

import org.jboss.seam.Component;
import org.jboss.seam.RequiredException;
import org.jboss.seam.Seam;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.FacesApplicationContext;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.ConversationEntries;
import org.jboss.seam.core.Events;
import org.jboss.seam.core.FacesMessages;
import org.jboss.seam.core.Init;
import org.jboss.seam.core.Interpolator;
import org.jboss.seam.core.Manager;
import org.jboss.seam.core.PersistenceContexts;
import org.jboss.seam.interceptors.BijectionInterceptor;
import org.jboss.seam.interceptors.ConversationInterceptor;
import org.jboss.seam.interceptors.ConversationalInterceptor;
import org.jboss.seam.interceptors.RemoveInterceptor;
import org.jboss.seam.interceptors.ValidationInterceptor;
import org.jboss.seam.mock.MockApplication;
import org.jboss.seam.mock.MockExternalContext;
import org.jboss.seam.mock.MockFacesContext;
import org.jboss.seam.mock.MockServletContext;
import org.testng.annotations.Test;

public class InterceptorTest
{
   
   @Test
   public void testBijectionInterceptor() throws Exception
   {
      MockServletContext servletContext = new MockServletContext();
      MockExternalContext externalContext = new MockExternalContext(servletContext);
      Context appContext = new FacesApplicationContext(externalContext);
      appContext.set( Seam.getComponentName(Init.class), new Init() );
      appContext.set( 
            Seam.getComponentName(ConversationEntries.class) + ".component", 
            new Component(ConversationEntries.class, appContext) 
         );
      appContext.set( 
            Seam.getComponentName(Manager.class) + ".component", 
            new Component(Manager.class, appContext) 
         );
      appContext.set( 
            Seam.getComponentName(Foo.class) + ".component", 
            new Component(Foo.class, appContext) 
         );
      appContext.set( 
            Seam.getComponentName(Factory.class) + ".component", 
            new Component(Factory.class, appContext) 
         );

      Lifecycle.beginRequest( externalContext );
      Manager.instance().setCurrentConversationId("1");
      Lifecycle.resumeConversation( externalContext );
      Lifecycle.setPhaseId(PhaseId.RENDER_RESPONSE);
      
      final Bar bar = new Bar();
      final Foo foo = new Foo();
      Contexts.getSessionContext().set("otherFoo", foo);
      
      BijectionInterceptor bi = new BijectionInterceptor();
      bi.setComponent( new Component(Bar.class, appContext) );
      String result = (String) bi.aroundInvoke( new MockInvocationContext() {
         @Override
         public Object getTarget()
         {
            return bar;
         }

         @Override
         public Object proceed() throws Exception
         {
            assert bar.otherFoo==foo;
            assert bar.foo!=null;
            return bar.foo();
         }
      });
      assert "foo".equals(result);
      assert Contexts.getEventContext().get("otherString").equals("outAgain");
      assert Contexts.getConversationContext().get("string").equals("out");
      assert Contexts.getSessionContext().isSet("foo");
      assert bar.foo==null;
      assert bar.otherFoo==null;
      
      final Method method;
      try
      {
         method = Bar.class.getMethod("foo");
      }
      catch (Exception e) 
      {
         throw new RuntimeException(e);
      }

      bi.aroundInvoke( new MockInvocationContext() {
         @Override
         public Object getTarget()
         {
            return bar;
         }

         @Override
         public Object proceed() throws Exception
         {
            assert bar.otherFoo==foo;
            assert bar.foo!=null;
            return bar.foo();
         }
         @Override
         public Method getMethod()
         {
            return method;
         }
      });
      assert bar.foo==null;
      assert bar.otherFoo==null;
      
      try 
      {
         Contexts.getSessionContext().remove("otherFoo");
         bi.aroundInvoke( new MockInvocationContext() {
            @Override
            public Object getTarget()
            {
               return bar;
            }
            @Override
            public Object proceed() throws Exception
            {
               assert false;
               return null;
            }
            @Override
            public Method getMethod()
            {
               return method;
            }
         });
         assert false;
      }
      catch (Exception e)
      {
         assert e instanceof RequiredException;
      }
      
      final Method method2;
      try
      {
         method2 = BrokenAction.class.getMethod("go");
      }
      catch (Exception e) 
      {
         throw new RuntimeException(e);
      }

      final BrokenAction brokenAction = new BrokenAction();
      BijectionInterceptor biba = new BijectionInterceptor();
      biba.setComponent( new Component(BrokenAction.class, appContext) );
      try
      {
         biba.aroundInvoke( new MockInvocationContext() {
   
            @Override
            public Object getTarget() {
               return brokenAction;
            }   
            @Override
            public Object proceed() throws Exception {
               assert false;
               return null;
            }
            
            @Override
            public Method getMethod()
            {
               return method2;
            }
          
         } );
         assert false;
      }
      catch (Exception e)
      {
         assert e instanceof RequiredException;
      }
      
      final Method method3;
      try
      {
         method3 = Action.class.getMethod("go");
      }
      catch (Exception e) 
      {
         throw new RuntimeException(e);
      }

      final Action action = new Action();
      BijectionInterceptor bia = new BijectionInterceptor();
      bia.setComponent( new Component(Action.class, appContext) );
      result = (String) bia.aroundInvoke( new MockInvocationContext() {

         @Override
         public Object getTarget() {
            return action;
         }

         @Override
         public Object proceed() throws Exception {
            assert "Gavin King".equals(action.name);
            return action.go();
         }
         
         @Override
         public Method getMethod()
         {
            return method3;
         }
       
      } );
      assert "success".equals(result);
      assert Contexts.getConversationContext().get("name").equals("Gavin King");

      Lifecycle.endApplication(servletContext);
   }
   
   @Test
   public void testConversationInterceptor() throws Exception
   {
      MockServletContext servletContext = new MockServletContext();
      MockExternalContext externalContext = new MockExternalContext(servletContext);
      Context appContext = new FacesApplicationContext(externalContext);
      appContext.set( Seam.getComponentName(Init.class), new Init() );
      appContext.set( 
            Seam.getComponentName(ConversationEntries.class) + ".component", 
            new Component(ConversationEntries.class, appContext) 
         );
      appContext.set( 
            Seam.getComponentName(PersistenceContexts.class) + ".component", 
            new Component(PersistenceContexts.class, appContext) 
         );
      appContext.set( 
            Seam.getComponentName(Manager.class) + ".component", 
            new Component(Manager.class, appContext) 
         );
      Lifecycle.beginRequest( externalContext );
      Manager.instance().setCurrentConversationId("1");
      Lifecycle.resumeConversation(externalContext);

      ConversationInterceptor ci = new ConversationInterceptor();
      ci.setComponent( new Component(Foo.class, appContext) );
      
      assert !Manager.instance().isLongRunningConversation();

      String result = (String) ci.aroundInvoke( new MockInvocationContext() {
         @Override
         public Method getMethod()
         {
            return InterceptorTest.getMethod("foo");
         }
         @Override
         public Object proceed() throws Exception
         {
            return "foo";
         }
      });
      
      assert !Manager.instance().isLongRunningConversation();
      assert "foo".equals(result);
      
      Manager.instance().initializeTemporaryConversation();
      
      result = (String) ci.aroundInvoke( new MockInvocationContext() {
         @Override
         public Method getMethod()
         {
            return InterceptorTest.getMethod("begin");
         }
         @Override
         public Object proceed() throws Exception
         {
            return "begun";
         }
      });
      
      assert Manager.instance().isLongRunningConversation();
      assert "begun".equals(result);

      result = (String) ci.aroundInvoke( new MockInvocationContext() {
         @Override
         public Method getMethod()
         {
            return InterceptorTest.getMethod("foo");
         }
         @Override
         public Object proceed() throws Exception
         {
            return "foo";
         }
      });
      
      assert Manager.instance().isLongRunningConversation();
      assert "foo".equals(result);

      result = (String) ci.aroundInvoke( new MockInvocationContext() {
         @Override
         public Method getMethod()
         {
            return InterceptorTest.getMethod("end");
         }
         @Override
         public Object proceed() throws Exception
         {
            return "ended";
         }
      });
      
      assert !Manager.instance().isLongRunningConversation();
      assert "ended".equals(result);
      
      result = (String) ci.aroundInvoke( new MockInvocationContext() {
         @Override
         public Method getMethod()
         {
            return InterceptorTest.getMethod("beginNull");
         }
         @Override
         public Object proceed() throws Exception
         {
            return null;
         }
      });
      
      assert !Manager.instance().isLongRunningConversation();
      assert result==null;

      result = (String) ci.aroundInvoke( new MockInvocationContext() {
         @Override
         public Method getMethod()
         {
            return InterceptorTest.getMethod("beginVoid");
         }
         @Override
         public Object proceed() throws Exception
         {
            return null;
         }
      });
      
      assert Manager.instance().isLongRunningConversation();
      assert result==null;

      result = (String) ci.aroundInvoke( new MockInvocationContext() {
         @Override
         public Method getMethod()
         {
            return InterceptorTest.getMethod("foo");
         }
         @Override
         public Object proceed() throws Exception
         {
            return "foo";
         }
      });
      
      assert Manager.instance().isLongRunningConversation();
      assert "foo".equals(result);

      result = (String) ci.aroundInvoke( new MockInvocationContext() {
         @Override
         public Method getMethod()
         {
            return InterceptorTest.getMethod("endNull");
         }
         @Override
         public Object proceed() throws Exception
         {
            return null;
         }
      });
      
      assert Manager.instance().isLongRunningConversation();
      assert result==null;

      result = (String) ci.aroundInvoke( new MockInvocationContext() {
         @Override
         public Method getMethod()
         {
            return InterceptorTest.getMethod("endVoid");
         }
         @Override
         public Object proceed() throws Exception
         {
            return null;
         }
      });
      
      assert !Manager.instance().isLongRunningConversation();
      assert result==null;
      
      result = (String) ci.aroundInvoke( new MockInvocationContext() {
         @Override
         public Method getMethod()
         {
            return InterceptorTest.getMethod("beginIf");
         }
         @Override
         public Object proceed() throws Exception
         {
            return "failure";
         }
      });
      
      assert !Manager.instance().isLongRunningConversation();
      assert "failure".equals(result);

      result = (String) ci.aroundInvoke( new MockInvocationContext() {
         @Override
         public Method getMethod()
         {
            return InterceptorTest.getMethod("beginIf");
         }
         @Override
         public Object proceed() throws Exception
         {
            return "success";
         }
      });
      
      assert Manager.instance().isLongRunningConversation();
      assert "success".equals(result);

      result = (String) ci.aroundInvoke( new MockInvocationContext() {
         @Override
         public Method getMethod()
         {
            return InterceptorTest.getMethod("foo");
         }
         @Override
         public Object proceed() throws Exception
         {
            return "foo";
         }
      });
      
      assert Manager.instance().isLongRunningConversation();
      assert "foo".equals(result);

      result = (String) ci.aroundInvoke( new MockInvocationContext() {
         @Override
         public Method getMethod()
         {
            return InterceptorTest.getMethod("endIf");
         }
         @Override
         public Object proceed() throws Exception
         {
            return "failure";
         }
      });
      
      assert Manager.instance().isLongRunningConversation();
      assert "failure".equals(result);

      result = (String) ci.aroundInvoke( new MockInvocationContext() {
         @Override
         public Method getMethod()
         {
            return InterceptorTest.getMethod("endIf");
         }
         @Override
         public Object proceed() throws Exception
         {
            return "success";
         }
      });
      
      assert !Manager.instance().isLongRunningConversation();
      assert "success".equals(result);

      Lifecycle.endApplication(servletContext);
   }
   
   @Test
   public void testConversationalInterceptor() throws Exception
   {
      MockServletContext servletContext = new MockServletContext();
      MockExternalContext externalContext = new MockExternalContext(servletContext);
      Context appContext = new FacesApplicationContext(externalContext);
      appContext.set( Seam.getComponentName(Init.class), new Init() );
      appContext.set( 
            Seam.getComponentName(ConversationEntries.class) + ".component", 
            new Component(ConversationEntries.class, appContext) 
         );
      appContext.set( 
            Seam.getComponentName(Manager.class) + ".component", 
            new Component(Manager.class, appContext) 
         );
      appContext.set( 
            Seam.getComponentName(FacesMessages.class) + ".component", 
            new Component(FacesMessages.class, appContext) 
         );
      appContext.set( 
               Seam.getComponentName(Events.class) + ".component", 
               new Component(Events.class, appContext) 
            );
      Lifecycle.setPhaseId(PhaseId.INVOKE_APPLICATION);
      Lifecycle.beginRequest( externalContext );
      Manager.instance().setCurrentConversationId("1");
      Lifecycle.resumeConversation(externalContext);
      
      ConversationalInterceptor ci = new ConversationalInterceptor();
      ci.setComponent( new Component(Bar.class, appContext) );
      
      assert !Manager.instance().isLongRunningConversation();

      String result = (String) ci.aroundInvoke( new MockInvocationContext() {
         @Override
         public Method getMethod()
         {
            return InterceptorTest.getMethod("foo");
         }
         @Override
         public Object proceed() throws Exception
         {
            assert false;
            return null;
         }
      });
      
      //assert !Manager.instance().isLongRunningConversation();
      assert "error".equals(result);
      
      result = (String) ci.aroundInvoke( new MockInvocationContext() {
         @Override
         public Method getMethod()
         {
            return InterceptorTest.getMethod("begin");
         }
         @Override
         public Object proceed() throws Exception
         {
            return "begun";
         }
      });
      
      Manager.instance().initializeTemporaryConversation();
      Manager.instance().beginConversation("bar");
      
      //assert Manager.instance().isLongRunningConversation();
      assert "begun".equals(result);

      result = (String) ci.aroundInvoke( new MockInvocationContext() {
         @Override
         public Method getMethod()
         {
            return InterceptorTest.getMethod("foo");
         }
         @Override
         public Object proceed() throws Exception
         {
            return "foo";
         }
      });
      
      //assert Manager.instance().isLongRunningConversation();
      assert "foo".equals(result);

      result = (String) ci.aroundInvoke( new MockInvocationContext() {
         @Override
         public Method getMethod()
         {
            return InterceptorTest.getMethod("end");
         }
         @Override
         public Object proceed() throws Exception
         {
            return "ended";
         }
      });
      
      Manager.instance().endConversation(false);
      
      //assert !Manager.instance().isLongRunningConversation();
      assert "ended".equals(result);
      
      Lifecycle.endApplication(servletContext);
      
   }
   
   @Test
   public void testValidationInterceptor() throws Exception
   {
      MockServletContext servletContext = new MockServletContext();
      ExternalContext externalContext = new MockExternalContext(servletContext);
      new MockFacesContext( externalContext, new MockApplication() ).setCurrent().createViewRoot();
      
      Context appContext = new FacesApplicationContext(externalContext);
      appContext.set( Seam.getComponentName(Init.class), new Init() );
      appContext.set( 
            Seam.getComponentName(ConversationEntries.class) + ".component", 
            new Component(ConversationEntries.class, appContext) 
         );
      appContext.set( 
            Seam.getComponentName(Manager.class) + ".component", 
            new Component(Manager.class, appContext) 
         );
      appContext.set( 
            Seam.getComponentName(FacesMessages.class) + ".component", 
            new Component(FacesMessages.class, appContext) 
         );
      appContext.set(
            Seam.getComponentName(Interpolator.class) + ".component", 
            new Component(Interpolator.class, appContext)
         );
      Lifecycle.setPhaseId(PhaseId.INVOKE_APPLICATION);
      Lifecycle.beginRequest(externalContext);
      Manager.instance().setCurrentConversationId("1");
      Lifecycle.resumeConversation(externalContext);
      
      ValidationInterceptor vi = new ValidationInterceptor();
      vi.setComponent( new Component(Foo.class, appContext) );

      final Foo foo = new Foo();
      
      String result = (String) vi.aroundInvoke( new MockInvocationContext() {
         @Override
         public Method getMethod()
         {
            return InterceptorTest.getMethod("foo");
         }
         @Override
         public Object getTarget()
         {
            return foo;
         }

         @Override
         public Object proceed() throws Exception
         {
            return foo.foo();
         }
      });
      
      assert "foo".equals(result);
      FacesMessages.afterPhase();
      FacesMessages.instance().beforeRenderResponse();
      assert !FacesContext.getCurrentInstance().getMessages().hasNext();      
      
      result = (String) vi.aroundInvoke( new MockInvocationContext() {
         @Override
         public Method getMethod()
         {
            return InterceptorTest.getMethod("bar");
         }
         @Override
         public Object getTarget()
         {
            return foo;
         }

         @Override
         public Object proceed() throws Exception
         {
            assert false;
            return foo.bar();
         }
      });
            
      assert "baz".equals(result);
      FacesMessages.afterPhase();
      FacesMessages.instance().beforeRenderResponse();
      assert FacesContext.getCurrentInstance().getMessages().hasNext();      

      foo.setValue("not null");
      
      result = (String) vi.aroundInvoke( new MockInvocationContext() {
         @Override
         public Method getMethod()
         {
            return InterceptorTest.getMethod("bar");
         }
         @Override
         public Object getTarget()
         {
            return foo;
         }

         @Override
         public Object proceed() throws Exception
         {
            return foo.bar();
         }
      });
      
      assert "bar".equals(result);
      
      Lifecycle.endApplication(servletContext);
   }
   
   @Test 
   public void testRemoveInterceptor() throws Exception
   {
      MockServletContext servletContext = new MockServletContext();
      MockExternalContext externalContext = new MockExternalContext(servletContext);
      Context appContext = new FacesApplicationContext(externalContext);
      appContext.set( Seam.getComponentName(Init.class), new Init() );
      appContext.set( 
            Seam.getComponentName(ConversationEntries.class) + ".component", 
            new Component(ConversationEntries.class, appContext) 
         );
      appContext.set( 
            Seam.getComponentName(Manager.class) + ".component", 
            new Component(Manager.class, appContext) 
         );

      Lifecycle.beginRequest( externalContext );
      Contexts.getSessionContext().set( "foo", new Foo() );
      
      RemoveInterceptor ri = new RemoveInterceptor();
      ri.setComponent( new Component(Foo.class, appContext) );
      
      ri.aroundInvoke( new MockInvocationContext() {
         @Override
         public Method getMethod()
         {
            return InterceptorTest.getMethod("foo");
         }
      } );
      
      assert Contexts.getSessionContext().isSet("foo");
      
      ri.aroundInvoke( new MockInvocationContext() {
         @Override
         public Method getMethod()
         {
            return InterceptorTest.getMethod("destroy");
         }
      } );
      
      assert !Contexts.getSessionContext().isSet("foo");
      
      Lifecycle.endApplication(servletContext);
   }

   static Method getMethod(String name)
   {
      try
      {
         return Foo.class.getMethod(name);
      }
      catch (Exception e)
      {
         assert false;
         return null;
      }
   }
}
