/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb3.test.jaccpropagation;

import java.security.Principal;
import java.security.acl.Group;

import java.util.Set;
import java.util.Iterator;

import javax.annotation.Resource;
import javax.annotation.security.RolesAllowed;
import javax.ejb.Remote;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;

import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;

import org.jboss.annotation.security.SecurityDomain;
import org.jboss.logging.Logger;

import org.jboss.security.SecurityAssociation;

/**
 * @author <a href="mailto:bdecoste@jboss.com">William DeCoste</a>
 */
@Stateless
@Remote(SessionRemote.class)
@SecurityDomain("custom")
public class SessionBean implements SessionRemote
{
   private static final Logger log = Logger.getLogger(SessionBean.class);
   
   @Resource
   protected SessionContext sessionContext;
   
   @RolesAllowed({"allowed"})
   public String testCustomPrincipal() throws Exception
   {
      return test();
   }
   
   @RolesAllowed({"CustomRole1"})
   public String testCustomPrincipal1() throws Exception
   {
      return test();
   }
   
   @RolesAllowed({"CustomRole2"})
   public String testCustomPrincipal2() throws Exception
   {
      return test();
   }
   
   protected String test() throws Exception
   {
      String result = "";
      
      log.info("------------- testCustomPrincipal -------------");
      
      Principal principal = SecurityAssociation.getPrincipal();
      if (principal != null)
         log.info("    SA Principal " + principal.getClass() + " " + principal);
      
      
      Subject subject = SecurityAssociation.getSubject();
      if (subject != null)
         log.info("    SA Subject " + subject);
      
      subject = (Subject) PolicyContext.getContext("javax.security.auth.Subject.container"); 
    
      Set<Principal> principalSet = subject.getPrincipals();
	   Iterator<Principal> principalIter = principalSet.iterator();
      
	   while (principalIter.hasNext()){
			principal = (Principal)principalIter.next();
         if (!(principal instanceof Group))
         {
            result = principal.toString();
            log.info("    PolicyContext " + principal.getClass() + " " + principal);
         }
		}
   
      return result;
      
   }
   
}
