/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb3.test.ejbthree1109;

import java.util.UUID;

import javax.ejb.Remote;
import javax.ejb.RemoteHome;
import javax.ejb.Stateless;

import org.jboss.annotation.ejb.Clustered;
import org.jboss.annotation.ejb.RemoteBinding;
import org.jboss.ha.framework.interfaces.RoundRobin;
import org.jboss.logging.Logger;

/**
 * WaiterBean.
 * 
 * @author <a href="mailto:galder.zamarreno@jboss.com">Galder Zamarreno</a>
 */
@Stateless
@Clustered(loadBalancePolicy=RoundRobin.class)
@Remote(WaiterRemote.class)
@RemoteHome(WaiterRemoteHome.class)
@RemoteBinding(jndiBinding = "WaiterSlsbEjb21Bean/remote", interceptorStack = "TestClusteredStatelessSessionClientInterceptors")
public class WaiterSlsbEjb21Bean
{
   private static final Logger log = Logger.getLogger(WaiterSlsbEjb21Bean.class);
         
   private static final UUID id = UUID.randomUUID();

   public UUID whoServes(String servee)
   {
      log.info(id + " serves "+ servee);
      return id;
   }
}