/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb3.test.ejbthree1109;

import java.io.Serializable;

import javax.ejb.EJBHome;

import junit.framework.TestCase;

import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.metadata.SimpleMetaData;
import org.jboss.aspects.remoting.ClusterConstants;
import org.jboss.aspects.remoting.FamilyWrapper;
import org.jboss.aspects.remoting.InvokeRemoteInterceptor;
import org.jboss.ejb3.stateless.StatelessClusterProxyFactory;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;

/**
 * LoadBalanceAsserInterceptor.
 * 
 * @author <a href="mailto:galder.zamarreno@jboss.com">Galder Zamarreno</a>
 */
public class LoadBalanceAssertInterceptor implements Interceptor, ClusterConstants, Serializable
{
   /** The serialVersionUID */
   private static final long serialVersionUID = -4720740446500840159L;
   
   private static final Logger log = Logger.getLogger(LoadBalanceAssertInterceptor.class);
   
   private InvokerLocator prevChosenTarget;
   
   public String getName()
   {
      return LoadBalanceAssertInterceptor.class.getSimpleName();
   }

   public Object invoke(Invocation invocation) throws Throwable
   {
      String family = (String) invocation.getMetaData(CLUSTERED_REMOTING, CLUSTER_FAMILY);
      if (family.endsWith(StatelessClusterProxyFactory.HOME_FAMILY))
      {
         InvokerLocator chosenTarget = (InvokerLocator)invocation.getMetaData(InvokeRemoteInterceptor.REMOTING, InvokeRemoteInterceptor.INVOKER_LOCATOR);
         
         synchronized (this)
         {
            if (prevChosenTarget != null)
            {
               log.info("Compare targets, previous " + prevChosenTarget + " with chosen " + chosenTarget);
               TestCase.assertNotSame(prevChosenTarget, chosenTarget);
            }
            prevChosenTarget = chosenTarget;
         }
      }
      
      return invocation.invokeNext();
   }
}
