/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.ejb3.test.ear.unit;

import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;

import javax.naming.InitialContext;

import org.jboss.test.JBossTestCase;
import org.jboss.ejb3.test.factory.Session1;
import org.jboss.ejb3.test.factory.Session2;
import org.jboss.ejb3.test.factory.MyService;
import org.jboss.ejb3.test.factory.Util;
import org.jboss.ejb3.test.factory.Stateful1;
import org.jboss.ejb3.test.factory.Entity1;
import org.jboss.ejb3.test.factory.Entity2;
import org.jboss.ejb3.test.factory.unit.FactoryUnitTestCase;
import org.jboss.ejb3.test.mdb.Stateless;
import org.jboss.ejb3.test.ear.Facade;
import junit.framework.Test;

/**
 * Sample client for the jboss container.
 *
 * @author <a href="mailto:bill@burkecentral.com">Bill Burke</a>
 * @version $Id: FactoryUnitTestCase.java 58110 2006-11-04 08:34:21Z scott.stark@jboss.org $
 */

public class EarUnitTestCase
        extends JBossTestCase
{
   static boolean deployed = false;
   static int test = 0;

   public EarUnitTestCase(String name)
   {
      super(name);
   }

   public void testEarLib() throws Exception
   {
      Facade facade = (Facade)getInitialContext().lookup("ear-test/FacadeBean/remote");
      facade.testEarLib();
   }

   public void testReferencedEntity() throws Exception
   {
      Facade facade = (Facade)getInitialContext().lookup("ear-test/FacadeBean/remote");
      facade.testReferencedEntity();
   }
   
   public void testMessage() throws Exception
   {
      InitialContext jndiContext = new InitialContext();
      Queue queue = (Queue) getInitialContext().lookup("queue/eartest");
      QueueConnectionFactory factory = (QueueConnectionFactory)jndiContext.lookup("ConnectionFactory");
      QueueConnection connection = factory.createQueueConnection();
      QueueSession session = connection.createQueueSession(false, QueueSession.AUTO_ACKNOWLEDGE);
      QueueSender sender = session.createSender(queue);
      TextMessage msg = session.createTextMessage("Hello World");

      sender.send(msg);
      session.close();
      connection.close();

      Thread.sleep(2000);
   
      Facade facade = (Facade)getInitialContext().lookup("ear-test/FacadeBean/remote");
      assertTrue(facade.receivedMessage());
   }

   public static Test suite() throws Exception
   {
      return getDeploySetup(EarUnitTestCase.class,
		 "eartest-${jboss.jms.provider}-service.xml, ear-test.ear");
   }

}
