/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2007, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
  *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb3.test.classloader2.unit;

import javax.naming.NamingException;

import junit.framework.Test;

import org.jboss.ejb3.test.classloader2.Hello;
import org.jboss.test.JBossTestCase;

/**
 * Packaging xerces within an ear gives ClassCastExceptions during parsing of the jboss.xml
 * descriptor.
 * 
 * https://enterprise.redhat.com/issue-tracker/?module=issues&action=view&tid=176496&gid=1354
 * 
 * @author <a href="mailto:carlo.dewolf@jboss.com">Carlo de Wolf</a>
 * @version $Revision: $
 */
public class Classloader2UnitTestCase extends JBossTestCase
{
   public Classloader2UnitTestCase(String name)
   {
      super(name);
   }

   public void test1() throws Exception
   {
      Hello bean = (Hello) getInitialContext().lookup("classloader2/HelloBean/remote");
      String actual = bean.sayHi("me");
      
      assertEquals("Hi me", actual);
   }
   
   /**
    * Setup the test suite.
    */
   public static Test suite() throws Exception
   {
      return getDeploySetup(Classloader2UnitTestCase.class, "classloader2.ear");
   }
}
