/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ws.integration.jboss42;

// $Id: DeploymentInfoAdapter.java 2598 2007-03-12 10:11:14Z thomas.diesler@jboss.com $

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

import org.jboss.deployment.DeploymentInfo;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.WebMetaData;
import org.jboss.ws.core.server.UnifiedDeploymentInfo;
import org.jboss.ws.integration.ResourceLoaderAdapter;

/**
 * Build container independent deployment info. 
 *
 * @author Thomas.Diesler@jboss.org
 * @since 05-May-2006
 */
public class DeploymentInfoAdapter
{
   private WebMetaDataAdapter webMetaDataAdapter;
   private AbstractApplicationMetaDataAdapter applicationMetaDataAdapter;
   
   public void setApplicationMetaDataAdapter(AbstractApplicationMetaDataAdapter applicationMetaDataAdapter)
   {
      this.applicationMetaDataAdapter = applicationMetaDataAdapter;
   }

   public void setWebMetaDataAdapter(WebMetaDataAdapter webMetaDataAdapter)
   {
      this.webMetaDataAdapter = webMetaDataAdapter;
   }

   public UnifiedDeploymentInfo buildDeploymentInfo(UnifiedDeploymentInfo udi, DeploymentInfo di) throws Exception
   {
      if (di.parent != null)
      {
         udi.parent = new UnifiedDeploymentInfo(null);
         buildDeploymentInfo(udi.parent, di.parent);
      }
      
      udi.vfRoot = new ResourceLoaderAdapter(di.localCl);
      udi.name = di.getCanonicalName();
      udi.simpleName = di.shortName;
      udi.url = getDeploymentURL(di);
      udi.classLoader = di.annotationsCl;
      udi.deployedObject = di.deployedObject;
      
      buildMetaData(udi, di.metaData);

      return udi;
   }

   private URL getDeploymentURL(DeploymentInfo di) throws MalformedURLException
   {
      URL deploymentURL = (di.localUrl != null ? di.localUrl : di.url);
      if ("file".equals(deploymentURL.getProtocol()))
      {
         String path = deploymentURL.getPath();
         if (new File(path).isFile())
         {
            deploymentURL = new URL("jar:file:" + path + "!/");
         }
      }
      return deploymentURL;
   }

   private void buildMetaData(UnifiedDeploymentInfo udi, Object metaData)
   {
      if (metaData instanceof WebMetaData)
      {
         udi.metaData = webMetaDataAdapter.buildUnifiedWebMetaData((WebMetaData)metaData);
         udi.webappURL = udi.url;
      }
      else if (metaData instanceof ApplicationMetaData)
      {
         udi.metaData = applicationMetaDataAdapter.buildUnifiedApplicationMetaData((ApplicationMetaData)metaData);
      }
   }
}
