if (!window.DW) {
	window.DW = {};
}

if (!window.Richfaces) {
	window.Richfaces = {};
}

sizeA = 4;
sizeB = 40;

ModalPanel = Class.create();

{
	var searchString = "MSIE";
	var agent = navigator.userAgent;
	var idx = agent.indexOf(searchString);
	if (idx != -1) {
		var versIdx = agent.indexOf(";", idx);
		var versString;

		if (versIdx != -1) {
			versString = agent.substring(idx + searchString.length, versIdx);
		} else {
			versString = agent.substring(idx + searchString.length);
		}

		if (parseFloat(versString) < 7) {
			ModalPanel.disableSelects = true;
		}
	}
}

ModalPanel.panels = new Array();

A4J.AJAX.AddListener({
	onafterajax: function(req, event, data) {
		var i = 0;
		while (i < ModalPanel.panels.length) {
			var panel = ModalPanel.panels[i];

			var elt = panel.markerId;

			if (!Richfaces.isNodeInDOMTree(elt)) {
				panel.destroy();

				ModalPanel.panels.splice(i, 1);
				//check all panels again. maybe we've removed parent of any panel just now
				i = 0;
			} else {
				i++;
			}
		}
	}
});

ModalPanel.Context = Class.create();
ModalPanel.Context.prototype = {
	initialize: function(modalPanel) {
		this.cdiv = modalPanel.contentDiv;
		this.isPositionFixed = Richfaces.getComputedStyle(this.cdiv, "position") == "fixed";
	},

	left: function(offset) {
		return offset;
	},

	top: function(offset) {
		return offset;
	},

	width: function() {
		return this.cdiv.offsetWidth;
	},

	height: function() {
		return this.cdiv.offsetHeight;
	}
}

	function getSizeElement() {
		var element;
		if (document.compatMode=='CSS1Compat') {
			element = document.documentElement;
		} else {
			element = document.body;
		}

		return element;
	}


ModalPanel.prototype = {
	initialize: function(id, options) {
		this.markerId = $(id);

		this.id = $(id + "Container");

		this.options = options;

		this.baseZIndex = this.options.zindex ? this.options.zindex : 100;

		this.minWidth = Math.max(this.options.minWidth, 2*sizeA + 2);
		this.minHeight = Math.max(this.options.minHeight, 2*sizeA + 2);

		this.div = $(id + "Div");
		this.cursorDiv = $(id + "CursorDiv");
		this.cdiv = $(id + "CDiv");
		this.contentDiv = $(id + "ContentDiv");
		this.shadowDiv = $(id + "ShadowDiv");

		this.context = new ModalPanel.Context(this);

		this.borders = new Array();

		if (this.options.resizeable) {
			this.borders.push(new ModalPanel.Border(id + "ResizerNWU", this, "NW-resize", ModalPanel.Sizer.NWU));
			this.borders.push(new ModalPanel.Border(id + "ResizerN", this, "N-resize", ModalPanel.Sizer.N));
			this.borders.push(new ModalPanel.Border(id + "ResizerNEU", this, "NE-resize", ModalPanel.Sizer.NEU));
			this.borders.push(new ModalPanel.Border(id + "ResizerNEL", this, "NE-resize", ModalPanel.Sizer.NEL));
			this.borders.push(new ModalPanel.Border(id + "ResizerE", this, "E-resize", ModalPanel.Sizer.E));
			this.borders.push(new ModalPanel.Border(id + "ResizerSEU", this, "SE-resize", ModalPanel.Sizer.SEU));
			this.borders.push(new ModalPanel.Border(id + "ResizerSEL", this, "SE-resize", ModalPanel.Sizer.SEL));
			this.borders.push(new ModalPanel.Border(id + "ResizerS", this, "S-resize", ModalPanel.Sizer.S));
			this.borders.push(new ModalPanel.Border(id + "ResizerSWL", this, "SW-resize", ModalPanel.Sizer.SWL));
			this.borders.push(new ModalPanel.Border(id + "ResizerSWU", this, "SW-resize", ModalPanel.Sizer.SWU));
			this.borders.push(new ModalPanel.Border(id + "ResizerW", this, "W-resize", ModalPanel.Sizer.W));
			this.borders.push(new ModalPanel.Border(id + "ResizerNWL", this, "NW-resize", ModalPanel.Sizer.NWL));
		}

		if (this.options.moveable && $(id + "Header")) {
			this.header = new ModalPanel.Border(id + "Header", this, "move", ModalPanel.Header);
		}

		this.id.modalPanel = this;

		if (this.div.style.setExpression)
			if (ModalPanel.disableSelects /* IE 6 */ || Richfaces.getComputedStyle(this.div, "position") != "fixed" /* IE again, not in strict mode*/)

		{
			this.div.style.position = "absolute";
			this.cursorDiv.style.position = "absolute";

			//that is to apply filter
			this.div.style.width = "1px";
			this.div.style.height = "1px";
			this.cursorDiv.style.width = "1px";
			this.cursorDiv.style.height = "1px";

			this.cdiv.style.position = "absolute";

			this.cdiv.mpUseExpr = true;
		}

		ModalPanel.panels.push(this);
	},

	destroy: function() {

        this.traverseSelects(true);

		if (this.floatedToBody) {
			var parent = this.id.parentNode;
			if (parent) {
				parent.removeChild(this.id);
			}
		}
	},

	initIframe : function() {
        if (this.contentWindow) {
			Element.setStyle(this.contentWindow.document.body, { "margin" : "0px 0px 0px 0px" });
		} else {
			//TODO opera etc.

		}

		if("transparent" == Element.getStyle(document.body, "background-color")) {
			this.allowTransparency = true;
		}

		//this.style.opacity = "0.5";
		//this.style.filter='progid:DXImageTransform.Microsoft.Alpha(style=0,opacity=50)';
		//var iframeBodyStyle = this.contentWindow.document.body.style;
		//iframeBodyStyle.backgroundColor = "#d0d0d0";
		//iframeBodyStyle.filter = "alpha(opacity=50)";
		//iframeBodyStyle.opacity = "0.5";
		//iframeBodyStyle.zIndex = "99";
	},

	traverseSelects: function(enable) {
		if (!ModalPanel.disableSelects) {
			return ;
		}

		var children = document.body.childNodes;
		for (var k = 0; k < children.length; k++) {
			var child = children[k];
			if (child != this.id && child.getElementsByTagName) {

				var selects = child.getElementsByTagName("SELECT");

				for (var i = 0; i < selects.length; i++) {
					var elt = selects[i];

					if (enable) {
						if (elt._mdwCount) {
							elt._mdwCount -= 1;

							if (elt._mdwCount == 0) {
								if (elt._mdwDisabled) {
									elt._mdwDisabled = undefined;
								} else {
									elt.disabled = false;
								}

								elt._mdwCount = undefined;
							}
						}
					} else {
						if (elt._mdwCount) {
							elt._mdwCount += 1;
						} else {
							if (elt.disabled) {
								elt._mdwDisabled = true;
							} else {
								elt.disabled = true;
							}

							elt._mdwCount = 1;
						}
					}
				}
			}
		}
	},

	setLeft: function(pos) {
		if (this.cdiv.mpUseExpr) {
			this.cdiv.mpLeft = pos;
		} else {
			this.cdiv.style.left = pos + "px";
		}
	},

	setTop: function(pos) {
		if (this.cdiv.mpUseExpr) {
			this.cdiv.mpTop = pos;
		} else {
			this.cdiv.style.top = pos + "px";
		}
	},

	show: function(opts) {
		//this.disableDocumentFocusElements();

        if (!this.floatedToBody) {
			this.parent = this.id.parentNode;
			document.body.appendChild(this.id.parentNode.removeChild(this.id));
			this.floatedToBody = true;
		}

		if (ModalPanel.disableSelects && !this.iframe) {
			new Insertion.Top(this.cdiv,
			"<iframe src=\"javascript:''\" frameborder=\"0\" scrolling=\"no\" id=\"" + this.markerId.id + "IFrame\"" +
				"style=\"position: absolute; width: 1px; height: 1px; background-color: white; overflow-y: hidden; z-index: 1;\">" +
			"</iframe>");

			this.iframe = $(this.markerId.id + "IFrame");

			//alert("IFrame:" + this.iframe + "created!");

			this.iframe.onload = this.initIframe.bind(this.iframe);
		}

		var options = {};

		if (!this.cdiv.mpSet) {
			Object.extend(options, this.options);
		}

		if (opts) {
			Object.extend(options, opts);
		}

		if (options.width) {
			if (this.minWidth > options.width) {
				options.width = this.minWidth;
			}

			if (this.iframe) {
				this.iframe.style.width = options.width + 'px';
			}
			this.contentDiv.style.width = options.width + 'px';
			this.shadowDiv.style.width = options.width + 'px';
		}

		if (options.height) {
			if (this.minHeight > options.height) {
				options.height = this.minHeight;
			}

			if (this.iframe) {
				this.iframe.style.height = options.height + 'px';
			}
			this.contentDiv.style.height = options.height + 'px';
			this.shadowDiv.style.height = options.height + 'px';
		}

		if (options.left) {
			var _left;
			if (options.left != "auto") {
				_left = parseInt(options.left, 10);
			} else {
				var cw = getSizeElement().clientWidth;
				if (RichFaces.navigatorType() == "OPERA")
				 	_left = (cw - this.contentDiv.style.width.replace("px", "")) / 2;
				 else
					_left = (cw - Richfaces.getComputedStyleSize(this.contentDiv, "width")) / 2;

			}

			this.setLeft(_left);
		}

		if (options.top) {
			var _top;
			if (options.top != "auto") {
				_top = parseInt(options.top, 10);
			} else {
				var cw = getSizeElement().clientHeight;
				_top = (cw - Richfaces.getComputedStyleSize(this.contentDiv, "height")) / 2;
			}

			this.setTop(_top);
		}

		this.cdiv.mpSet = true;

		//Element.setStyle(this.dialogWindow.document.body, { "margin" : "0px 0px 0px 0px" });
		//if("transparent" == Element.getStyle(document.body, "background-color")) {
		//	this.iframe.allowTransparency = true;
		//}


		this.traverseSelects();

		//this.shape.init(this.cdiv, this.options);

		if (this.div.style.position == "absolute")
		{
			var we = "getSizeElement().clientWidth + \"px\"";
			var he = "getSizeElement().clientHeight + \"px\"";
			this.div.style.setExpression("width", we);
			this.div.style.setExpression("height", he);

			this.cursorDiv.style.setExpression("width", we);
			this.cursorDiv.style.setExpression("height", he);

			var le = "-Position.cumulativeOffset(this.parentNode)[0] + getSizeElement().scrollLeft + \"px\"";
			var te = "-Position.cumulativeOffset(this.parentNode)[1] + getSizeElement().scrollTop + \"px\"";

			this.div.style.setExpression("left", le);
			this.div.style.setExpression("top", te);

			this.cursorDiv.style.setExpression("left", le);
			this.cursorDiv.style.setExpression("top", te);


			var leftExpr = "(this.mpLeft || 0) + -Position.cumulativeOffset(this.parentNode)[0] + getSizeElement().scrollLeft + \"px\"";
			var topExpr = "(this.mpTop || 0) + -Position.cumulativeOffset(this.parentNode)[1] + getSizeElement().scrollTop + \"px\"";

			this.cdiv.style.setExpression("left", leftExpr);
			this.cdiv.style.setExpression("top", topExpr);


			/* That's how we output debug info - DOM inspector rulez */
			/*
			document.body.setExpression("_clientLeft", "getSizeElement().clientLeft");
			document.body.setExpression("_clientTop", "getSizeElement().clientTop");
			document.body.setExpression("_scrollLeft", "getSizeElement().scrollLeft");
			document.body.setExpression("_scrollTop", "getSizeElement().scrollTop");
			*/
			/* */
		}

		this.id.style.visibility = "hidden";

		Element.show(this.id);

		this.doResizeOrMove(ModalPanel.Sizer.Diff.EMPTY);

		for (var k = 0; k < this.borders.length; k++ ) {
			this.borders[k].doPosition();
		}

		if (this.header) {
			this.header.doPosition();
		}

		this.id.style.visibility = "";
	},

	startDrag: function(border) {
		for (var k = 0; k < this.borders.length; k++ ) {
			//this.borders[k].hide();
		}
	},

	endDrag: function(border) {
		for (var k = 0; k < this.borders.length; k++ ) {
			//this.borders[k].show();
			this.borders[k].doPosition();
		}
	},

	hide: function() {
		//this.enableDocumentFocusElements();

        this.traverseSelects(true);

		if (this.div.style.removeExpression) {
			this.div.style.removeExpression("width");
			this.div.style.removeExpression("height");

			this.div.style.removeExpression("left");
			this.div.style.removeExpression("top");

			this.cursorDiv.style.removeExpression("width");
			this.cursorDiv.style.removeExpression("height");

			this.cursorDiv.style.removeExpression("left");
			this.cursorDiv.style.removeExpression("top");

			this.cdiv.style.removeExpression("left");
			this.cdiv.style.removeExpression("top");
		}

		Element.hide(this.id);

		if (this.floatedToBody && this.parent) {
			document.body.removeChild(this.id);
			this.parent.appendChild(this.id);
			this.floatedToBody = false;
		}
	},

	doResizeOrMove: function(diff) {
		var vetoes = {};
		var cssHash = {};
		var cssHashWH = {};

		var vetoeChange = false;
		var newSize;
		// Avoid currentStyle bug in opera
		if (RichFaces.navigatorType() != "OPERA")
			newSize = Richfaces.getComputedStyleSize(this.contentDiv, "width");
		else
			newSize = parseInt(this.contentDiv.style.width.replace("px", ""), 10);

		var oldSize = newSize;
		newSize += diff.deltaWidth || 0;

		if (newSize >= this.minWidth) {
			if (diff.deltaWidth) {
				cssHashWH.width = newSize + 'px';
			}
		} else {
			if (diff.deltaWidth) {
				cssHashWH.width = this.minWidth + 'px';

				vetoes.vx = oldSize - this.minWidth;
			}

			vetoes.x = true;
		}

		if (vetoes.vx && diff.deltaX) {
			diff.deltaX = -vetoes.vx;
		}

		if (diff.deltaX && (vetoes.vx || !vetoes.x)) {
			if (vetoes.vx) {
				diff.deltaX = vetoes.vx;
			}
			var newPos;
			if (this.cdiv.mpUseExpr) {
				newPos = this.cdiv.mpLeft || 0;
				newPos += diff.deltaX;

				this.cdiv.mpLeft = newPos;
			} else {
				newPos = Richfaces.getComputedStyleSize(this.cdiv, "left");
				newPos += diff.deltaX;
				cssHash.left = newPos + 'px';
			}
		}

		var newSize = Richfaces.getComputedStyleSize(this.contentDiv, "height");
		var oldSize = newSize;
		newSize += diff.deltaHeight || 0;

		if (newSize >= this.minHeight) {
			if (diff.deltaHeight) {
				cssHashWH.height = newSize + 'px';
			}
		} else {
			if (diff.deltaHeight) {
				cssHashWH.height = this.minHeight + 'px';

				vetoes.vy = oldSize - this.minHeight;
			}

			vetoes.y = true;
		}

		if (vetoes.vy && diff.deltaY) {
			diff.deltaY = -vetoes.vy;
		}

		if (diff.deltaY && (vetoes.vy || !vetoes.y)) {
			if (vetoes.vy) {
				diff.deltaY = vetoes.vy;
			}

			var newPos;
			if (this.cdiv.mpUseExpr) {
				newPos = this.cdiv.mpTop || 0;
				newPos += diff.deltaY;

				this.cdiv.mpTop = newPos;
			} else {
				newPos = Richfaces.getComputedStyleSize(this.cdiv, "top");
				newPos += diff.deltaY;
				cssHash.top = newPos + 'px';
			}
		}

		Element.setStyle(this.cdiv, cssHash);

		Element.setStyle(this.contentDiv, cssHashWH);
		Element.setStyle(this.shadowDiv, cssHashWH);
		if (this.iframe) {
			Element.setStyle(this.iframe, cssHashWH);
		}

		var w = this.context.width();
		var h = this.context.height();

		this.context.reduced = null;

		if (w <= 2*sizeB) {
			this.context.reduced = {};
			this.context.reduced.w = w;
		}

		if (h <= 2*sizeB) {
			if (!this.context.reduced) {
				this.context.reduced = {};
			}

			this.context.reduced.h = h;
		}

		if (this.header) {
			this.header.doPosition();
		}

		return vetoes;
	}

}

Richfaces.findModalPanel = function (id) {
	if (id) {
		var prefId = (id.charAt(0) == ':' ? id : ':' + id);

		for (var i = 0; i < ModalPanel.panels.length; i++ ) {
			var pnl = ModalPanel.panels[i];
			if (pnl && pnl.markerId) {
				var pnlId = pnl.markerId.id;

				if (pnlId) {
					//try to match ids
					if (pnlId.length >= prefId.length) {
						var substr = pnlId.substring(pnlId.length - prefId.length, pnlId.length);
						if (substr == prefId) {
							return pnl.id;
						}
					}
				}
			}
		}
	}
}

Richfaces.showModalPanel = function (id, opts) {
	var panel = $(id + "Container");
	if (!panel) {
		panel = Richfaces.findModalPanel(id);
	}
	panel.modalPanel.show(opts);
}

Richfaces.hideModalPanel = function (id) {
	var panel = $(id + "Container");
	if (!panel) {
		panel = Richfaces.findModalPanel(id);
	}
	panel.modalPanel.hide();
}
