/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.wsdl.xml;

import com.ibm.wsdl.Constants;
import com.ibm.wsdl.util.xml.DOMUtils;
import com.ibm.wsdl.util.xml.XPathUtils;
import java.io.PrintWriter;
import java.io.Serializable;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.xml.namespace.QName;
import org.jbpm.bpel.sublang.def.Query;
import org.jbpm.bpel.wsdl.Property;
import org.jbpm.bpel.wsdl.PropertyAlias;
import org.jbpm.bpel.wsdl.xml.WsdlConstants;
import org.jbpm.bpel.wsdl.xml.WsdlUtil;
import org.jbpm.bpel.xml.util.DatatypeUtil;
import org.jbpm.bpel.xml.util.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PropertyAliasSerializer
implements ExtensionSerializer,
ExtensionDeserializer,
Serializable {
    private static final long serialVersionUID = 1L;

    public ExtensibilityElement unmarshall(Class parentType, QName elementType, Element elem, Definition def, ExtensionRegistry extReg) throws WSDLException {
        Element queryElem;
        PropertyAlias alias = (PropertyAlias)extReg.createExtension(parentType, elementType);
        def.addNamespace(elem.getPrefix(), elem.getNamespaceURI());
        String prefixedName = elem.getAttribute("propertyName");
        QName qualifiedName = XmlUtil.parseQName(prefixedName, elem);
        Property property = WsdlUtil.getProperty(def, qualifiedName);
        if (property == null) {
            property = (Property)extReg.createExtension(Definition.class, WsdlConstants.Q_PROPERTY);
            property.setQName(qualifiedName);
            def.addExtensibilityElement((ExtensibilityElement)property);
        }
        alias.setProperty(property);
        prefixedName = XmlUtil.getAttribute(elem, "messageType");
        if (prefixedName != null) {
            qualifiedName = XmlUtil.parseQName(prefixedName, elem);
            Message message = WsdlUtil.getMessage(def, qualifiedName);
            if (message == null) {
                message = def.createMessage();
                message.setQName(qualifiedName);
                def.addMessage(message);
            }
            alias.setMessage(message);
            String part = XmlUtil.getAttribute(elem, "part");
            if (part == null) {
                WSDLException e = new WSDLException("INVALID_WSDL", "part attribute missing");
                e.setLocation(XPathUtils.getXPathExprFromNode((Node)elem));
                throw e;
            }
            alias.setPart(part);
        } else {
            prefixedName = XmlUtil.getAttribute(elem, "type");
            if (prefixedName != null) {
                qualifiedName = XmlUtil.parseQName(prefixedName, elem);
                alias.setType(qualifiedName);
            } else {
                prefixedName = XmlUtil.getAttribute(elem, "element");
                if (prefixedName != null) {
                    qualifiedName = XmlUtil.parseQName(prefixedName, elem);
                    alias.setElement(qualifiedName);
                }
            }
        }
        String required = DOMUtils.getAttributeNS((Element)elem, (String)"http://schemas.xmlsoap.org/wsdl/", (String)"required");
        if (required != null) {
            alias.setRequired(DatatypeUtil.parseBoolean(required));
        }
        if ((queryElem = XmlUtil.getElement(elem, "http://schemas.xmlsoap.org/ws/2004/03/business-process/property", "query")) != null) {
            alias.setQuery(this.unmarshallQuery(queryElem));
        }
        return alias;
    }

    public void marshall(Class parentType, QName elementType, ExtensibilityElement extension, PrintWriter pw, Definition def, ExtensionRegistry extReg) throws WSDLException {
        Query query;
        if (extension == null) {
            return;
        }
        PropertyAlias alias = (PropertyAlias)extension;
        String tagName = DOMUtils.getQualifiedValue((String)"http://schemas.xmlsoap.org/ws/2004/03/business-process/property", (String)"propertyAlias", (Definition)def);
        pw.print("  <" + tagName);
        DOMUtils.printQualifiedAttribute((String)"propertyName", (QName)alias.getProperty().getQName(), (Definition)def, (PrintWriter)pw);
        Message message = alias.getMessage();
        if (message != null) {
            DOMUtils.printQualifiedAttribute((String)"messageType", (QName)message.getQName(), (Definition)def, (PrintWriter)pw);
            DOMUtils.printAttribute((String)"part", (String)alias.getPart(), (PrintWriter)pw);
        } else {
            QName type = alias.getType();
            if (type != null) {
                DOMUtils.printQualifiedAttribute((String)"type", (QName)type, (Definition)def, (PrintWriter)pw);
            } else {
                QName element = alias.getElement();
                if (element != null) {
                    DOMUtils.printQualifiedAttribute((String)"element", (QName)element, (Definition)def, (PrintWriter)pw);
                }
            }
        }
        Boolean required = alias.getRequired();
        if (required != null) {
            DOMUtils.printQualifiedAttribute((QName)Constants.Q_ATTR_REQUIRED, (String)required.toString(), (Definition)def, (PrintWriter)pw);
        }
        if ((query = alias.getQuery()) != null) {
            pw.println('>');
            this.marshallQuery(alias.getQuery(), pw, def);
            pw.println("  </" + tagName + '>');
        } else {
            pw.println("/>");
        }
    }

    protected Query unmarshallQuery(Element queryElem) {
        Query query = new Query();
        query.setLanguage(XmlUtil.getAttribute(queryElem, "queryLanguage"));
        query.setText(DOMUtils.getChildCharacterData((Element)queryElem));
        query.setNamespaces(XmlUtil.getNamespaces(queryElem));
        return query;
    }

    protected void marshallQuery(Query query, PrintWriter pw, Definition def) throws WSDLException {
        String queryTag = DOMUtils.getQualifiedValue((String)"http://schemas.xmlsoap.org/ws/2004/03/business-process/property", (String)"query", (Definition)def);
        pw.print("    <" + queryTag);
        DOMUtils.printAttribute((String)"queryLanguage", (String)query.getLanguage(), (PrintWriter)pw);
        pw.print('>');
        pw.print(DOMUtils.cleanString((String)query.getText()));
        pw.println("</" + queryTag + '>');
    }
}

