/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.sublang.xpath;

import java.util.Collections;
import java.util.List;
import org.jaxen.Context;
import org.jaxen.FunctionContext;
import org.jaxen.JaxenException;
import org.jaxen.expr.LocationPath;
import org.jbpm.bpel.graph.exe.BpelFaultException;
import org.jbpm.bpel.sublang.exe.QueryEvaluator;
import org.jbpm.bpel.sublang.xpath.XPathEvaluator;
import org.jbpm.bpel.xml.BpelConstants;
import org.jbpm.bpel.xml.util.XmlUtil;
import org.w3c.dom.Node;

class XPathQueryEvaluator
extends XPathEvaluator
implements QueryEvaluator {
    private static final FunctionContext functionLibrary = XPathQueryEvaluator.readFunctionLibrary("resource.query.functions");
    private static final long serialVersionUID = 1L;

    XPathQueryEvaluator(String text) throws JaxenException {
        super(text);
    }

    protected FunctionContext createFunctionContext() {
        return functionLibrary;
    }

    protected Context getContext(Object node) {
        Context context = new Context(this.getContextSupport());
        context.setNodeSet(Collections.singletonList(node));
        return context;
    }

    public Object evaluate(Node contextNode) {
        try {
            List nodeset = this.selectNodes(contextNode);
            return XPathQueryEvaluator.narrowToSingleNode(nodeset);
        }
        catch (JaxenException e) {
            throw new BpelFaultException(BpelConstants.FAULT_SUB_LANGUAGE_EXECUTION);
        }
    }

    public void assign(Node contextNode, Object value) {
        try {
            List nodes = XPathQueryEvaluator.selectOrCreateNodes((LocationPath)this.getRootExpr(), this.getContext(contextNode));
            XmlUtil.setObjectValue(XPathQueryEvaluator.narrowToSingleNode(nodes), value);
        }
        catch (JaxenException e) {
            throw new BpelFaultException(BpelConstants.FAULT_SUB_LANGUAGE_EXECUTION);
        }
    }
}

