/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.sublang.xpath;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jaxen.Context;
import org.jaxen.ContextSupport;
import org.jaxen.FunctionContext;
import org.jaxen.JaxenException;
import org.jaxen.VariableContext;
import org.jaxen.expr.Expr;
import org.jaxen.expr.FilterExpr;
import org.jaxen.expr.FunctionCallExpr;
import org.jaxen.expr.LiteralExpr;
import org.jaxen.expr.LocationPath;
import org.jaxen.expr.NumberExpr;
import org.jaxen.expr.Predicate;
import org.jaxen.expr.PredicateSet;
import org.jaxen.expr.VariableReferenceExpr;
import org.jbpm.bpel.BpelException;
import org.jbpm.bpel.sublang.exe.ExpressionEvaluator;
import org.jbpm.bpel.sublang.xpath.ExprVisitor;
import org.jbpm.bpel.sublang.xpath.TokenVariableContext;
import org.jbpm.bpel.sublang.xpath.XPathEvaluator;
import org.jbpm.bpel.variable.def.VariableDefinition;
import org.jbpm.bpel.variable.exe.MessageValue;
import org.jbpm.bpel.xml.util.XmlUtil;
import org.jbpm.graph.exe.Token;
import org.w3c.dom.Node;

class XPathExpressionEvaluator
extends XPathEvaluator
implements ExpressionEvaluator {
    private static final FunctionContext functionLibrary = XPathExpressionEvaluator.readFunctionLibrary("resource.expression.functions");
    private static final long serialVersionUID = 1L;

    XPathExpressionEvaluator(String text) throws JaxenException {
        super(text);
    }

    public Object evaluate(Token contextInfo) {
        List result = null;
        try {
            List nodeset = this.selectNodes(contextInfo);
            if (nodeset != null) {
                switch (nodeset.size()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        result = nodeset.get(0);
                        break;
                    }
                    default: {
                        result = nodeset;
                    }
                }
            }
        }
        catch (JaxenException e) {
            throw new BpelException("could not select nodes", (Exception)((Object)e));
        }
        return result;
    }

    public void assign(Token contextInfo, Object value) {
        Expr rootExpr = this.getRootExpr();
        Context context = this.getContext(contextInfo);
        if (rootExpr instanceof VariableReferenceExpr) {
            XPathExpressionEvaluator.assignVariable((VariableReferenceExpr)rootExpr, context, value);
        } else {
            new ExprAssigner().assign(rootExpr, context, value);
        }
    }

    private static void assignVariable(VariableReferenceExpr rootExpr, Context context, Object value) {
        String variableName = rootExpr.getVariableName();
        TokenVariableContext variableContext = (TokenVariableContext)context.getContextSupport().getVariableContext();
        int dotIndex = variableName.indexOf(46);
        if (dotIndex == -1) {
            VariableDefinition variableDefinition = variableContext.findVariableDefinition(variableName);
            if (variableDefinition == null) {
                throw new BpelException("variable not found: " + variableName);
            }
            Object valueForAssign = variableDefinition.getValueForAssign(variableContext.getToken());
            if (valueForAssign instanceof MessageValue) {
                throw new BpelException("illegal access to message variable: " + variableName);
            }
            variableDefinition.getType().setValue(valueForAssign, value);
        } else {
            String messageName = variableName.substring(0, dotIndex);
            VariableDefinition variableDefinition = variableContext.findVariableDefinition(messageName);
            if (variableDefinition == null) {
                throw new BpelException("variable not found: " + messageName);
            }
            Object valueForAssign = variableDefinition.getValueForAssign(variableContext.getToken());
            if (!(valueForAssign instanceof MessageValue)) {
                throw new BpelException("illegal access to part of non-message variable: " + variableName);
            }
            MessageValue messageValue = (MessageValue)valueForAssign;
            String partName = variableName.substring(dotIndex + 1);
            messageValue.setPart(partName, value);
        }
    }

    protected FunctionContext createFunctionContext() {
        return functionLibrary;
    }

    protected Context getContext(Object node) {
        ContextSupport support = new ContextSupport(this.getNamespaceContext(), this.getFunctionContext(), (VariableContext)new TokenVariableContext((Token)node), this.getNavigator());
        return new Context(support);
    }

    private class ExprAssigner
    extends ExprVisitor {
        private Context context;
        private Object result;

        private ExprAssigner() {
        }

        public void assign(Expr pathExpr, Context context, Object value) {
            this.context = context;
            this.visit(pathExpr);
            Node node = this.result instanceof List ? XPathEvaluator.narrowToSingleNode((List)this.result) : (Node)this.result;
            XmlUtil.setObjectValue(node, value);
        }

        public void visit(FilterExpr filterExpr) {
            this.visit(filterExpr.getExpr());
            if (this.result instanceof List) {
                this.result = this.evaluatePredicates(filterExpr.getPredicateSet(), (List)this.result, this.context.getContextSupport());
            }
        }

        public void visit(LocationPath locationPath) {
            this.context.setNodeSet(this.result instanceof List ? (List<Object>)this.result : Collections.singletonList(this.result));
            try {
                this.result = XPathEvaluator.selectOrCreateNodes(locationPath, this.context);
            }
            catch (JaxenException e) {
                throw new BpelException("could not select (or create) nodes", (Exception)((Object)e));
            }
        }

        public void visit(VariableReferenceExpr varExpr) {
            String variableName = varExpr.getVariableName();
            TokenVariableContext variableContext = (TokenVariableContext)this.context.getContextSupport().getVariableContext();
            int dotIndex = variableName.indexOf(46);
            if (dotIndex == -1) {
                VariableDefinition variableDefinition = variableContext.findVariableDefinition(variableName);
                if (variableDefinition == null) {
                    throw new BpelException("variable not found: " + variableName);
                }
                this.result = variableDefinition.getValueForAssign(variableContext.getToken());
            } else {
                String messageName = variableName.substring(0, dotIndex);
                VariableDefinition definition = variableContext.findVariableDefinition(messageName);
                if (definition == null) {
                    throw new BpelException("variable not found: " + messageName);
                }
                if (!definition.getType().isMessage()) {
                    throw new BpelException("illegal access to part of non-message variable: " + variableName);
                }
                MessageValue messageValue = (MessageValue)definition.getValueForAssign(variableContext.getToken());
                String partName = variableName.substring(dotIndex + 1);
                this.result = messageValue.getPartForAssign(partName);
            }
        }

        public void visit(LiteralExpr literalExpr) {
            try {
                this.result = literalExpr.evaluate(this.context);
            }
            catch (JaxenException e) {
                throw new BpelException("could not evaluate literal expression", (Exception)((Object)e));
            }
        }

        public void visit(NumberExpr numberExpr) {
            try {
                this.result = numberExpr.evaluate(this.context);
            }
            catch (JaxenException e) {
                throw new BpelException("could not evaluate number expression", (Exception)((Object)e));
            }
        }

        public void visit(FunctionCallExpr callExpr) {
            try {
                this.result = callExpr.evaluate(this.context);
            }
            catch (JaxenException e) {
                throw new BpelException("could not evaluate call expression", (Exception)((Object)e));
            }
        }

        private List evaluatePredicates(PredicateSet predicateSet, List nodes, ContextSupport support) {
            List predicates = predicateSet.getPredicates();
            if (!predicates.isEmpty()) {
                try {
                    Iterator predicateIt = predicateSet.getPredicates().iterator();
                    while (predicateIt.hasNext()) {
                        nodes = predicateSet.applyPredicate((Predicate)predicateIt.next(), nodes, support);
                    }
                }
                catch (JaxenException e) {
                    throw new BpelException("could not apply predicate", (Exception)((Object)e));
                }
            }
            return nodes;
        }
    }
}

