/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.integration.def;

import java.io.Serializable;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.jbpm.bpel.integration.IntegrationService;
import org.jbpm.bpel.integration.def.Correlations;
import org.jbpm.bpel.integration.def.MessageAction;
import org.jbpm.bpel.integration.def.ReceiveAction;
import org.jbpm.bpel.variable.def.VariableDefinition;
import org.jbpm.bpel.variable.exe.MessageValue;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;

public class ReplyAction
extends MessageAction
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String messageExchange;
    private VariableDefinition variable;
    private Correlations correlations;
    private QName faultName;

    public String getMessageExchange() {
        return this.messageExchange;
    }

    public void setMessageExchange(String messageExchange) {
        this.messageExchange = messageExchange;
    }

    public VariableDefinition getVariable() {
        return this.variable;
    }

    public void setVariable(VariableDefinition variable) {
        this.variable = variable;
    }

    public Correlations getCorrelations() {
        return this.correlations;
    }

    public void setCorrelations(Correlations correlations) {
        this.correlations = correlations;
    }

    public QName getFaultName() {
        return this.faultName;
    }

    public void setFaultName(QName faultName) {
        this.faultName = faultName;
    }

    public void execute(ExecutionContext exeContext) {
        IntegrationService integrationService = ReceiveAction.getIntegrationService(exeContext.getJbpmContext());
        integrationService.reply(this, exeContext.getToken());
        exeContext.leaveNode();
    }

    public Map writeMessage(Token token) {
        MessageValue messageValue = (MessageValue)this.variable.getValue(token);
        if (this.correlations != null) {
            this.correlations.ensureConstraint(messageValue, token);
        }
        return messageValue.getParts();
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this).append("partnerLink", (Object)this.getPartnerLink().getName()).append("operation", (Object)this.getOperation().getName());
        if (this.messageExchange != null) {
            builder.append("messageExchange", (Object)this.messageExchange);
        }
        return builder.toString();
    }
}

