/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.integration.def;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.jbpm.JbpmContext;
import org.jbpm.bpel.integration.IntegrationService;
import org.jbpm.bpel.integration.def.Correlations;
import org.jbpm.bpel.integration.def.InboundMessageActivity;
import org.jbpm.bpel.integration.def.MessageAction;
import org.jbpm.bpel.variable.def.VariableDefinition;
import org.jbpm.bpel.variable.exe.MessageValue;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;

public class ReceiveAction
extends MessageAction
implements Serializable {
    private String messageExchange;
    private VariableDefinition variable;
    private Correlations correlations;
    private InboundMessageActivity inboundMessageActivity;
    private static final long serialVersionUID = 1L;

    public String getMessageExchange() {
        return this.messageExchange;
    }

    public void setMessageExchange(String messageExchange) {
        this.messageExchange = messageExchange;
    }

    public VariableDefinition getVariable() {
        return this.variable;
    }

    public void setVariable(VariableDefinition variable) {
        this.variable = variable;
    }

    public Correlations getCorrelations() {
        return this.correlations;
    }

    public void setCorrelations(Correlations correlations) {
        this.correlations = correlations;
    }

    public InboundMessageActivity getInboundMessageActivity() {
        return this.inboundMessageActivity;
    }

    public void setInboundMessageActivity(InboundMessageActivity inboundMessageListener) {
        this.inboundMessageActivity = inboundMessageListener;
    }

    public void execute(ExecutionContext exeContext) {
        IntegrationService integrationService = ReceiveAction.getIntegrationService(exeContext.getJbpmContext());
        integrationService.receive(this, exeContext.getToken());
    }

    public void readMessage(Map parts, Token token) {
        MessageValue messageValue = (MessageValue)this.variable.getValueForAssign(token);
        messageValue.setParts(parts);
        if (this.correlations != null) {
            this.correlations.ensureConstraint(messageValue, token);
        }
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this).append("partnerLink", (Object)this.getPartnerLink().getName()).append("operation", (Object)this.getOperation().getName());
        if (this.messageExchange != null) {
            builder.append("messageExchange", (Object)this.messageExchange);
        }
        return builder.toString();
    }

    public static IntegrationService getIntegrationService(JbpmContext jbpmContext) {
        return (IntegrationService)jbpmContext.getServices().getService("integration");
    }
}

