/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.graph.struct;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.bpel.alarm.AlarmAction;
import org.jbpm.bpel.alarm.TimeDrivenActivity;
import org.jbpm.bpel.graph.def.Activity;
import org.jbpm.bpel.graph.def.BpelVisitor;
import org.jbpm.bpel.graph.struct.StructuredActivity;
import org.jbpm.bpel.integration.IntegrationService;
import org.jbpm.bpel.integration.def.InboundMessageActivity;
import org.jbpm.bpel.integration.def.ReceiveAction;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.scheduler.SchedulerService;

public class Pick
extends StructuredActivity
implements InboundMessageActivity,
TimeDrivenActivity {
    private List onMessages = new ArrayList();
    private List onAlarms = new ArrayList();
    private boolean createInstance;
    private static final Log log = LogFactory.getLog((Class)Pick.class);
    private static final long serialVersionUID = 1L;

    public Pick() {
    }

    public Pick(String name) {
        super(name);
    }

    public void execute(ExecutionContext exeContext) {
        Token token = exeContext.getToken();
        JbpmContext jbpmContext = exeContext.getJbpmContext();
        IntegrationService integrationService = ReceiveAction.getIntegrationService(jbpmContext);
        integrationService.receive(this.onMessages, token);
        SchedulerService schedulerService = AlarmAction.getSchedulerService(jbpmContext);
        int n = this.onAlarms.size();
        for (int i = 0; i < n; ++i) {
            AlarmAction alarmAction = (AlarmAction)((Object)this.onAlarms.get(i));
            alarmAction.createTimer(token, schedulerService);
        }
    }

    public void terminate(ExecutionContext exeContext) {
        Token token = exeContext.getToken();
        JbpmContext jbpmContext = exeContext.getJbpmContext();
        this.endReceivers(token, jbpmContext);
        this.endAlarms(token, jbpmContext);
    }

    public void messageReceived(ReceiveAction receiveAction, Token token) {
        JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
        this.endReceivers(token, jbpmContext);
        this.endAlarms(token, jbpmContext);
        this.processEvent(receiveAction, new ExecutionContext(token));
    }

    public void alarmFired(AlarmAction alarmAction, Token token) {
        JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
        this.endReceivers(token, jbpmContext);
        this.endAlarms(token, jbpmContext);
        this.processEvent(alarmAction, new ExecutionContext(token));
    }

    protected void endReceivers(Token token, JbpmContext jbpmContext) {
        IntegrationService integrationService = ReceiveAction.getIntegrationService(jbpmContext);
        integrationService.endReception(this.onMessages, token);
    }

    protected void endAlarms(Token token, JbpmContext jbpmContext) {
        SchedulerService schedulerService = AlarmAction.getSchedulerService(jbpmContext);
        int n = this.onAlarms.size();
        for (int i = 0; i < n; ++i) {
            AlarmAction alarmAction = (AlarmAction)((Object)this.onAlarms.get(i));
            alarmAction.deleteTimer(token, schedulerService);
        }
    }

    public void processEvent(ReceiveAction messageEvent, ExecutionContext exeContext) {
        this.performActivity(this.getOnMessage(messageEvent), exeContext);
    }

    public void processEvent(AlarmAction alarmEvent, ExecutionContext exeContext) {
        this.performActivity(this.getOnAlarm(alarmEvent), exeContext);
    }

    protected void performActivity(Activity selectedActivity, ExecutionContext exeContext) {
        Iterator activityIt = this.nodes.iterator();
        while (activityIt.hasNext()) {
            Activity activity = (Activity)((Object)activityIt.next());
            if (selectedActivity.equals((Object)activity)) continue;
            activity.eliminatePath(exeContext.getToken());
        }
        log.debug((Object)("selected branch: " + (Object)((Object)selectedActivity)));
        this.begin.leave(exeContext, selectedActivity.getDefaultArrivingTransition());
    }

    protected void addActivity(Activity activity) {
        super.addActivity(activity);
        this.onMessages.add(null);
        int alarmCount = this.onAlarms.size();
        if (alarmCount > 0) {
            int receptorIndex = this.onMessages.size() - 1;
            this.nodes.remove(receptorIndex + alarmCount);
            this.nodes.add(receptorIndex, activity);
        }
    }

    protected void removeActivity(Activity activity) {
        int index = this.nodes.indexOf((Object)activity);
        if (index < this.onMessages.size()) {
            this.onMessages.remove(index);
        } else {
            this.onAlarms.remove(index - this.onMessages.size());
        }
        super.removeActivity(activity);
    }

    public List getOnMessages() {
        return this.onMessages;
    }

    public void setOnMessage(Activity activity, ReceiveAction receiveAction) {
        int activityIndex = this.nodes.indexOf((Object)activity);
        if (activityIndex == -1) {
            throw new IllegalArgumentException("cannot set message event for non-member activity: " + (Object)((Object)activity));
        }
        if (activityIndex < this.onMessages.size()) {
            this.onMessages.set(activityIndex, receiveAction);
        } else {
            this.onAlarms.remove(activityIndex - this.onMessages.size());
            this.nodes.remove(activityIndex);
            this.nodes.add(this.onMessages.size(), activity);
            this.onMessages.add(receiveAction);
        }
        receiveAction.setInboundMessageActivity(this);
    }

    public Activity getOnMessage(ReceiveAction receiveAction) {
        return (Activity)((Object)this.nodes.get(this.onMessages.indexOf(receiveAction)));
    }

    public List getOnAlarms() {
        return this.onAlarms;
    }

    public void setOnAlarm(Activity activity, AlarmAction alarmAction) {
        int activityIndex = this.nodes.indexOf((Object)activity);
        if (activityIndex == -1) {
            throw new IllegalArgumentException("cannot set alarm event for non-member activity: " + (Object)((Object)activity));
        }
        if (activityIndex >= this.onMessages.size()) {
            int alarmIndex = activityIndex - this.onMessages.size();
            this.onAlarms.set(alarmIndex, alarmAction);
        } else {
            this.onMessages.remove(activityIndex);
            this.onAlarms.add(alarmAction);
            this.nodes.remove(activityIndex);
            this.nodes.add(activity);
        }
        alarmAction.setTimeDrivenActivity(this);
    }

    public Activity getOnAlarm(AlarmAction alarmAction) {
        return (Activity)((Object)this.nodes.get(this.onMessages.size() + this.onAlarms.indexOf((Object)alarmAction)));
    }

    public boolean isCreateInstance() {
        return this.createInstance;
    }

    public void setCreateInstance(boolean createInstance) {
        this.createInstance = createInstance;
    }

    public void accept(BpelVisitor visitor) {
        visitor.visit(this);
    }
}

