/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.graph.struct;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.bpel.BpelException;
import org.jbpm.bpel.graph.def.Activity;
import org.jbpm.bpel.graph.def.BpelVisitor;
import org.jbpm.bpel.graph.struct.StructuredActivity;
import org.jbpm.bpel.sublang.def.Expression;
import org.jbpm.bpel.xml.util.DatatypeUtil;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;

public class If
extends StructuredActivity {
    private List conditions = new ArrayList();
    private static final Log log = LogFactory.getLog((Class)If.class);
    private static final long serialVersionUID = 1L;

    public If() {
    }

    public If(String name) {
        super(name);
    }

    public void execute(ExecutionContext exeContext) {
        Token token = exeContext.getToken();
        Activity selectedBranch = null;
        int n = this.conditions.size();
        for (int i = 0; i < n; ++i) {
            Activity branch = (Activity)((Object)this.nodes.get(i));
            if (selectedBranch == null) {
                Expression condition = (Expression)this.conditions.get(i);
                log.debug((Object)("evaluating condition: " + condition.getText()));
                if (DatatypeUtil.toBoolean(condition.getEvaluator().evaluate(token))) {
                    selectedBranch = branch;
                    log.debug((Object)("selected branch: " + (Object)((Object)branch)));
                    continue;
                }
            }
            branch.eliminatePath(token);
        }
        Activity _else = this.getElse();
        if (_else != null) {
            if (selectedBranch == null) {
                selectedBranch = _else;
                log.debug((Object)("no branch with condition selected, taking else branch: " + (Object)((Object)_else)));
            } else {
                _else.eliminatePath(token);
            }
        } else if (selectedBranch == null) {
            selectedBranch = this.end;
            log.debug((Object)"no branch with condition selected and no else branch present, ending");
        }
        this.getBegin().leave(exeContext, selectedBranch.getDefaultArrivingTransition());
    }

    protected void addActivity(Activity activity) {
        int conditionCount = this.conditions.size();
        if (this.nodes.size() > conditionCount) {
            Object _else = this.nodes.remove(conditionCount);
            super.addActivity(activity);
            this.nodes.add(_else);
        } else {
            super.addActivity(activity);
        }
        this.conditions.add(null);
    }

    protected void removeActivity(Activity activity) {
        int activityIndex = this.nodes.indexOf((Object)activity);
        if (activityIndex < this.conditions.size()) {
            this.conditions.remove(activityIndex);
        }
        super.removeActivity(activity);
    }

    public void reorderNode(int oldIndex, int newIndex) {
        super.reorderNode(oldIndex, newIndex);
        int elseIndex = this.conditions.size();
        if (oldIndex < elseIndex && newIndex < elseIndex) {
            Object condition = this.conditions.remove(oldIndex);
            this.conditions.add(newIndex, condition);
        }
    }

    public Expression getCondition(Activity activity) {
        int index = this.nodes.indexOf((Object)activity);
        if (index == -1) {
            throw new BpelException("cannot get the condition of a non-member activity");
        }
        return index < this.conditions.size() ? (Expression)this.conditions.get(index) : null;
    }

    public void setCondition(Activity activity, Expression condition) {
        int index = this.nodes.indexOf((Object)activity);
        if (index == -1) {
            throw new BpelException("cannot set a condition for a non-member activity");
        }
        if (index < this.conditions.size()) {
            this.conditions.set(index, condition);
        } else {
            this.conditions.add(condition);
        }
    }

    public Activity getElse() {
        int conditionCount = this.conditions.size();
        return this.nodes.size() > conditionCount ? (Activity)((Object)this.nodes.get(conditionCount)) : null;
    }

    public void setElse(Activity _else) {
        int index = this.nodes.indexOf((Object)_else);
        if (index == -1) {
            throw new BpelException("cannot set a non-member activity as otherwise");
        }
        int conditionCount = this.conditions.size();
        if (index < conditionCount) {
            if (this.nodes.size() > conditionCount) {
                Activity oldElse = (Activity)((Object)this.nodes.get(conditionCount));
                this.removeActivity(oldElse);
            }
            this.nodes.remove(index);
            this.nodes.add(_else);
            this.conditions.remove(index);
        }
    }

    public List getBranches() {
        return this.nodes.subList(0, this.conditions.size());
    }

    List getConditions() {
        return this.conditions;
    }

    public void accept(BpelVisitor visitor) {
        visitor.visit(this);
    }
}

