/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.graph.exe.state;

import org.jbpm.bpel.graph.exe.ScopeInstance;
import org.jbpm.bpel.graph.exe.ScopeState;
import org.jbpm.bpel.graph.exe.state.EndedState;
import org.jbpm.bpel.graph.exe.state.StateUtil;
import org.jbpm.bpel.graph.scope.Handler;

public class CompensatingState
extends ScopeState {
    private static final long serialVersionUID = 1L;
    public static final ScopeState COMPENSATING_WITHOUT_HANDLER = new CompensatingState("compensatingWithoutHandler", 10){
        private static final long serialVersionUID = 1L;

        public void faulted(ScopeInstance scope) {
            EndedState.enterFaulted(scope);
        }

        public void childrenCompensated(ScopeInstance scope) {
            EndedState.enterCompensated(scope);
        }
    };
    public static final ScopeState COMPENSATING_WITH_HANDLER = new CompensatingState("compensatingWithHandler", 11){
        private static final long serialVersionUID = 1L;

        public void completed(ScopeInstance scope) {
            scope.getHandlerToken().end(false);
            EndedState.enterCompensated(scope);
        }

        public void faulted(ScopeInstance scope) {
            scope.setState(TERMINATING_COMPENSATION_HANDLER);
            scope.terminateChildren();
        }
    };
    public static final ScopeState TERMINATING_COMPENSATION_HANDLER = new CompensatingState("terminatingCompensationHandler", 12){
        private static final long serialVersionUID = 1L;

        public void childrenTerminated(ScopeInstance scope) {
            EndedState.enterFaulted(scope);
        }
    };

    private CompensatingState(String name, int code) {
        super(name, code);
    }

    public static void enterCompensating(ScopeInstance scope) {
        Handler handler = scope.getDefinition().getCompensationHandler();
        if (handler != null) {
            scope.setState(COMPENSATING_WITH_HANDLER);
            StateUtil.invokeHandler(scope, handler);
        } else {
            scope.setState(COMPENSATING_WITHOUT_HANDLER);
            StateUtil.invokeDefaultCompensation(scope);
        }
    }
}

