/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.graph.exe;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jbpm.bpel.graph.exe.ScopeInstance;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.exe.Token;

public class ScopeInstanceIterator
implements Iterator {
    private List tokensToTraverse = new ArrayList();
    private ScopeInstance currentScopeInstance;

    public ScopeInstanceIterator(Token parent) {
        Map children = parent.getChildren();
        if (children != null && !children.isEmpty()) {
            this.tokensToTraverse.addAll(children.values());
            this.currentScopeInstance = this.nextScopeInstance();
        }
    }

    public boolean hasNext() {
        return this.currentScopeInstance != null;
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ScopeInstance lastReturned = this.currentScopeInstance;
        this.currentScopeInstance = this.nextScopeInstance();
        return lastReturned;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    private ScopeInstance nextScopeInstance() {
        while (!this.tokensToTraverse.isEmpty()) {
            ScopeInstance scopeInstance = ScopeInstanceIterator.getScopeInstance(this.nextToken());
            if (scopeInstance == null) continue;
            return scopeInstance;
        }
        return null;
    }

    private Token nextToken() {
        if (this.tokensToTraverse.isEmpty()) {
            throw new NoSuchElementException();
        }
        Token nextToken = (Token)this.tokensToTraverse.remove(this.tokensToTraverse.size() - 1);
        Map children = nextToken.getChildren();
        if (ScopeInstanceIterator.getScopeInstance(nextToken) == null && children != null) {
            this.tokensToTraverse.addAll(children.values());
        }
        return nextToken;
    }

    private static ScopeInstance getScopeInstance(Token token) {
        ContextInstance contextInstance = (ContextInstance)token.getProcessInstance().getInstance(ContextInstance.class);
        return (ScopeInstance)contextInstance.getLocalVariable("s:instance", token);
    }
}

