/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.graph.basic.assign;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.bpel.BpelException;
import org.jbpm.bpel.graph.basic.Assign;
import org.jbpm.bpel.sublang.def.Query;
import org.jbpm.bpel.variable.def.VariableDefinition;
import org.jbpm.bpel.variable.exe.MessageValue;
import org.jbpm.graph.exe.Token;
import org.w3c.dom.Element;

public class ToVariable
extends Assign.To {
    private VariableDefinition variable;
    private String part;
    private Query query;
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog((Class)ToVariable.class);

    public VariableDefinition getVariable() {
        return this.variable;
    }

    public void setVariable(VariableDefinition variable) {
        this.variable = variable;
    }

    public String getPart() {
        return this.part;
    }

    public void setPart(String part) {
        this.part = part;
    }

    public Query getQuery() {
        return this.query;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public void assign(Token token, Object value) {
        if (this.part != null) {
            Object variableValue = this.variable.getValueForAssign(token);
            if (!(variableValue instanceof MessageValue)) {
                throw new BpelException("non-message variable does not have part: " + this.variable.getName());
            }
            MessageValue messageValue = (MessageValue)variableValue;
            if (this.query != null) {
                Element partValue = messageValue.getPartForAssign(this.part);
                this.query.getEvaluator().assign(partValue, value);
            } else {
                messageValue.setPart(this.part, value);
            }
        } else if (this.query != null) {
            Object variableValue = this.variable.getValueForAssign(token);
            if (variableValue instanceof MessageValue) {
                throw new BpelException("illegal query on message variable: " + this.variable.getName());
            }
            log.debug((Object)("assigning query '" + this.query.getText() + "' for '" + token + "'"));
            this.query.getEvaluator().assign((Element)variableValue, value);
        } else {
            this.variable.setValue(token, value);
        }
    }
}

