/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.endpointref;

import com.ibm.wsdl.util.xml.QNameUtils;
import javax.wsdl.Port;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.jbpm.bpel.endpointref.EndpointReferenceFactory;
import org.jbpm.bpel.graph.exe.BpelFaultException;
import org.jbpm.bpel.integration.catalog.ServiceCatalog;
import org.jbpm.bpel.xml.BpelConstants;
import org.jbpm.bpel.xml.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class EndpointReference {
    long id;
    private String scheme;
    private QName portTypeName;

    protected EndpointReference() {
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public QName getPortTypeName() {
        return this.portTypeName;
    }

    public void setPortTypeName(QName portTypeName) {
        this.portTypeName = portTypeName;
    }

    public static EndpointReference readServiceRef(Element referenceElem) {
        Element endpointRefElem;
        String scheme;
        if ("http://schemas.xmlsoap.org/ws/2004/03/business-process/".equals(referenceElem.getNamespaceURI()) && "service-ref".equals(referenceElem.getLocalName())) {
            scheme = referenceElem.getAttribute("reference-scheme");
            endpointRefElem = XmlUtil.getElement(referenceElem);
        } else {
            scheme = null;
            endpointRefElem = referenceElem;
        }
        QName endpointRefName = QNameUtils.newQName((Node)endpointRefElem);
        EndpointReferenceFactory factory = EndpointReferenceFactory.getInstance(endpointRefName, scheme);
        if (factory == null) {
            throw new BpelFaultException(BpelConstants.FAULT_UNSUPPORTED_REFERENCE);
        }
        EndpointReference endpointRef = factory.createEndpointReference();
        endpointRef.setScheme(scheme);
        endpointRef.readEndpointRef(endpointRefElem);
        return endpointRef;
    }

    public void writeServiceRef(Element referenceElem) {
        Element endpointRefElem = this.writeEndpointRef(referenceElem.getOwnerDocument());
        if ("http://schemas.xmlsoap.org/ws/2004/03/business-process/".equals(referenceElem.getNamespaceURI()) && "service-ref".equals(referenceElem.getLocalName())) {
            XmlUtil.removeAttributes(referenceElem);
            XmlUtil.removeChildNodes(referenceElem);
            if (!StringUtils.isEmpty((String)this.scheme)) {
                referenceElem.setAttribute("reference-scheme", this.scheme);
            }
            referenceElem.appendChild(endpointRefElem);
        } else {
            XmlUtil.copy(referenceElem, endpointRefElem);
        }
    }

    public abstract Port selectPort(ServiceCatalog var1);

    protected abstract void readEndpointRef(Element var1);

    protected abstract Element writeEndpointRef(Document var1);
}

