/*
 * Decompiled with CFR 0.152.
 */
package org.drools.xml;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.xml.AndHandler;
import org.drools.xml.BoundVariableHandler;
import org.drools.xml.ColumnHandler;
import org.drools.xml.Configuration;
import org.drools.xml.DefaultConfiguration;
import org.drools.xml.EvalHandler;
import org.drools.xml.ExistsHandler;
import org.drools.xml.FieldBindingHandler;
import org.drools.xml.FunctionHandler;
import org.drools.xml.Handler;
import org.drools.xml.LiteralHandler;
import org.drools.xml.NotHandler;
import org.drools.xml.OrHandler;
import org.drools.xml.PackageHandler;
import org.drools.xml.PredicateHandler;
import org.drools.xml.QueryHandler;
import org.drools.xml.ReturnValueHandler;
import org.drools.xml.RuleHandler;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlPackageReader
extends DefaultHandler {
    public static final String ENTITY_RESOLVER_PROPERTY_NAME = "org.drools.io.EntityResolver";
    public static final String RULES_NAMESPACE_URI = "http://drools.org/rules";
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private SAXParser parser;
    private boolean isValidating = true;
    private Locator locator;
    private LinkedList configurationStack;
    private StringBuffer characters;
    private Map handlers;
    private boolean lastWasEndElement;
    private LinkedList parents;
    private Object peer;
    private Object current;
    private PackageDescr packageDescr;
    private boolean inHandledRuleSubElement;
    private final MessageFormat message = new MessageFormat("({0}: {1}, {2}): {3}");
    private final Map namespaces = new HashMap();
    EntityResolver entityResolver;

    public XmlPackageReader() {
        this.configurationStack = new LinkedList();
        this.parents = new LinkedList();
        this.handlers = new HashMap();
        this.handlers.put("package", new PackageHandler(this));
        this.handlers.put("rule", new RuleHandler(this));
        this.handlers.put("query", new QueryHandler(this));
        this.handlers.put("attribute", null);
        this.handlers.put("function", new FunctionHandler(this));
        this.handlers.put("lhs", new AndHandler(this));
        this.handlers.put("and", new AndHandler(this));
        this.handlers.put("or", new OrHandler(this));
        this.handlers.put("not", new NotHandler(this));
        this.handlers.put("exists", new ExistsHandler(this));
        this.handlers.put("eval", new EvalHandler(this));
        this.handlers.put("column", new ColumnHandler(this));
        this.handlers.put("literal", new LiteralHandler(this));
        this.handlers.put("predicate", new PredicateHandler(this));
        this.handlers.put("return-value", new ReturnValueHandler(this));
        this.handlers.put("field-binding", new FieldBindingHandler(this));
        this.handlers.put("bound-variable", new BoundVariableHandler(this));
        this.initEntityResolver();
    }

    public XmlPackageReader(SAXParser sAXParser) {
        this.parser = sAXParser;
    }

    public PackageDescr read(Reader reader) throws SAXException, IOException {
        return this.read(new InputSource(reader));
    }

    public PackageDescr read(InputStream inputStream) throws SAXException, IOException {
        return this.read(new InputSource(inputStream));
    }

    public PackageDescr read(InputSource inputSource) throws SAXException, IOException {
        SAXParser sAXParser = null;
        if (this.parser == null) {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            String string = System.getProperty("drools.schema.validating");
            if (System.getProperty("drools.schema.validating") != null) {
                this.isValidating = Boolean.getBoolean("drools.schema.validating");
            }
            if (this.isValidating) {
                sAXParserFactory.setValidating(true);
                try {
                    sAXParser = sAXParserFactory.newSAXParser();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new RuntimeException(parserConfigurationException.getMessage());
                }
                try {
                    sAXParser.setProperty(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    boolean bl = Boolean.getBoolean("drools.schema.hidewarnings");
                    if (!bl) {
                        System.err.println("Your SAX parser is not JAXP 1.2 compliant - turning off validation.");
                    }
                    sAXParser = null;
                }
            }
            if (sAXParser == null) {
                try {
                    this.isValidating = false;
                    sAXParserFactory.setValidating(this.isValidating);
                    sAXParser = sAXParserFactory.newSAXParser();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new RuntimeException(parserConfigurationException.getMessage());
                }
            }
        } else {
            sAXParser = this.parser;
        }
        if (!sAXParser.isNamespaceAware()) {
            throw new RuntimeException("parser must be namespace-aware");
        }
        sAXParser.parse(inputSource, (DefaultHandler)this);
        return this.packageDescr;
    }

    void setPackageDescr(PackageDescr packageDescr) {
        this.packageDescr = packageDescr;
    }

    public PackageDescr getPackageDescr() {
        return this.packageDescr;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public Locator getLocator() {
        return this.locator;
    }

    public void startDocument() {
        this.isValidating = true;
        this.packageDescr = null;
        this.current = null;
        this.peer = null;
        this.lastWasEndElement = false;
        this.parents.clear();
        this.characters = null;
        this.configurationStack.clear();
        this.namespaces.clear();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Handler handler;
        if (!this.lastWasEndElement) {
            this.peer = null;
        }
        if ((handler = this.getHandler(string2)) != null && !this.parents.isEmpty() && this.parents.getLast() instanceof RuleDescr) {
            this.inHandledRuleSubElement = true;
        }
        if (handler == null) {
            this.startConfiguration(string2, attributes);
            return;
        }
        this.validate(string, string2, handler);
        Object object = handler.start(string, string2, attributes);
        if (object != null) {
            this.parents.add(object);
            this.current = object;
        }
        this.lastWasEndElement = false;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        Handler handler = this.getHandler(string2);
        if (handler != null && !this.parents.isEmpty() && this.parents.getLast() instanceof RuleDescr) {
            this.inHandledRuleSubElement = false;
        }
        if (handler == null) {
            if (this.configurationStack.size() >= 1) {
                this.endConfiguration();
            }
            return;
        }
        this.current = this.getParent(handler.generateNodeFor());
        Object object = handler.end(string, string2);
        if (object != null && !this.lastWasEndElement) {
            this.peer = object;
        } else if (this.lastWasEndElement || this.parents.getLast().getClass().isInstance(this.current)) {
            this.peer = this.parents.removeLast();
        }
        this.lastWasEndElement = true;
    }

    private void validate(String string, String string2, Handler handler) throws SAXParseException {
        Object object;
        Iterator iterator;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Set set = handler.getValidParents();
        Set set2 = handler.getValidPeers();
        boolean bl4 = handler.allowNesting();
        Object var10_10 = this.parents.size() != 0 ? this.parents.getLast() : null;
        Class clazz = this.getHandler(string2).generateNodeFor();
        if (!clazz.isInstance(var10_10)) {
            iterator = set.iterator();
            while (!bl && iterator.hasNext()) {
                object = iterator.next();
                if (var10_10 == null && object == null) {
                    bl = true;
                    continue;
                }
                if (object == null || !((Class)object).isInstance(var10_10)) continue;
                bl = true;
            }
            if (!bl) {
                throw new SAXParseException("<" + string2 + "> has an invalid parent element [" + var10_10 + "]", this.getLocator());
            }
        }
        object = this.peer;
        Iterator iterator2 = set2.iterator();
        while (!bl2 && iterator2.hasNext()) {
            iterator = iterator2.next();
            if (object == null && iterator == null) {
                bl2 = true;
                continue;
            }
            if (iterator == null || !((Class)((Object)iterator)).isInstance(object)) continue;
            bl2 = true;
        }
        if (!bl2) {
            throw new SAXParseException("<" + string2 + "> is after an invalid element", this.getLocator());
        }
        if (!bl4) {
            iterator2 = this.parents.iterator();
            while (!bl3 && iterator2.hasNext()) {
                if (!clazz.isInstance(iterator2.next())) continue;
                bl3 = true;
            }
        }
        if (bl3) {
            throw new SAXParseException("<" + string2 + ">  may not be nested", this.getLocator());
        }
    }

    protected void startConfiguration(String string, Attributes attributes) {
        this.characters = new StringBuffer();
        DefaultConfiguration defaultConfiguration = new DefaultConfiguration(string);
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            defaultConfiguration.setAttribute(attributes.getLocalName(i), attributes.getValue(i));
        }
        Iterator iterator = this.namespaces.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string2 = (String)entry.getKey();
            String string3 = (String)entry.getValue();
            string2 = string2 == null || string2.length() == 0 ? "xmlns" : "xmlns:" + string2;
            defaultConfiguration.setAttribute(string2, string3);
        }
        if (this.configurationStack.isEmpty()) {
            this.configurationStack.addLast(defaultConfiguration);
        } else {
            ((DefaultConfiguration)this.configurationStack.getLast()).addChild(defaultConfiguration);
            this.configurationStack.addLast(defaultConfiguration);
        }
    }

    Handler getHandler(String string) {
        return (Handler)this.handlers.get(string);
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this.characters != null) {
            this.characters.append(cArray, n, n2);
        }
    }

    protected Configuration endConfiguration() {
        DefaultConfiguration defaultConfiguration = (DefaultConfiguration)this.configurationStack.removeLast();
        if (this.characters != null) {
            defaultConfiguration.setText(this.characters.toString());
        }
        this.characters = null;
        return defaultConfiguration;
    }

    LinkedList getParents() {
        return this.parents;
    }

    Object getParent(Class clazz) {
        ListIterator listIterator = this.parents.listIterator(this.parents.size());
        Object var3_3 = null;
        while (listIterator.hasPrevious() && !clazz.isInstance(var3_3 = listIterator.previous())) {
        }
        return var3_3;
    }

    Object getPeer() {
        return this.peer;
    }

    Object getCurrent() {
        return this.current;
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        try {
            InputSource inputSource = this.resolveSchema(string, string2);
            if (inputSource != null) {
                return inputSource;
            }
            if (this.entityResolver != null) {
                return this.entityResolver.resolveEntity(string, string2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        super.startPrefixMapping(string, string2);
        this.namespaces.put(string, string2);
    }

    public void endPrefixMapping(String string) throws SAXException {
        super.endPrefixMapping(string);
        this.namespaces.remove(string);
    }

    private void print(SAXParseException sAXParseException) {
        String string = this.message.format(new Object[]{sAXParseException.getSystemId(), new Integer(sAXParseException.getLineNumber()), new Integer(sAXParseException.getColumnNumber()), sAXParseException.getMessage()});
        System.out.println(string);
    }

    public void warning(SAXParseException sAXParseException) {
        this.print(sAXParseException);
    }

    public void error(SAXParseException sAXParseException) {
        this.print(sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXParseException {
        this.print(sAXParseException);
        throw sAXParseException;
    }

    private InputSource resolveSchema(String string, String string2) throws SAXException, IOException {
        if (!string2.toLowerCase().endsWith("xsd")) {
            return null;
        }
        try {
            URL uRL = new URL(string2);
            return new InputSource(uRL.openStream());
        }
        catch (Exception exception) {
            Object object;
            int n = string2.lastIndexOf("/");
            if (n == -1) {
                n = string2.lastIndexOf("\\");
            }
            String string3 = n != -1 ? string2.substring(n + 1) : string2;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = XmlPackageReader.class.getClassLoader();
            }
            if ((object = classLoader.getResourceAsStream("META-INF/" + string3)) != null) {
                return new InputSource((InputStream)object);
            }
            object = classLoader.getResourceAsStream("/META-INF/" + string3);
            if (object != null) {
                return new InputSource((InputStream)object);
            }
            object = classLoader.getResourceAsStream("/" + string3);
            if (object != null) {
                return new InputSource((InputStream)object);
            }
            object = new File(string3);
            if (((File)object).exists()) {
                return new InputSource(new BufferedInputStream(new FileInputStream((File)object)));
            }
            classLoader = ClassLoader.getSystemClassLoader();
            object = classLoader.getResourceAsStream("META-INF/" + string3);
            if (object != null) {
                return new InputSource((InputStream)object);
            }
            object = classLoader.getResourceAsStream("/META-INF/" + string3);
            if (object != null) {
                return new InputSource((InputStream)object);
            }
            object = classLoader.getResourceAsStream("/" + string3);
            if (object != null) {
                return new InputSource((InputStream)object);
            }
            return null;
        }
    }

    private void initEntityResolver() {
        String string = System.getProperty(ENTITY_RESOLVER_PROPERTY_NAME);
        if (string != null && string.length() > 0) {
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(string);
                this.entityResolver = (EntityResolver)clazz.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

