/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.svg;

import java.awt.EventQueue;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;
import org.apache.batik.swing.svg.SVGDocumentLoaderListener;
import org.w3c.dom.svg.SVGDocument;

public class SVGDocumentLoader
extends Thread {
    protected String url;
    protected DocumentLoader loader;
    protected Exception exception;
    protected List listeners = Collections.synchronizedList(new LinkedList());

    public SVGDocumentLoader(String u, DocumentLoader l) {
        this.url = u;
        this.loader = l;
    }

    public void run() {
        try {
            this.fireStartedEvent();
            SVGDocument svgDocument = (SVGDocument)this.loader.loadDocument(this.url);
            this.fireCompletedEvent(svgDocument);
        }
        catch (InterruptedIOException e) {
            this.fireCancelledEvent();
        }
        catch (Exception e) {
            this.exception = e;
            this.fireFailedEvent();
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public void addSVGDocumentLoaderListener(SVGDocumentLoaderListener l) {
        this.listeners.add(l);
    }

    public void removeSVGDocumentLoaderListener(SVGDocumentLoaderListener l) {
        this.listeners.remove(l);
    }

    protected void fireStartedEvent() throws InterruptedException {
        block5: {
            final Object[] dll = this.listeners.toArray();
            if (dll.length <= 0) break block5;
            final SVGDocumentLoaderEvent ev = new SVGDocumentLoaderEvent(this, null);
            if (EventQueue.isDispatchThread()) {
                int i = 0;
                while (i < dll.length) {
                    SVGDocumentLoaderListener dl = (SVGDocumentLoaderListener)dll[i];
                    dl.documentLoadingStarted(ev);
                    ++i;
                }
            } else {
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        public void run() {
                            int i = 0;
                            while (i < dll.length) {
                                SVGDocumentLoaderListener dl = (SVGDocumentLoaderListener)dll[i];
                                dl.documentLoadingStarted(ev);
                                ++i;
                            }
                        }
                    });
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }
    }

    protected void fireCompletedEvent(SVGDocument doc) {
        final Object[] dll = this.listeners.toArray();
        if (dll.length > 0) {
            final SVGDocumentLoaderEvent ev = new SVGDocumentLoaderEvent(this, doc);
            if (EventQueue.isDispatchThread()) {
                int i = 0;
                while (i < dll.length) {
                    SVGDocumentLoaderListener dl = (SVGDocumentLoaderListener)dll[i];
                    dl.documentLoadingCompleted(ev);
                    ++i;
                }
            } else {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        int i = 0;
                        while (i < dll.length) {
                            SVGDocumentLoaderListener dl = (SVGDocumentLoaderListener)dll[i];
                            dl.documentLoadingCompleted(ev);
                            ++i;
                        }
                    }
                });
            }
        }
    }

    protected void fireFailedEvent() {
        final Object[] dll = this.listeners.toArray();
        if (dll.length > 0) {
            final SVGDocumentLoaderEvent ev = new SVGDocumentLoaderEvent(this, null);
            if (EventQueue.isDispatchThread()) {
                int i = 0;
                while (i < dll.length) {
                    SVGDocumentLoaderListener dl = (SVGDocumentLoaderListener)dll[i];
                    dl.documentLoadingFailed(ev);
                    ++i;
                }
            } else {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        int i = 0;
                        while (i < dll.length) {
                            SVGDocumentLoaderListener dl = (SVGDocumentLoaderListener)dll[i];
                            dl.documentLoadingFailed(ev);
                            ++i;
                        }
                    }
                });
            }
        }
    }

    protected void fireCancelledEvent() {
        final Object[] dll = this.listeners.toArray();
        if (dll.length > 0) {
            final SVGDocumentLoaderEvent ev = new SVGDocumentLoaderEvent(this, null);
            if (EventQueue.isDispatchThread()) {
                int i = 0;
                while (i < dll.length) {
                    SVGDocumentLoaderListener dl = (SVGDocumentLoaderListener)dll[i];
                    dl.documentLoadingCancelled(ev);
                    ++i;
                }
            } else {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        int i = 0;
                        while (i < dll.length) {
                            SVGDocumentLoaderListener dl = (SVGDocumentLoaderListener)dll[i];
                            dl.documentLoadingCancelled(ev);
                            ++i;
                        }
                    }
                });
            }
        }
    }
}

