/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.ant;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;

public abstract class AbstractServerRun
extends Thread {
    private int port = 7777;
    private String host = "127.0.0.1";
    protected String[] args;
    private boolean isStarted = false;

    public AbstractServerRun(String[] stringArray) {
        this.args = stringArray;
    }

    protected abstract void doStartServer() throws Exception;

    protected abstract void doStopServer() throws Exception;

    protected void doRun() {
        boolean bl = true;
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < this.args.length) {
            if (this.args[n].equalsIgnoreCase("-start")) {
                bl = true;
            } else if (this.args[n].equalsIgnoreCase("-stop")) {
                bl = false;
            } else if (this.args[n].equalsIgnoreCase("-port")) {
                this.port = Integer.parseInt(this.args[n + 1]);
                ++n;
            } else {
                vector.add(this.args[n]);
            }
            ++n;
        }
        String[] stringArray = new String[]{};
        this.args = vector.toArray(stringArray);
        if (bl) {
            this.startServer();
        } else {
            this.stopServer();
        }
    }

    private void startServer() {
        if (this.isStarted) {
            return;
        }
        try {
            this.doStartServer();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Error starting server");
        }
        this.isStarted = true;
        new Thread(this).start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void stopServer() {
        Socket socket = null;
        try {
            try {
                socket = new Socket(this.host, this.port);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RuntimeException("Error opening socket to " + this.host + ":" + this.port + "]");
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            try {
                if (socket == null) throw throwable;
                socket.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new RuntimeException("Cannot close client socket");
            }
        }
        try {}
        catch (IOException iOException) {
            throw new RuntimeException("Cannot close client socket");
        }
        if (socket == null) return;
        socket.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        ServerSocket serverSocket = this.setUpListenerSocket();
        try {
            try {
                serverSocket.accept();
            }
            catch (IOException iOException) {
                throw new RuntimeException("Error accepting connection for server socket [" + serverSocket + "]");
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            try {
                serverSocket.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new RuntimeException("Cannot close server socket [" + serverSocket + "]");
            }
        }
        try {}
        catch (IOException iOException) {
            throw new RuntimeException("Cannot close server socket [" + serverSocket + "]");
        }
        serverSocket.close();
        try {
            this.doStopServer();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Cannot stop server");
        }
        try {
            serverSocket.close();
            return;
        }
        catch (IOException iOException) {
            throw new RuntimeException("Cannot close server socket [" + serverSocket + "]");
        }
    }

    private ServerSocket setUpListenerSocket() {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(this.port);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException("Error setting up the server listener socket");
        }
        return serverSocket;
    }
}

