/*
 * Decompiled with CFR 0.152.
 */
package org.junitee.servlet;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.junitee.output.HTMLOutput;
import org.junitee.output.OutputProducer;
import org.junitee.output.XMLOutput;
import org.junitee.runner.TestRunner;
import org.junitee.runner.TestRunnerResults;

public class JUnitEEServlet
extends HttpServlet {
    protected static final String PARAM_SUITE = "suite";
    protected static final String PARAM_TEST = "test";
    protected static final String PARAM_RUN_ALL = "all";
    protected static final String PARAM_SEARCH = "search";
    protected static final String PARAM_OUTPUT = "output";
    protected static final String PARAM_XSL = "xsl";
    protected static final String PARAM_FILTER_TRACE = "filterTrace";
    protected static final String PARAM_STOP = "stop";
    protected static final String PARAM_THREAD = "thread";
    protected static final String INIT_PARAM_RESOURCES = "searchResources";
    protected static final String INIT_PARAM_XSL = "xslStylesheet";
    protected static final String OUTPUT_HTML = "html";
    protected static final String OUTPUT_XML = "xml";
    private static final String RESOURCE_PREFIX = "resource";
    private static final String TESTRUNNER_KEY = "testrunner";
    private static final String TESTRESULT_KEY = "testresult";
    public static final String CACTUS_CONTEXT_URL_PROPERTY = "cactus.contextURL";
    private String searchResources;
    private String xslStylesheet;

    protected ClassLoader getDynamicClassLoader() {
        return ((Object)((Object)this)).getClass().getClassLoader();
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.searchResources = config.getInitParameter(INIT_PARAM_RESOURCES);
        this.xslStylesheet = config.getInitParameter(INIT_PARAM_XSL);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession session;
        String resource = request.getPathInfo();
        if (resource != null) {
            this.streamResource(resource, response);
            return;
        }
        String test = request.getParameter(PARAM_TEST);
        String runAll = request.getParameter(PARAM_RUN_ALL);
        String xsl = request.getParameter(PARAM_XSL);
        String stop = request.getParameter(PARAM_STOP);
        String output = request.getParameter(PARAM_OUTPUT);
        String[] testClassNames = null;
        boolean filterTrace = true;
        boolean threaded = "true".equals(request.getParameter(PARAM_THREAD)) | this.getDefaultThreadMode();
        if ("false".equals(request.getParameter(PARAM_FILTER_TRACE))) {
            filterTrace = false;
        }
        if (xsl == null) {
            xsl = this.xslStylesheet;
        }
        if (output == null) {
            output = this.getDefaultOutput();
        }
        if ((session = request.getSession(false)) != null && stop != null) {
            TestRunner runner = (TestRunner)((Object)session.getAttribute(TESTRUNNER_KEY));
            runner.stop();
        }
        TestRunnerResults results = null;
        if (session != null) {
            results = (TestRunnerResults)session.getAttribute(TESTRESULT_KEY);
        }
        if (results != null) {
            this.renderResults(results, request, response, xsl, filterTrace);
            if (results.isFinished()) {
                session.removeAttribute(TESTRESULT_KEY);
                session.removeAttribute(TESTRUNNER_KEY);
            }
            return;
        }
        testClassNames = runAll != null ? this.searchForTests(request.getParameterValues(PARAM_SEARCH)) : request.getParameterValues(PARAM_SUITE);
        if (testClassNames == null) {
            String message = runAll == null ? "" : "You requested all test cases to be run by setting the \"all\" parameter, but no test case was found.";
            this.errorResponse(this.searchForTests(request.getParameterValues(PARAM_SEARCH)), request.getContextPath() + request.getServletPath(), message, response.getWriter(), output, request, response, xsl, filterTrace);
            return;
        }
        if (test != null && testClassNames.length != 1) {
            String message = "You requested to run a single test case but provided more than one test suite.";
            this.errorResponse(this.searchForTests(request.getParameterValues(PARAM_SEARCH)), request.getContextPath() + request.getServletPath(), message, response.getWriter(), output, request, response, xsl, filterTrace);
            return;
        }
        System.setProperty(CACTUS_CONTEXT_URL_PROPERTY, "http://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath());
        session = request.getSession(true);
        session.setAttribute(PARAM_TEST, (Object)"xy");
        results = this.runTests(test, testClassNames, request, threaded);
        this.renderResults(results, request, response, xsl, filterTrace);
    }

    protected void renderResults(TestRunnerResults results, HttpServletRequest request, HttpServletResponse response, String xsl, boolean filterTrace) throws IOException {
        response.setHeader("Cache-Control", "no-cache");
        OutputProducer output = this.getOutputProducer(results, request.getParameter(PARAM_OUTPUT), response, request.getContextPath() + request.getServletPath(), xsl, filterTrace);
        if (output != null) {
            output.render();
        }
    }

    protected TestRunnerResults runTests(String test, String[] testClassNames, HttpServletRequest request, boolean forkThread) {
        TestRunnerResults results = new TestRunnerResults();
        TestRunner tester = new TestRunner(this.getDynamicClassLoader(), results, forkThread);
        if (test == null) {
            HttpSession session = request.getSession(true);
            session.setAttribute(TESTRUNNER_KEY, (Object)tester);
            session.setAttribute(TESTRESULT_KEY, (Object)results);
            tester.run(testClassNames);
        } else {
            tester.run(testClassNames[0], test);
        }
        return results;
    }

    private void streamResource(String resource, HttpServletResponse response) throws IOException {
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(RESOURCE_PREFIX + resource);
        ServletOutputStream out = response.getOutputStream();
        byte[] buffer = new byte[1024];
        int r = 0;
        if (resource.endsWith(".gif")) {
            response.setContentType("image/gif");
        } else if (resource.endsWith(".png")) {
            response.setContentType("image/png");
        }
        while ((r = in.read(buffer)) != -1) {
            out.write(buffer, 0, r);
        }
        in.close();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected String[] searchForTests(String[] param) throws IOException {
        StringBuffer buffer = new StringBuffer();
        if (param == null) {
            return this.searchForTests((String)null);
        }
        int i = 0;
        while (i < param.length) {
            buffer.append(param[i]).append(",");
            ++i;
        }
        return this.searchForTests(buffer.toString());
    }

    /*
     * Loose catch block
     */
    protected String[] searchForTests(String param) throws IOException {
        if (this.searchResources == null && param == null) {
            return this.searchForTestCaseList();
        }
        StringTokenizer tokenizer = param != null ? new StringTokenizer(param, ",") : new StringTokenizer(this.searchResources, ",");
        ArrayList<String> tests = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            try {
                InputStream in = this.getServletContext().getResourceAsStream("WEB-INF/lib/" + token);
                if (in == null) continue;
                JarInputStream jar = new JarInputStream(in);
                JarEntry entry = null;
                while ((entry = jar.getNextJarEntry()) != null) {
                    String name = entry.getName();
                    if (!name.endsWith("Tests.class") && !name.endsWith("Test.class")) continue;
                    tests.add(name.substring(0, name.length() - 6).replace('/', '.'));
                }
                Object var10_11 = null;
                if (jar == null) continue;
                try {
                    jar.close();
                }
                catch (IOException e2) {}
                continue;
                {
                    catch (EOFException e) {
                        var10_11 = null;
                        if (jar == null) continue;
                        try {
                            jar.close();
                        }
                        catch (IOException e2) {}
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var10_11 = null;
                    if (jar != null) {
                        try {
                            jar.close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String[] answer = new String[tests.size()];
        tests.toArray(answer);
        return answer;
    }

    protected String[] searchForTestCaseList() throws IOException {
        String[] stringArray;
        InputStream in = this.getServletContext().getResourceAsStream("WEB-INF/testCase.txt");
        if (in == null) {
            return null;
        }
        try {
            stringArray = this.parseTestCaseList(in);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            in.close();
            throw throwable;
        }
        in.close();
        return stringArray;
    }

    /*
     * WARNING - void declaration
     */
    protected String[] parseTestCaseList(InputStream stream) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader(stream));
        ArrayList<void> list = new ArrayList<void>();
        while ((line = in.readLine()) != null) {
            void var3_4;
            if (var3_4.charAt(0) == '#') continue;
            list.add(var3_4);
        }
        String[] answer = new String[list.size()];
        list.toArray(answer);
        return answer;
    }

    protected String getDefaultOutput() {
        return OUTPUT_HTML;
    }

    protected boolean getDefaultThreadMode() {
        return false;
    }

    protected OutputProducer getOutputProducer(TestRunnerResults results, String outputParam, HttpServletResponse response, String servletPath, String xsl, boolean filterTrace) throws IOException {
        String output = outputParam;
        if (output == null) {
            output = this.getDefaultOutput();
        }
        if (output.equals(OUTPUT_HTML)) {
            return new HTMLOutput(results, response, servletPath, filterTrace);
        }
        if (output.equals(OUTPUT_XML)) {
            return new XMLOutput(results, response, xsl, filterTrace);
        }
        return null;
    }

    protected void errorResponse(String[] testCases, String servletPath, String message, PrintWriter pw, String output, HttpServletRequest request, HttpServletResponse response, String xsl, boolean filterTrace) throws IOException {
        if (OUTPUT_XML.equals(output)) {
            TestRunnerResults results = new TestRunnerResults();
            results.runFailed(message);
            results.finish();
            this.renderResults(results, request, response, xsl, filterTrace);
        } else {
            this.printIndexHtml(testCases, servletPath, message, pw);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void printIndexHtml(String[] testCases, String servletPath, String message, PrintWriter pw) throws IOException {
        String line;
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("resource/runner.html");
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringBuffer bufferList = null;
        if (testCases != null) {
            bufferList = new StringBuffer();
            int i = 0;
            while (i < testCases.length) {
                bufferList.append("        <tr><td class=\"cell\"><input type=\"checkbox\" name=\"suite\" value=\"");
                bufferList.append(testCases[i]).append("\">&nbsp;&nbsp;").append(testCases[i]).append("</td></tr>\n");
                ++i;
            }
        }
        while ((line = reader.readLine()) != null) {
            void var7_9;
            if (testCases != null) {
                if (var7_9.startsWith("###")) {
                    pw.print(bufferList.toString());
                    continue;
                }
                if (var7_9.startsWith("<!-- message -->")) {
                    pw.println(message);
                    continue;
                }
                if (var7_9.indexOf("<form>") != -1) {
                    pw.print("  <form action=\"");
                    pw.print(servletPath);
                    pw.println("\" method=\"get\">\n");
                    continue;
                }
                if (var7_9.startsWith("<!-- beginList") || var7_9.startsWith("endList -->")) continue;
                pw.println((String)var7_9);
                continue;
            }
            pw.println((String)var7_9);
        }
        reader.close();
    }
}

