/*
 * Decompiled with CFR 0.152.
 */
package org.junitee.runner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.junitee.runner.TestInfo;

public class TestSuiteInfo {
    private String testClassName;
    private List tests = new ArrayList();
    private List errors = new ArrayList();
    private List failures = new ArrayList();
    private long elapsedTime = 0L;

    public TestSuiteInfo(String className) {
        this.testClassName = className;
    }

    public void add(TestInfo info) {
        this.tests.add(info);
        if (info.hasError()) {
            this.errors.add(info);
        } else if (info.hasFailure()) {
            this.failures.add(info);
        }
        this.elapsedTime += info.getElapsedTime();
    }

    public Collection getTests() {
        return Collections.unmodifiableCollection(this.tests);
    }

    public boolean hasFailure() {
        return !this.failures.isEmpty();
    }

    public boolean hasError() {
        return !this.errors.isEmpty();
    }

    public boolean successful() {
        return !this.hasError() && !this.hasFailure();
    }

    public String getTestClassName() {
        return this.testClassName;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public List getFailures() {
        return this.failures;
    }

    public List getErrors() {
        return this.errors;
    }
}

