/*
 * Decompiled with CFR 0.152.
 */
package org.junitee.runner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import org.junitee.runner.TestInfo;
import org.junitee.runner.TestRunnerListener;
import org.junitee.runner.TestSuiteInfo;

public class TestRunnerResults
implements TestRunnerListener {
    private long timestamp;
    private List suiteInfo = new ArrayList();
    private Map suites = new HashMap();
    private TestInfo currentInfo;
    private boolean failure = false;
    private boolean singleTest = false;
    private List errorMessages = new ArrayList();
    private boolean filterTrace = true;
    private boolean finished = false;
    private boolean stopped = false;

    public void start(boolean singleTest) {
        this.setSingleTest(singleTest);
    }

    public synchronized void setStopped() {
        this.stopped = true;
    }

    public synchronized boolean isStopped() {
        return this.stopped;
    }

    public synchronized void finish() {
        this.finished = true;
    }

    public synchronized boolean isFinished() {
        return this.finished;
    }

    public synchronized void addError(Test test, Throwable t) {
        this.getCurrentInfo().setError(t);
        this.setFailure(true);
    }

    public synchronized void addFailure(Test test, Throwable t) {
        this.getCurrentInfo().setFailure(t);
        this.setFailure(true);
    }

    public synchronized void addFailure(Test test, AssertionFailedError t) {
        this.getCurrentInfo().setFailure((Throwable)t);
        this.setFailure(true);
    }

    public synchronized void endTest(Test test) {
        long elapsedTime = System.currentTimeMillis() - this.getTimestamp();
        this.getCurrentInfo().setElapsedTime(elapsedTime);
        this.addToSuite(this.getCurrentInfo());
        this.setCurrentInfo(null);
    }

    public synchronized void startTest(Test test) {
        this.setCurrentInfo(new TestInfo(test));
        this.setTimestamp(System.currentTimeMillis());
    }

    public synchronized void runFailed(String message) {
        this.errorMessages.add(message);
    }

    public synchronized long getTimestamp() {
        return this.timestamp;
    }

    public synchronized void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public synchronized List getSuiteInfo() {
        return this.suiteInfo;
    }

    public synchronized void setSuiteInfo(List suiteInfo) {
        this.suiteInfo = suiteInfo;
    }

    public synchronized TestInfo getCurrentInfo() {
        return this.currentInfo;
    }

    public synchronized void setCurrentInfo(TestInfo currentInfo) {
        this.currentInfo = currentInfo;
    }

    public synchronized boolean isFailure() {
        return this.failure;
    }

    public synchronized void setFailure(boolean failure) {
        this.failure = failure;
    }

    public synchronized boolean isFilterTrace() {
        return this.filterTrace;
    }

    public synchronized void setFilterTrace(boolean filterTrace) {
        this.filterTrace = filterTrace;
    }

    public synchronized boolean isSingleTest() {
        return this.singleTest;
    }

    public synchronized void setSingleTest(boolean singleTest) {
        this.singleTest = singleTest;
    }

    public synchronized List getErrorMessages() {
        return this.errorMessages;
    }

    protected void addToSuite(TestInfo info) {
        String className = info.getTest().getClass().getName();
        TestSuiteInfo suite = (TestSuiteInfo)this.suites.get(className);
        if (suite == null) {
            suite = new TestSuiteInfo(className);
            this.suites.put(className, suite);
            this.getSuiteInfo().add(suite);
        }
        suite.add(info);
    }
}

