/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.resolver.tools;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xml.resolver.Catalog;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.helpers.FileURL;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.xml.sax.AttributeList;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class ResolvingParser
implements Parser,
DTDHandler,
DocumentHandler,
EntityResolver {
    public static boolean namespaceAware = true;
    public static boolean validating = false;
    public static boolean suppressExplanation = false;
    private SAXParser saxParser = null;
    private Parser parser = null;
    private DocumentHandler documentHandler = null;
    private DTDHandler dtdHandler = null;
    private CatalogManager catalogManager = CatalogManager.getStaticManager();
    private CatalogResolver catalogResolver = null;
    private CatalogResolver piCatalogResolver = null;
    private boolean allowXMLCatalogPI = false;
    private boolean oasisXMLCatalogPI = false;
    private URL baseURL = null;

    public ResolvingParser() {
        this.initParser();
    }

    public ResolvingParser(CatalogManager catalogManager) {
        this.catalogManager = catalogManager;
        this.initParser();
    }

    private void initParser() {
        this.catalogResolver = new CatalogResolver(this.catalogManager);
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(namespaceAware);
        sAXParserFactory.setValidating(validating);
        try {
            this.saxParser = sAXParserFactory.newSAXParser();
            this.parser = this.saxParser.getParser();
            this.documentHandler = null;
            this.dtdHandler = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Catalog getCatalog() {
        return this.catalogResolver.getCatalog();
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        this.setupParse(inputSource.getSystemId());
        try {
            this.parser.parse(inputSource);
        }
        catch (InternalError internalError) {
            this.explain(inputSource.getSystemId());
            throw internalError;
        }
    }

    public void parse(String string) throws IOException, SAXException {
        this.setupParse(string);
        try {
            this.parser.parse(string);
        }
        catch (InternalError internalError) {
            this.explain(string);
            throw internalError;
        }
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
        this.documentHandler = documentHandler;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.dtdHandler = dTDHandler;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.parser.setErrorHandler(errorHandler);
    }

    public void setLocale(Locale locale) throws SAXException {
        this.parser.setLocale(locale);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.documentHandler != null) {
            this.documentHandler.characters(cArray, n, n2);
        }
    }

    public void endDocument() throws SAXException {
        if (this.documentHandler != null) {
            this.documentHandler.endDocument();
        }
    }

    public void endElement(String string) throws SAXException {
        if (this.documentHandler != null) {
            this.documentHandler.endElement(string);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.documentHandler != null) {
            this.documentHandler.ignorableWhitespace(cArray, n, n2);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (string.equals("oasis-xml-catalog")) {
            URL uRL = null;
            String string3 = string2;
            int n = string3.indexOf("catalog=");
            if (n >= 0 && (string3 = string3.substring(n + 8)).length() > 1) {
                String string4 = string3.substring(0, 1);
                n = (string3 = string3.substring(1)).indexOf(string4);
                if (n >= 0) {
                    string3 = string3.substring(0, n);
                    try {
                        uRL = this.baseURL != null ? new URL(this.baseURL, string3) : new URL(string3);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
            if (this.allowXMLCatalogPI) {
                if (this.catalogManager.getAllowOasisXMLCatalogPI()) {
                    this.catalogManager.debug.message(4, "oasis-xml-catalog PI", string2);
                    if (uRL != null) {
                        try {
                            this.catalogManager.debug.message(4, "oasis-xml-catalog", uRL.toString());
                            this.oasisXMLCatalogPI = true;
                            if (this.piCatalogResolver == null) {
                                this.piCatalogResolver = new CatalogResolver(true);
                            }
                            this.piCatalogResolver.getCatalog().parseCatalog(uRL.toString());
                        }
                        catch (Exception exception) {
                            this.catalogManager.debug.message(3, "Exception parsing oasis-xml-catalog: " + uRL.toString());
                        }
                    } else {
                        this.catalogManager.debug.message(3, "PI oasis-xml-catalog unparseable: " + string2);
                    }
                } else {
                    this.catalogManager.debug.message(4, "PI oasis-xml-catalog ignored: " + string2);
                }
            } else {
                this.catalogManager.debug.message(3, "PI oasis-xml-catalog occurred in an invalid place: " + string2);
            }
        } else if (this.documentHandler != null) {
            this.documentHandler.processingInstruction(string, string2);
        }
    }

    public void setDocumentLocator(Locator locator) {
        if (this.documentHandler != null) {
            this.documentHandler.setDocumentLocator(locator);
        }
    }

    public void startDocument() throws SAXException {
        if (this.documentHandler != null) {
            this.documentHandler.startDocument();
        }
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        this.allowXMLCatalogPI = false;
        if (this.documentHandler != null) {
            this.documentHandler.startElement(string, attributeList);
        }
    }

    public void notationDecl(String string, String string2, String string3) throws SAXException {
        this.allowXMLCatalogPI = false;
        if (this.dtdHandler != null) {
            this.dtdHandler.notationDecl(string, string2, string3);
        }
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        this.allowXMLCatalogPI = false;
        if (this.dtdHandler != null) {
            this.dtdHandler.unparsedEntityDecl(string, string2, string3, string4);
        }
    }

    public InputSource resolveEntity(String string, String string2) {
        this.allowXMLCatalogPI = false;
        String string3 = this.catalogResolver.getResolvedEntity(string, string2);
        if (string3 == null && this.piCatalogResolver != null) {
            string3 = this.piCatalogResolver.getResolvedEntity(string, string2);
        }
        if (string3 != null) {
            try {
                InputSource inputSource = new InputSource(string3);
                inputSource.setPublicId(string);
                URL uRL = new URL(string3);
                InputStream inputStream = uRL.openStream();
                inputSource.setByteStream(inputStream);
                return inputSource;
            }
            catch (Exception exception) {
                this.catalogManager.debug.message(1, "Failed to create InputSource", string3);
                return null;
            }
        }
        return null;
    }

    private void setupParse(String string) {
        this.allowXMLCatalogPI = true;
        this.parser.setEntityResolver(this);
        this.parser.setDocumentHandler(this);
        this.parser.setDTDHandler(this);
        URL uRL = null;
        try {
            uRL = FileURL.makeURL("basename");
        }
        catch (MalformedURLException malformedURLException) {
            uRL = null;
        }
        try {
            this.baseURL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            if (uRL != null) {
                try {
                    this.baseURL = new URL(uRL, string);
                }
                catch (MalformedURLException malformedURLException2) {
                    this.baseURL = null;
                }
            }
            this.baseURL = null;
        }
    }

    private void explain(String string) {
        if (!suppressExplanation) {
            System.out.println("Parser probably encountered bad URI in " + string);
            System.out.println("For example, replace '/some/uri' with 'file:/some/uri'.");
        }
    }
}

