/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;
import org.jboss.deployment.Deployer;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.DeploymentInfoComparator;
import org.jboss.deployment.DeploymentSorter;
import org.jboss.deployment.DeploymentState;
import org.jboss.deployment.IncompleteDeploymentException;
import org.jboss.deployment.JARDeployer;
import org.jboss.deployment.MainDeployerMBean;
import org.jboss.deployment.SerializableDeploymentInfo;
import org.jboss.deployment.SubDeployer;
import org.jboss.deployment.SuffixOrderHelper;
import org.jboss.mx.util.JMXExceptionDecoder;
import org.jboss.system.ServiceContext;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.server.ServerConfig;
import org.jboss.system.server.ServerConfigLocator;
import org.jboss.util.file.Files;
import org.jboss.util.file.JarUtils;
import org.jboss.util.stream.Streams;

public class MainDeployer
extends ServiceMBeanSupport
implements Deployer,
MainDeployerMBean {
    private ObjectName serviceController;
    private final LinkedList deployers = new LinkedList();
    private final Map deploymentMap = Collections.synchronizedMap(new HashMap());
    private final List deploymentList = new ArrayList();
    private final List waitingDeployments = new ArrayList();
    private final DeploymentSorter sorter = new DeploymentSorter();
    private final Comparator infoSorter = new DeploymentInfoComparator(this.sorter);
    private final SuffixOrderHelper suffixOrderHelper = new SuffixOrderHelper(this.sorter);
    private boolean copyFiles = true;
    private File tempDir;
    private String tempDirString;

    public MainDeployer() {
        String localCopy = System.getProperty("jboss.deploy.localcopy");
        if (localCopy != null && (localCopy.equalsIgnoreCase("false") || localCopy.equalsIgnoreCase("no") || localCopy.equalsIgnoreCase("off"))) {
            this.log.debug((Object)"Disabling local copies of file: urls");
            this.copyFiles = false;
        }
    }

    public boolean getCopyFiles() {
        return this.copyFiles;
    }

    public void setCopyFiles(boolean copyFiles) {
        this.copyFiles = copyFiles;
    }

    public File getTempDir() {
        return this.tempDir;
    }

    public void setTempDir(File tempDir) {
        this.tempDir = tempDir;
    }

    public String getTempDirString() {
        return this.tempDirString;
    }

    public String[] getSuffixOrder() {
        return this.suffixOrderHelper.getSuffixOrder();
    }

    public String[] getEnhancedSuffixOrder() {
        return this.suffixOrderHelper.getEnhancedSuffixOrder();
    }

    public void setEnhancedSuffixOrder(String[] enhancedSuffixOrder) {
        this.suffixOrderHelper.setEnhancedSuffixOrder(enhancedSuffixOrder);
    }

    public void setServiceController(ObjectName serviceController) {
        this.serviceController = serviceController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection listDeployed() {
        List list = this.deploymentList;
        synchronized (list) {
            this.log.debug((Object)("deployment list string: " + this.deploymentList));
            return new ArrayList(this.deploymentList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection listDeployedModules() {
        this.log.debug((Object)"listDeployedModules");
        HashMap<URL, SerializableDeploymentInfo> map = new HashMap<URL, SerializableDeploymentInfo>();
        List list = this.deploymentList;
        synchronized (list) {
            ArrayList col = new ArrayList(this.deploymentList);
            Iterator it = col.iterator();
            while (it.hasNext()) {
                DeploymentInfo info = (DeploymentInfo)it.next();
                map.put(info.url, new SerializableDeploymentInfo(info));
                this.fillParentAndChildrenSDI(info, map);
            }
        }
        return new ArrayList(map.values());
    }

    public String listDeployedAsString() {
        return "<pre>" + this.listDeployed() + "</pre>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection listIncompletelyDeployed() {
        ArrayList copy;
        ArrayList<DeploymentInfo> id = new ArrayList<DeploymentInfo>();
        List list = this.deploymentList;
        synchronized (list) {
            copy = new ArrayList(this.deploymentList);
        }
        Iterator i = copy.iterator();
        while (i.hasNext()) {
            DeploymentInfo di = (DeploymentInfo)i.next();
            if ("Deployed".equals(di.status) || "Starting".equals(di.status)) continue;
            id.add(di);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection listWaitingForDeployer() {
        List list = this.waitingDeployments;
        synchronized (list) {
            return new ArrayList(this.waitingDeployments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeployer(SubDeployer deployer) {
        this.log.debug((Object)("Adding deployer: " + deployer));
        LinkedList linkedList = this.deployers;
        synchronized (linkedList) {
            this.deployers.addFirst(deployer);
            this.suffixOrderHelper.addSuffixes(deployer.getSuffixes(), deployer.getRelativeOrder());
        }
        Notification msg = new Notification("org.jboss.deployment.MainDeployer.addDeployer", this, this.getNextNotificationSequenceNumber());
        msg.setUserData(deployer.getServiceName());
        this.sendNotification(msg);
        List list = this.waitingDeployments;
        synchronized (list) {
            ArrayList copy = new ArrayList(this.waitingDeployments);
            this.waitingDeployments.clear();
            Iterator i = copy.iterator();
            while (i.hasNext()) {
                DeploymentInfo di = (DeploymentInfo)i.next();
                this.log.debug((Object)("trying to deploy with new deployer: " + di.shortName));
                try {
                    di.setServer(this.server);
                    this.deploy(di);
                }
                catch (DeploymentException e) {
                    this.log.error((Object)"DeploymentException while trying to deploy a package with a new deployer", (Throwable)((Object)e));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDeployer(SubDeployer deployer) {
        ArrayList copy;
        this.log.debug((Object)("Removing deployer: " + deployer));
        boolean removed = false;
        LinkedList linkedList = this.deployers;
        synchronized (linkedList) {
            removed = this.deployers.remove(deployer);
            this.suffixOrderHelper.removeSuffixes(deployer.getSuffixes(), deployer.getRelativeOrder());
        }
        if (removed) {
            Notification msg = new Notification("org.jboss.deployment.MainDeployer.removeDeployer", this, this.getNextNotificationSequenceNumber());
            msg.setUserData(deployer.getServiceName());
            this.sendNotification(msg);
        }
        List list = this.deploymentList;
        synchronized (list) {
            copy = new ArrayList(this.deploymentList);
        }
        Iterator i = copy.iterator();
        while (i.hasNext()) {
            DeploymentInfo di = (DeploymentInfo)i.next();
            if (di.deployer != deployer) continue;
            this.undeploy(di);
            di.deployer = null;
            List list2 = this.waitingDeployments;
            synchronized (list2) {
                this.waitingDeployments.add(di);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection listDeployers() {
        ArrayList<ObjectName> deployerNames = new ArrayList<ObjectName>();
        LinkedList linkedList = this.deployers;
        synchronized (linkedList) {
            for (int n = 0; n < this.deployers.size(); ++n) {
                SubDeployer deployer = (SubDeployer)this.deployers.get(n);
                ObjectName name = deployer.getServiceName();
                deployerNames.add(name);
            }
        }
        return deployerNames;
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return name == null ? OBJECT_NAME : name;
    }

    protected void createService() throws Exception {
        ServerConfig config = ServerConfigLocator.locate();
        File basedir = config.getServerTempDir();
        this.tempDir = new File(basedir, "deploy");
        Files.delete((File)this.tempDir);
        this.tempDir.mkdirs();
        this.tempDirString = this.tempDir.toURL().toString();
        this.suffixOrderHelper.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ArrayList copy;
        int deployCounter = 0;
        List list = this.deploymentList;
        synchronized (list) {
            copy = new ArrayList(this.deploymentList);
        }
        ListIterator i = copy.listIterator(copy.size());
        while (i.hasPrevious()) {
            try {
                this.undeploy((DeploymentInfo)i.previous(), true);
                ++deployCounter;
            }
            catch (Exception e) {
                this.log.info((Object)"exception trying to undeploy during shutdown", (Throwable)e);
            }
        }
        this.log.debug((Object)("Undeployed " + deployCounter + " deployed packages"));
    }

    public void redeploy(String urlspec) throws DeploymentException, MalformedURLException {
        this.redeploy(new URL(urlspec));
    }

    public void redeploy(URL url) throws DeploymentException {
        DeploymentInfo sdi = this.getDeployment(url);
        if (sdi != null) {
            this.redeploy(sdi);
        } else {
            this.deploy(url);
        }
    }

    public void redeploy(DeploymentInfo sdi) throws DeploymentException {
        try {
            this.undeploy(sdi);
        }
        catch (Throwable t) {
            this.log.info((Object)"Throwable from undeployment attempt: ", t);
        }
        sdi.setServer(this.server);
        this.deploy(sdi);
    }

    public void undeploy(URL url) throws DeploymentException {
        DeploymentInfo sdi = this.getDeployment(url);
        if (sdi != null) {
            this.undeploy(sdi);
        }
    }

    public void undeploy(String urlspec) throws DeploymentException, MalformedURLException {
        this.undeploy(new URL(urlspec));
    }

    public void undeploy(DeploymentInfo di) {
        this.undeploy(di, false);
    }

    protected void undeploy(DeploymentInfo di, boolean isShutdown) {
        this.log.debug((Object)("Undeploying " + di.url));
        this.stop(di);
        this.destroy(di);
    }

    private void stop(DeploymentInfo di) {
        ArrayList reverseSortedSubs = new ArrayList(di.subDeployments);
        Collections.sort(reverseSortedSubs, this.infoSorter);
        Collections.reverse(reverseSortedSubs);
        Iterator subs = reverseSortedSubs.iterator();
        while (subs.hasNext()) {
            DeploymentInfo sub = (DeploymentInfo)subs.next();
            this.log.debug((Object)("Stopping sub deployment: " + sub.url));
            this.stop(sub);
        }
        try {
            if (di.deployer != null) {
                di.deployer.stop(di);
                di.status = "Stopped";
                di.state = DeploymentState.STOPPED;
            }
        }
        catch (Throwable t) {
            this.log.error((Object)("Undeployment failed: " + di.url), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroy(DeploymentInfo di) {
        ArrayList reverseSortedSubs = new ArrayList(di.subDeployments);
        Collections.sort(reverseSortedSubs, this.infoSorter);
        Collections.reverse(reverseSortedSubs);
        Iterator subs = reverseSortedSubs.iterator();
        while (subs.hasNext()) {
            DeploymentInfo sub = (DeploymentInfo)subs.next();
            this.log.debug((Object)("Destroying sub deployment: " + sub.url));
            this.destroy(sub);
        }
        try {
            if (di.deployer != null) {
                di.deployer.destroy(di);
                di.status = "Destroyed";
                di.state = DeploymentState.DESTROYED;
            }
        }
        catch (Throwable t) {
            this.log.error((Object)("Undeployment failed: " + di.url), t);
            di.state = DeploymentState.FAILED;
        }
        try {
            List t = this.deploymentList;
            synchronized (t) {
                this.deploymentMap.remove(di.url);
                if (this.deploymentList.lastIndexOf(di) != -1) {
                    this.deploymentList.remove(this.deploymentList.lastIndexOf(di));
                }
            }
            t = this.waitingDeployments;
            synchronized (t) {
                this.waitingDeployments.remove(di);
            }
            di.cleanup();
            this.log.debug((Object)("Undeployed " + di.url));
        }
        catch (Throwable t) {
            this.log.error((Object)("Undeployment cleanup failed: " + di.url), t);
        }
    }

    public void deploy(String urlspec) throws DeploymentException, MalformedURLException {
        URL url;
        if (this.server == null) {
            throw new DeploymentException("The MainDeployer has been unregistered");
        }
        try {
            url = new URL(urlspec);
        }
        catch (MalformedURLException e) {
            File file = new File(urlspec);
            url = file.toURL();
        }
        this.deploy(url);
    }

    public void deploy(URL url) throws DeploymentException {
        DeploymentInfo sdi = this.getDeployment(url);
        if (sdi == null) {
            sdi = new DeploymentInfo(url, null, this.getServer());
            this.deploy(sdi);
        }
        if (sdi.state != DeploymentState.STARTED) {
            this.checkIncompleteDeployments();
        }
    }

    public void deploy(DeploymentInfo deployment) throws DeploymentException {
        if (this.isDeployed(deployment.url)) {
            this.log.info((Object)("Package: " + deployment.url + " is already deployed"));
            return;
        }
        this.log.debug((Object)("Starting deployment of package: " + deployment.url));
        boolean inited = false;
        try {
            inited = this.init(deployment);
        }
        catch (Throwable t) {
            this.log.error((Object)("Could not initialise deployment: " + deployment.url), t);
            DeploymentException.rethrowAsDeploymentException("Could not initialise deployment: " + deployment.url, t);
        }
        if (inited) {
            this.create(deployment);
            this.start(deployment);
            this.log.debug((Object)("Deployed package: " + deployment.url));
        } else {
            this.log.debug((Object)("Deployment of package: " + deployment.url + " is waiting for an appropriate deployer."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean init(DeploymentInfo deployment) throws DeploymentException {
        Object localCl2332;
        block33: {
            if (this.isDeployed(deployment.url)) {
                this.log.info((Object)("Package: " + deployment.url + " is already deployed"));
                return false;
            }
            this.log.debug((Object)("Starting deployment (init step) of package at: " + deployment.url));
            if (deployment.localUrl == null) {
                this.makeLocalCopy(deployment);
                localCl2332 = new URL[]{deployment.localUrl};
                deployment.localCl = new URLClassLoader((URL[])localCl2332);
            }
            this.findDeployer(deployment);
            if (deployment.deployer != null) break block33;
            deployment.state = DeploymentState.INIT_WAITING_DEPLOYER;
            this.log.debug((Object)("deployment waiting for deployer: " + deployment.url));
            localCl2332 = this.waitingDeployments;
            synchronized (localCl2332) {
                if (!this.waitingDeployments.contains(deployment)) {
                    this.waitingDeployments.add(deployment);
                }
            }
            boolean localCl2332 = false;
            Object var6_7 = null;
            try {
                URL url = deployment.localUrl == null ? deployment.url : deployment.localUrl;
                long lastModified = -1L;
                lastModified = url.getProtocol().equals("file") ? new File(url.getFile()).lastModified() : url.openConnection().getLastModified();
                deployment.lastModified = lastModified;
                deployment.lastDeployed = System.currentTimeMillis();
            }
            catch (IOException ignore) {
                deployment.lastModified = System.currentTimeMillis();
                deployment.lastDeployed = System.currentTimeMillis();
            }
            List list = this.deploymentList;
            synchronized (list) {
                if (!this.inLocalCopyDir(deployment.url) && !this.deploymentList.contains(deployment)) {
                    this.deploymentList.add(deployment);
                    this.log.debug((Object)("Watching new file: " + deployment.url));
                }
            }
            return localCl2332;
        }
        deployment.state = DeploymentState.INIT_DEPLOYER;
        deployment.deployer.init(deployment);
        deployment.createClassLoaders();
        deployment.state = DeploymentState.INITIALIZED;
        localCl2332 = this.deploymentList;
        synchronized (localCl2332) {
            this.deploymentMap.put(deployment.url, deployment);
        }
        this.parseManifestLibraries(deployment);
        this.log.debug((Object)("found " + deployment.subDeployments.size() + " subpackages of " + deployment.url));
        ArrayList sortedSubs = new ArrayList(deployment.subDeployments);
        Collections.sort(sortedSubs, this.infoSorter);
        ListIterator lt = sortedSubs.listIterator();
        while (lt.hasNext()) {
            this.init((DeploymentInfo)lt.next());
        }
        Object var6_8 = null;
        try {
            URL url = deployment.localUrl == null ? deployment.url : deployment.localUrl;
            long lastModified = -1L;
            lastModified = url.getProtocol().equals("file") ? new File(url.getFile()).lastModified() : url.openConnection().getLastModified();
            deployment.lastModified = lastModified;
            deployment.lastDeployed = System.currentTimeMillis();
        }
        catch (IOException ignore) {
            deployment.lastModified = System.currentTimeMillis();
            deployment.lastDeployed = System.currentTimeMillis();
        }
        List list = this.deploymentList;
        synchronized (list) {
            if (!this.inLocalCopyDir(deployment.url) && !this.deploymentList.contains(deployment)) {
                this.deploymentList.add(deployment);
                this.log.debug((Object)("Watching new file: " + deployment.url));
            }
        }
        {
            catch (Exception e) {
                deployment.state = DeploymentState.FAILED;
                DeploymentException.rethrowAsDeploymentException("exception in init of " + deployment.url, e);
                Object var6_9 = null;
                try {
                    URL url = deployment.localUrl == null ? deployment.url : deployment.localUrl;
                    long lastModified = -1L;
                    lastModified = url.getProtocol().equals("file") ? new File(url.getFile()).lastModified() : url.openConnection().getLastModified();
                    deployment.lastModified = lastModified;
                    deployment.lastDeployed = System.currentTimeMillis();
                }
                catch (IOException ignore) {
                    deployment.lastModified = System.currentTimeMillis();
                    deployment.lastDeployed = System.currentTimeMillis();
                }
                List list2 = this.deploymentList;
                synchronized (list2) {
                    if (!this.inLocalCopyDir(deployment.url) && !this.deploymentList.contains(deployment)) {
                        this.deploymentList.add(deployment);
                        this.log.debug((Object)("Watching new file: " + deployment.url));
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            try {
                URL url = deployment.localUrl == null ? deployment.url : deployment.localUrl;
                long lastModified = -1L;
                lastModified = url.getProtocol().equals("file") ? new File(url.getFile()).lastModified() : url.openConnection().getLastModified();
                deployment.lastModified = lastModified;
                deployment.lastDeployed = System.currentTimeMillis();
            }
            catch (IOException ignore) {
                deployment.lastModified = System.currentTimeMillis();
                deployment.lastDeployed = System.currentTimeMillis();
            }
            List list3 = this.deploymentList;
            synchronized (list3) {
                if (!this.inLocalCopyDir(deployment.url) && !this.deploymentList.contains(deployment)) {
                    this.deploymentList.add(deployment);
                    this.log.debug((Object)("Watching new file: " + deployment.url));
                }
            }
            throw throwable;
        }
        return true;
    }

    private void create(DeploymentInfo deployment) throws DeploymentException {
        block6: {
            this.log.debug((Object)("create step for deployment " + deployment.url));
            try {
                ArrayList sortedSubs = new ArrayList(deployment.subDeployments);
                Collections.sort(sortedSubs, this.infoSorter);
                ListIterator lt = sortedSubs.listIterator();
                while (lt.hasNext()) {
                    this.create((DeploymentInfo)lt.next());
                }
                deployment.state = DeploymentState.CREATE_SUBDEPLOYMENTS;
                if (deployment.deployer != null) {
                    try {
                        deployment.state = DeploymentState.CREATE_DEPLOYER;
                        deployment.deployer.create(deployment);
                        deployment.state = DeploymentState.CREATED;
                        deployment.status = "Created";
                        this.log.debug((Object)("Done with create step of deploying " + deployment.shortName));
                        break block6;
                    }
                    catch (Throwable t) {
                        this.log.error((Object)("Could not create deployment: " + deployment.url), t);
                        throw t;
                    }
                }
                this.log.debug((Object)("Still no deployer for package in create step: " + deployment.shortName));
            }
            catch (Throwable t) {
                this.log.trace((Object)("could not create deployment: " + deployment.url), t);
                deployment.status = "Deployment FAILED reason: " + t.getMessage();
                deployment.state = DeploymentState.FAILED;
                DeploymentException.rethrowAsDeploymentException("Could not create deployment: " + deployment.url, t);
            }
        }
    }

    private void start(DeploymentInfo deployment) throws DeploymentException {
        block6: {
            deployment.status = "Starting";
            this.log.debug((Object)("Begin deployment start " + deployment.url));
            try {
                ArrayList sortedSubs = new ArrayList(deployment.subDeployments);
                Collections.sort(sortedSubs, this.infoSorter);
                ListIterator lt = sortedSubs.listIterator();
                while (lt.hasNext()) {
                    this.start((DeploymentInfo)lt.next());
                }
                deployment.state = DeploymentState.START_SUBDEPLOYMENTS;
                if (deployment.deployer != null) {
                    try {
                        deployment.state = DeploymentState.START_DEPLOYER;
                        deployment.deployer.start(deployment);
                        Object[] args = new Object[]{deployment, DeploymentState.STARTED};
                        String[] sig = new String[]{"org.jboss.deployment.DeploymentInfo", "org.jboss.deployment.DeploymentState"};
                        this.server.invoke(this.serviceController, "validateDeploymentState", args, sig);
                        deployment.status = "Deployed";
                        this.log.debug((Object)("End deployment start on package: " + deployment.shortName));
                        break block6;
                    }
                    catch (Throwable t) {
                        this.log.error((Object)("Could not start deployment: " + deployment.url), t);
                        throw t;
                    }
                }
                this.log.debug((Object)("Still no deployer for package in start step: " + deployment.shortName));
            }
            catch (Throwable t) {
                this.log.trace((Object)("could not start deployment: " + deployment.url), t);
                deployment.state = DeploymentState.FAILED;
                deployment.status = "Deployment FAILED reason: " + t.getMessage();
                DeploymentException.rethrowAsDeploymentException("Could not create deployment: " + deployment.url, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findDeployer(DeploymentInfo sdi) {
        if (sdi.deployer != null) {
            this.log.debug((Object)("using existing deployer " + sdi.deployer));
            return;
        }
        LinkedList linkedList = this.deployers;
        synchronized (linkedList) {
            Iterator iterator = this.deployers.iterator();
            while (iterator.hasNext()) {
                SubDeployer deployer = (SubDeployer)iterator.next();
                if (!deployer.accepts(sdi)) continue;
                sdi.deployer = deployer;
                this.log.debug((Object)("using deployer " + deployer));
                return;
            }
        }
        this.log.debug((Object)("No deployer found for url: " + sdi.url));
    }

    private void parseManifestLibraries(DeploymentInfo sdi) {
        String classPath = null;
        Manifest mf = sdi.getManifest();
        if (mf != null) {
            Attributes mainAttributes = mf.getMainAttributes();
            classPath = mainAttributes.getValue(Attributes.Name.CLASS_PATH);
        }
        if (classPath != null) {
            StringTokenizer st = new StringTokenizer(classPath);
            this.log.debug((Object)("resolveLibraries: " + classPath));
            while (st.hasMoreTokens()) {
                URL lib = null;
                String tk = st.nextToken();
                this.log.debug((Object)("new manifest entry for sdi at " + sdi.shortName + " entry is " + tk));
                try {
                    if (sdi.isDirectory) {
                        File parentDir = new File(sdi.url.getPath()).getParentFile();
                        lib = new File(parentDir, tk).toURL();
                    } else {
                        lib = new URL(sdi.url, tk);
                    }
                    if (this.deploymentMap.containsKey(lib)) continue;
                    DeploymentInfo mfRef = new DeploymentInfo(lib, null, this.getServer());
                    this.makeLocalCopy(mfRef);
                    URL[] localURL = new URL[]{mfRef.localUrl};
                    mfRef.localCl = new URLClassLoader(localURL);
                    this.findDeployer(mfRef);
                    SubDeployer deployer = mfRef.deployer;
                    if (deployer != null && !(deployer instanceof JARDeployer)) {
                        this.log.warn((Object)("Found non-jar deployer for " + tk + ": " + deployer));
                    }
                    sdi.addLibraryJar(lib);
                }
                catch (Exception ignore) {
                    this.log.debug((Object)("The manifest entry in " + sdi.url + " references URL " + lib + " which could not be opened, entry ignored"), (Throwable)ignore);
                }
            }
        }
    }

    private void makeLocalCopy(DeploymentInfo sdi) {
        try {
            if (sdi.url.getProtocol().equals("file") && (!this.copyFiles || sdi.isDirectory)) {
                sdi.localUrl = sdi.url;
                return;
            }
            if (this.inLocalCopyDir(sdi.url)) {
                sdi.localUrl = sdi.url;
                return;
            }
            String shortName = sdi.shortName;
            File localFile = File.createTempFile("tmp", shortName, this.tempDir);
            sdi.localUrl = localFile.toURL();
            this.copy(sdi.url, localFile);
        }
        catch (Exception e) {
            this.log.error((Object)("Could not make local copy for " + sdi.url), (Throwable)e);
        }
    }

    private boolean inLocalCopyDir(URL url) {
        int i = 0;
        String urlTest = url.toString();
        if (urlTest.startsWith("jar:")) {
            i = 4;
        }
        return urlTest.startsWith(this.tempDirString, i);
    }

    protected void copy(URL src, File dest) throws IOException {
        File srcFile;
        boolean deleted;
        boolean created;
        this.log.debug((Object)("Copying " + src + " -> " + dest));
        File dir = dest.getParentFile();
        if (!dir.exists() && !(created = dir.mkdirs())) {
            throw new IOException("mkdirs failed for: " + dir.getAbsolutePath());
        }
        if (dest.exists() && !(deleted = Files.delete((File)dest))) {
            throw new IOException("delete of previous content failed for: " + dest.getAbsolutePath());
        }
        if (src.getProtocol().equals("file") && (srcFile = new File(src.getFile())).isDirectory()) {
            this.log.debug((Object)("Making zip copy of: " + srcFile));
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));
            JarUtils.jar((OutputStream)out, (File[])srcFile.listFiles());
            ((OutputStream)out).close();
            return;
        }
        BufferedInputStream in = new BufferedInputStream(src.openStream());
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));
        Streams.copy((InputStream)in, (OutputStream)out);
        ((OutputStream)out).flush();
        ((OutputStream)out).close();
        ((InputStream)in).close();
    }

    public void start(String urlspec) throws DeploymentException, MalformedURLException {
        DeploymentInfo sdi = this.getDeployment(new URL(urlspec));
        if (sdi != null) {
            this.start(sdi);
        }
    }

    public void stop(String urlspec) throws DeploymentException, MalformedURLException {
        DeploymentInfo sdi = this.getDeployment(new URL(urlspec));
        if (sdi != null) {
            this.stop(sdi);
        }
    }

    public boolean isDeployed(String url) throws MalformedURLException {
        return this.isDeployed(new URL(url));
    }

    public boolean isDeployed(URL url) {
        DeploymentInfo di = this.getDeployment(url);
        if (di == null) {
            return false;
        }
        return di.state == DeploymentState.STARTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentInfo getDeployment(URL url) {
        List list = this.deploymentList;
        synchronized (list) {
            return (DeploymentInfo)this.deploymentMap.get(url);
        }
    }

    public URL getWatchUrl(URL url) {
        DeploymentInfo info = this.getDeployment(url);
        return info == null ? null : info.watch;
    }

    public void checkIncompleteDeployments() throws DeploymentException {
        try {
            HashSet waitingForClasses = new HashSet();
            Collection waitingForDepends = (Collection)this.server.invoke(this.serviceController, "listIncompletelyDeployed", new Object[0], new String[0]);
            Collection allServices = (Collection)this.server.invoke(this.serviceController, "listDeployed", new Object[0], new String[0]);
            HashSet rootCause = new HashSet(waitingForDepends);
            HashSet<ServiceContext> missing = new HashSet<ServiceContext>();
            Iterator i = rootCause.iterator();
            block2: while (i.hasNext()) {
                ServiceContext ctx = (ServiceContext)i.next();
                Iterator j = ctx.iDependOn.iterator();
                while (j.hasNext()) {
                    ServiceContext dependee = (ServiceContext)j.next();
                    if (dependee.state == 3) continue;
                    if (!allServices.contains(dependee)) {
                        missing.add(dependee);
                    }
                    i.remove();
                    continue block2;
                }
            }
            rootCause.addAll(missing);
            IncompleteDeploymentException ide = new IncompleteDeploymentException(waitingForClasses, waitingForDepends, rootCause, this.listIncompletelyDeployed(), this.listWaitingForDeployer());
            if (!ide.isEmpty()) {
                throw ide;
            }
        }
        catch (JMException jme) {
            throw new DeploymentException(JMXExceptionDecoder.decode((Throwable)jme));
        }
    }

    private void fillParentAndChildrenSDI(DeploymentInfo parent, Map map) {
        Set subDeployments = parent.subDeployments;
        Iterator it = subDeployments.iterator();
        while (it.hasNext()) {
            DeploymentInfo child = (DeploymentInfo)it.next();
            SerializableDeploymentInfo sdichild = this.returnSDI(child, map);
            sdichild.parent = this.returnSDI(parent, map);
            sdichild.parent.subDeployments.add(sdichild);
            this.fillParentAndChildrenSDI(child, map);
        }
    }

    private SerializableDeploymentInfo returnSDI(DeploymentInfo di, Map map) {
        SerializableDeploymentInfo sdi = (SerializableDeploymentInfo)map.get(di.url);
        if (sdi == null) {
            sdi = new SerializableDeploymentInfo(di);
            map.put(di.url, sdi);
        }
        return sdi;
    }
}

