/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.outputprogress;

import com.icesoft.faces.component.outputprogress.OutputProgress;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicInputRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeRenderer;
import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class OutputProgressRenderer
extends DomBasicInputRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Element table;
        this.validateParameters(facesContext, uiComponent, OutputProgress.class);
        DOMContext domContext = DOMContext.attachDOMContext((FacesContext)facesContext, (UIComponent)uiComponent);
        if (!domContext.isInitialized()) {
            table = domContext.createRootElement("table");
            OutputProgressRenderer.setRootElementId((FacesContext)facesContext, (Element)table, (UIComponent)uiComponent);
            table.setAttribute("cellpadding", "0");
            table.setAttribute("cellspacing", "0");
            table.setAttribute("border", "0");
        }
        table = (Element)domContext.getRootNode();
        String style = ((OutputProgress)uiComponent).getStyle();
        if (style != null && style.length() > 0) {
            table.setAttribute("style", style);
        } else {
            table.removeAttribute("style");
        }
        this.buildLayout(table, uiComponent, domContext);
        if (PassThruAttributeRenderer.passThruAttributeExists((UIComponent)uiComponent)) {
            PassThruAttributeRenderer.renderAttributes((FacesContext)facesContext, (UIComponent)uiComponent, null);
        }
        domContext.stepOver();
        domContext.streamWrite(facesContext, uiComponent);
    }

    private void setPercentage(UIComponent uiComponent, DOMContext domContext, Text percentageText, Element fillBar) {
        String space = "&nbsp;";
        if (domContext.isStreamWriting()) {
            space = "";
        }
        OutputProgress progressBar = (OutputProgress)uiComponent;
        String progressLabel = progressBar.getProgressLabel();
        int percentValue = progressBar.getValue();
        if (percentValue > 100) {
            percentValue = 100;
        }
        if (percentValue < 0) {
            percentValue = 0;
        }
        if (!progressBar.getIndeterminate()) {
            percentageText.setData(percentValue + " %");
        }
        if (percentValue < 100) {
            if (progressLabel != null && progressLabel.length() > 0) {
                percentageText.setData(progressLabel);
            }
            if (progressBar.getIndeterminate()) {
                if (percentValue < 1) {
                    fillBar.setAttribute("class", progressBar.getIndeterminateInactiveClass());
                    percentageText.setData(space);
                } else {
                    fillBar.setAttribute("class", progressBar.getIndeterminateActiveClass());
                    fillBar.setAttribute("style", "position:absolute;width:100%");
                    if (progressLabel != null && progressLabel.length() > 0) {
                        percentageText.setData(progressLabel);
                    } else {
                        percentageText.setData(space);
                    }
                }
            }
        } else {
            String progressCompleteLabel;
            if (progressBar.getIndeterminate()) {
                fillBar.setAttribute("class", progressBar.getIndeterminateInactiveClass());
                fillBar.setAttribute("style", "position:absolute;width:100%;");
            }
            if ((progressCompleteLabel = progressBar.getProgressLabelComplete()) != null && progressCompleteLabel.length() > 0) {
                percentageText.setData(progressCompleteLabel);
            }
        }
        if (!progressBar.getIndeterminate()) {
            Node node = fillBar.getFirstChild();
            if (node instanceof Text) {
                if (percentValue <= 0) {
                    fillBar.removeChild(node);
                }
            } else if (node == null && percentValue > 0) {
                Text nbsp4opera = domContext.createTextNode("&nbsp;");
                fillBar.appendChild(nbsp4opera);
            }
        }
        if (!progressBar.getIndeterminate()) {
            fillBar.setAttribute("style", "position:absolute;width:" + percentValue + "%;");
        }
    }

    private void buildLayout(Element table, UIComponent uiComponent, DOMContext domContext) {
        Element row2;
        String space = "&nbsp;";
        if (domContext.isStreamWriting()) {
            space = "";
        }
        Node node = table.getFirstChild();
        Element tbody = domContext.createElement("tbody");
        if (node != null) {
            table.replaceChild(tbody, node);
        } else {
            table.appendChild(tbody);
        }
        OutputProgress progressBar = (OutputProgress)uiComponent;
        table.setAttribute("class", progressBar.getStyleClass());
        Element row = domContext.createElement("tr");
        Element textTd = domContext.createElement("td");
        textTd.setAttribute("class", progressBar.getTextClass());
        Element barTd = domContext.createElement("td");
        tbody.appendChild(row);
        Text percentageText = null;
        percentageText = progressBar.getProgressLabel() != null ? domContext.createTextNode(space) : domContext.createTextNode("0 %");
        textTd.appendChild(percentageText);
        textTd.setAttribute("id", uiComponent.getClientId(FacesContext.getCurrentInstance()) + "percentageText");
        Element bgBar = domContext.createElement("div");
        bgBar.setAttribute("class", progressBar.getBackgroundClass());
        bgBar.setAttribute("style", "position:relative;");
        Element fillBar = domContext.createElement("div");
        fillBar.setAttribute("id", uiComponent.getClientId(FacesContext.getCurrentInstance()) + "bar");
        if (!progressBar.getIndeterminate()) {
            fillBar.setAttribute("class", progressBar.getFillClass());
            fillBar.setAttribute("style", "position:absolute;width:0%");
        } else {
            fillBar.setAttribute("class", progressBar.getIndeterminateInactiveClass());
            fillBar.setAttribute("style", "position:absolute;width:100%;");
        }
        bgBar.appendChild(fillBar);
        Text nbsp4mozila = domContext.createTextNode(space);
        barTd.appendChild(bgBar);
        String textPosition = progressBar.getLabelPosition();
        if (!this.isValidTextPosition(textPosition.toString().toLowerCase())) {
            throw new FacesException("Please define valid textPosition [top|bottom|left|right|topcenter|bottomcenter|topright|bottomright|embed]");
        }
        if (textPosition.toString().equalsIgnoreCase("left")) {
            textTd.setAttribute("style", "vertical-align: middle;");
            row.appendChild(textTd);
            row.appendChild(barTd);
        }
        if (textPosition.toString().equalsIgnoreCase("right")) {
            textTd.setAttribute("style", "vertical-align: middle;");
            row.appendChild(barTd);
            row.appendChild(textTd);
        }
        if (textPosition.toString().toLowerCase().startsWith("top")) {
            row2 = domContext.createElement("tr");
            row.appendChild(textTd);
            row2.appendChild(barTd);
            tbody.appendChild(row2);
            if (textPosition.toString().equalsIgnoreCase("topcenter")) {
                textTd.setAttribute("align", "center");
            }
            if (textPosition.toString().equalsIgnoreCase("topright")) {
                textTd.setAttribute("align", "right");
            }
        }
        if (textPosition.toString().toLowerCase().startsWith("bottom")) {
            row2 = domContext.createElement("tr");
            row.appendChild(barTd);
            row2.appendChild(textTd);
            tbody.appendChild(row2);
            if (textPosition.toString().equalsIgnoreCase("bottomcenter")) {
                textTd.setAttribute("align", "center");
            }
            if (textPosition.toString().equalsIgnoreCase("bottomright")) {
                textTd.setAttribute("align", "right");
            }
        }
        if (textPosition.toString().equalsIgnoreCase("embed")) {
            Element embedDiv = domContext.createElement("div");
            embedDiv.setAttribute("class", progressBar.getTextClass());
            embedDiv.setAttribute("style", "text-align:center;position:relative;background-color:transparent;width:100%;z-index:1;");
            embedDiv.appendChild(percentageText);
            if (!progressBar.getIndeterminate()) {
                bgBar.appendChild(embedDiv);
            } else {
                fillBar.appendChild(embedDiv);
            }
            row.appendChild(barTd);
        } else {
            Text nbsp4opera = domContext.createTextNode(space);
            fillBar.appendChild(nbsp4opera);
            bgBar.appendChild(nbsp4mozila);
        }
        this.setPercentage(uiComponent, domContext, percentageText, fillBar);
    }

    private boolean isValidTextPosition(String textPosition) {
        String[] validPosition = new String[]{"top", "bottom", "left", "right", "topcenter", "bottomcenter", "topright", "bottomright", "embed"};
        for (int i = 0; i < validPosition.length; ++i) {
            if (!validPosition[i].equals(textPosition)) continue;
            return true;
        }
        return false;
    }
}

