/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester;

import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.xml.sax.Attributes;

public class CallMethodRule
extends Rule {
    protected String bodyText = null;
    protected String methodName = null;
    protected int paramCount = 0;
    protected Class[] paramTypes = null;
    private String[] paramClassNames = null;
    protected boolean useExactMatch = false;
    static /* synthetic */ Class class$java$lang$String;

    public CallMethodRule(Digester digester, String methodName, int paramCount) {
        this(methodName, paramCount);
    }

    public CallMethodRule(Digester digester, String methodName, int paramCount, String[] paramTypes) {
        this(methodName, paramCount, paramTypes);
    }

    public CallMethodRule(Digester digester, String methodName, int paramCount, Class[] paramTypes) {
        this(methodName, paramCount, paramTypes);
    }

    public CallMethodRule(String methodName, int paramCount) {
        this.methodName = methodName;
        this.paramCount = paramCount;
        if (paramCount == 0) {
            this.paramTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = CallMethodRule.class$("java.lang.String")) : class$java$lang$String};
        } else {
            this.paramTypes = new Class[paramCount];
            int i = 0;
            while (i < this.paramTypes.length) {
                this.paramTypes[i] = class$java$lang$String == null ? CallMethodRule.class$("java.lang.String") : class$java$lang$String;
                ++i;
            }
        }
    }

    public CallMethodRule(String methodName) {
        this(methodName, 0, (Class[])null);
    }

    public CallMethodRule(String methodName, int paramCount, String[] paramTypes) {
        this.methodName = methodName;
        this.paramCount = paramCount;
        if (paramTypes == null) {
            this.paramTypes = new Class[paramCount];
            int i = 0;
            while (i < this.paramTypes.length) {
                this.paramTypes[i] = "abc".getClass();
                ++i;
            }
        } else {
            this.paramClassNames = new String[paramTypes.length];
            int i = 0;
            while (i < this.paramClassNames.length) {
                this.paramClassNames[i] = paramTypes[i];
                ++i;
            }
        }
    }

    public CallMethodRule(String methodName, int paramCount, Class[] paramTypes) {
        this.methodName = methodName;
        this.paramCount = paramCount;
        if (paramTypes == null) {
            this.paramTypes = new Class[paramCount];
            int i = 0;
            while (i < this.paramTypes.length) {
                this.paramTypes[i] = "abc".getClass();
                ++i;
            }
        } else {
            this.paramTypes = new Class[paramTypes.length];
            int i = 0;
            while (i < this.paramTypes.length) {
                this.paramTypes[i] = paramTypes[i];
                ++i;
            }
        }
    }

    public boolean getUseExactMatch() {
        return this.useExactMatch;
    }

    public void setUseExactMatch(boolean useExactMatch) {
        this.useExactMatch = useExactMatch;
    }

    public void setDigester(Digester digester) {
        super.setDigester(digester);
        if (this.paramClassNames != null) {
            this.paramTypes = new Class[this.paramClassNames.length];
            int i = 0;
            while (i < this.paramClassNames.length) {
                try {
                    this.paramTypes[i] = digester.getClassLoader().loadClass(this.paramClassNames[i]);
                }
                catch (ClassNotFoundException e) {
                    digester.getLogger().error((Object)("(CallMethodRule) Cannot load class " + this.paramClassNames[i]), (Throwable)e);
                    this.paramTypes[i] = null;
                }
                ++i;
            }
        }
    }

    public void begin(Attributes attributes) throws Exception {
        if (this.paramCount > 0) {
            String[] parameters = new String[this.paramCount];
            int i = 0;
            while (i < parameters.length) {
                parameters[i] = null;
                ++i;
            }
            this.digester.pushParams(parameters);
        }
    }

    public void body(String bodyText) throws Exception {
        if (this.paramCount == 0) {
            this.bodyText = bodyText.trim();
        }
    }

    public void end() throws Exception {
        String[] parameters = null;
        if (this.paramCount > 0) {
            parameters = (String[])this.digester.popParams();
            if (this.digester.log.isTraceEnabled()) {
                int i = 0;
                int size = parameters.length;
                while (i < size) {
                    this.digester.log.trace((Object)("[CallMethodRule](" + i + ")" + parameters[i]));
                    ++i;
                }
            }
            if (this.paramCount == 1 && parameters[0] == null) {
                return;
            }
        } else if (this.paramTypes != null && this.paramTypes.length != 0) {
            if (this.bodyText == null) {
                return;
            }
            parameters = new String[]{this.bodyText};
            if (this.paramTypes.length == 0) {
                this.paramTypes = new Class[1];
                this.paramTypes[0] = "abc".getClass();
            }
        }
        Object[] paramValues = new Object[this.paramTypes.length];
        int i = 0;
        while (i < this.paramTypes.length) {
            paramValues[i] = ConvertUtils.convert((String)parameters[i], (Class)this.paramTypes[i]);
            ++i;
        }
        Object top = this.digester.peek();
        if (this.digester.log.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer("[CallMethodRule]{");
            sb.append(this.digester.match);
            sb.append("} Call ");
            if (top == null) {
                sb.append("[NULL TOP]");
            } else {
                sb.append(top.getClass().getName());
            }
            sb.append(".");
            sb.append(this.methodName);
            sb.append("(");
            int i2 = 0;
            while (i2 < paramValues.length) {
                if (i2 > 0) {
                    sb.append(",");
                }
                if (paramValues[i2] == null) {
                    sb.append("null");
                } else {
                    sb.append(paramValues[i2].toString());
                }
                sb.append("/");
                if (this.paramTypes[i2] == null) {
                    sb.append("null");
                } else {
                    sb.append(this.paramTypes[i2].getName());
                }
                ++i2;
            }
            sb.append(")");
            this.digester.log.debug((Object)sb.toString());
        }
        if (this.useExactMatch) {
            MethodUtils.invokeExactMethod((Object)top, (String)this.methodName, (Object[])paramValues, (Class[])this.paramTypes);
        } else {
            MethodUtils.invokeMethod((Object)top, (String)this.methodName, (Object[])paramValues, (Class[])this.paramTypes);
        }
    }

    public void finish() throws Exception {
        this.bodyText = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("CallMethodRule[");
        sb.append("methodName=");
        sb.append(this.methodName);
        sb.append(", paramCount=");
        sb.append(this.paramCount);
        sb.append(", paramTypes={");
        if (this.paramTypes != null) {
            int i = 0;
            while (i < this.paramTypes.length) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.paramTypes[i].getName());
                ++i;
            }
        }
        sb.append("}");
        sb.append("]");
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

