/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogSource;
import org.apache.commons.validator.Constant;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.FormSet;
import org.apache.commons.validator.GenericValidator;
import org.apache.commons.validator.ValidatorAction;

public class ValidatorResources
implements Serializable {
    protected static Log log = LogSource.getInstance((String)(class$org$apache$commons$validator$ValidatorResources == null ? (class$org$apache$commons$validator$ValidatorResources = ValidatorResources.class$("org.apache.commons.validator.ValidatorResources")) : class$org$apache$commons$validator$ValidatorResources).getName());
    protected FastHashMap hFormSets = new FastHashMap();
    protected FastHashMap hConstants = new FastHashMap();
    protected FastHashMap hActions = new FastHashMap();
    protected static Locale defaultLocale = Locale.getDefault();
    static /* synthetic */ Class class$org$apache$commons$validator$ValidatorResources;

    public void put(FormSet formSet) {
        if (formSet != null) {
            this.hFormSets.put((Object)this.buildKey(formSet), (Object)formSet);
            if (log.isInfoEnabled()) {
                log.info((Object)("Adding FormSet '" + formSet.toString() + "'."));
            }
        }
    }

    public void addConstant(Constant constant) {
        if (constant != null && constant.getName() != null && constant.getName().length() > 0 && constant.getValue() != null && constant.getValue().length() > 0) {
            this.hConstants.put((Object)constant.getName(), (Object)constant.getValue());
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Add Global Constant: " + constant.getName() + "," + constant.getValue()));
        }
    }

    public void addConstantParam(String string, String string2) {
        if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
            this.hConstants.put((Object)string, (Object)string2);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Add Global Constant: " + string + "," + string2));
        }
    }

    public void addValidatorAction(ValidatorAction validatorAction) {
        if (validatorAction != null && validatorAction.getName() != null && validatorAction.getName().length() > 0 && validatorAction.getClassname() != null && validatorAction.getClassname().length() > 0 && validatorAction.getMethod() != null && validatorAction.getMethod().length() > 0) {
            validatorAction.process((Map)this.hConstants);
            this.hActions.put((Object)validatorAction.getName(), (Object)validatorAction);
            if (log.isInfoEnabled()) {
                log.info((Object)("Add ValidatorAction: " + validatorAction.getName() + "," + validatorAction.getClassname()));
            }
        }
    }

    public ValidatorAction getValidatorAction(String string) {
        return (ValidatorAction)this.hActions.get((Object)string);
    }

    public Map getValidatorActions() {
        return Collections.unmodifiableMap(this.hActions);
    }

    protected String buildKey(FormSet formSet) {
        String string = (formSet.getLanguage() != null && formSet.getLanguage().length() > 0 ? formSet.getLanguage() : "") + (formSet.getCountry() != null && formSet.getCountry().length() > 0 ? "_" + formSet.getCountry() : "") + (formSet.getVariant() != null && formSet.getVariant().length() > 0 ? "_" + formSet.getVariant() : "");
        if (string.length() == 0) {
            string = defaultLocale.toString();
        }
        return string;
    }

    public Form get(Locale locale, Object object) {
        return this.get(locale.getLanguage(), locale.getCountry(), locale.getVariant(), object);
    }

    public Form get(String string, String string2, String string3, Object object) {
        FormSet formSet = null;
        Form form = null;
        String string4 = null;
        Object object2 = null;
        string4 = (string != null && string.length() > 0 ? string : "") + (string2 != null && string2.length() > 0 ? "_" + string2 : "") + (string3 != null && string3.length() > 0 ? "_" + string3 : "");
        object2 = this.hFormSets.get((Object)string4);
        if (object2 != null && (formSet = (FormSet)object2) != null) {
            form = formSet.getForm(object);
        }
        if (form == null && (object2 = this.hFormSets.get((Object)(string4 = (string != null && string.length() > 0 ? string : "") + (string2 != null && string2.length() > 0 ? "_" + string2 : "")))) != null && (formSet = (FormSet)object2) != null) {
            form = formSet.getForm(object);
        }
        if (form == null && (object2 = this.hFormSets.get((Object)(string4 = string != null && string.length() > 0 ? string : ""))) != null && (formSet = (FormSet)object2) != null) {
            form = formSet.getForm(object);
        }
        if (form == null && (object2 = this.hFormSets.get((Object)(string4 = defaultLocale.toString()))) != null && (formSet = (FormSet)object2) != null) {
            form = formSet.getForm(object);
        }
        return form;
    }

    public void process() {
        this.hFormSets.setFast(true);
        this.hConstants.setFast(true);
        this.hActions.setFast(true);
        this.processForms();
    }

    public void processForms() {
        FormSet formSet;
        Object object;
        String string = defaultLocale.toString();
        Iterator iterator = this.hFormSets.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            formSet = (FormSet)this.hFormSets.get(object);
            if (((String)object).equals(string)) continue;
            Iterator iterator2 = formSet.getForms().keySet().iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                Form form = (Form)formSet.getForms().get(string2);
                Form form2 = new Form();
                form2.setName(form.getName());
                Form form3 = this.get(defaultLocale, string2);
                Iterator iterator3 = form3.getFields().iterator();
                while (iterator3.hasNext()) {
                    Field field = (Field)iterator3.next();
                    String string3 = field.getKey();
                    if (form.getFieldMap().containsKey(string3)) {
                        form2.addField((Field)form.getFieldMap().get(string3));
                        continue;
                    }
                    Field field2 = this.getClosestLocaleField(formSet, string2, string3);
                    form2.addField((Field)field2.clone());
                }
                formSet.addForm(form2);
            }
        }
        object = this.hFormSets.values().iterator();
        while (object.hasNext()) {
            formSet = (FormSet)object.next();
            if (formSet.isProcessed()) continue;
            formSet.process((Map)this.hConstants);
        }
    }

    protected Field getClosestLocaleField(FormSet formSet, String string, String string2) {
        Form form;
        Field field = null;
        String string3 = formSet.getLanguage();
        String string4 = formSet.getCountry();
        String string5 = formSet.getVariant();
        if (!GenericValidator.isBlankOrNull(string3) && !GenericValidator.isBlankOrNull(string4) && !GenericValidator.isBlankOrNull(string5) && (form = this.get(string3, string4, null, string)).getFieldMap().containsKey(string2)) {
            field = (Field)form.getFieldMap().get(string2);
        }
        if (field == null && !GenericValidator.isBlankOrNull(string3) && !GenericValidator.isBlankOrNull(string4) && (form = this.get(string3, null, null, string)).getFieldMap().containsKey(string2)) {
            field = (Field)form.getFieldMap().get(string2);
        }
        if (field == null && (form = this.get(defaultLocale, string)).getFieldMap().containsKey(string2)) {
            field = (Field)form.getFieldMap().get(string2);
        }
        return field;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

