/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reflection.java;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import org.hibernate.reflection.XClass;
import org.hibernate.reflection.java.JavaXFactory;
import org.hibernate.reflection.java.JavaXType;
import org.hibernate.reflection.java.generics.TypeEnvironment;
import org.hibernate.reflection.java.generics.TypeSwitch;
import org.hibernate.reflection.java.generics.TypeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JavaXCollectionType
extends JavaXType {
    public JavaXCollectionType(Type type, TypeEnvironment context, JavaXFactory factory) {
        super(type, context, factory);
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public XClass getElementClass() {
        return (XClass)new TypeSwitch<XClass>(){

            @Override
            public XClass caseParameterizedType(ParameterizedType parameterizedType) {
                Type[] args = parameterizedType.getActualTypeArguments();
                Type componentType = JavaXCollectionType.this.getCollectionClass().isAssignableFrom(Map.class) ? args[1] : args[0];
                return JavaXCollectionType.this.toXClass(componentType);
            }
        }.doSwitch(this.approximate());
    }

    @Override
    public XClass getMapKey() {
        return (XClass)new TypeSwitch<XClass>(){

            @Override
            public XClass caseParameterizedType(ParameterizedType parameterizedType) {
                if (JavaXCollectionType.this.getCollectionClass().isAssignableFrom(Map.class)) {
                    return JavaXCollectionType.this.toXClass(parameterizedType.getActualTypeArguments()[0]);
                }
                return null;
            }
        }.doSwitch(this.approximate());
    }

    @Override
    public XClass getClassOrElementClass() {
        return this.toXClass(this.approximate());
    }

    @Override
    public Class<? extends Collection> getCollectionClass() {
        return TypeUtils.getCollectionClass(this.approximate());
    }

    @Override
    public XClass getType() {
        return this.toXClass(this.approximate());
    }
}

