/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.CacheMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.TransientObjectException;
import org.hibernate.action.EntityDeleteAction;
import org.hibernate.classic.Lifecycle;
import org.hibernate.engine.Cascade;
import org.hibernate.engine.CascadingAction;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.ForeignKeys;
import org.hibernate.engine.Nullability;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.Status;
import org.hibernate.event.DeleteEvent;
import org.hibernate.event.DeleteEventListener;
import org.hibernate.event.EventSource;
import org.hibernate.event.def.OnUpdateVisitor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;

public class DefaultDeleteEventListener
implements DeleteEventListener {
    private static final Log log = LogFactory.getLog((Class)DefaultDeleteEventListener.class);

    public void onDelete(DeleteEvent event) throws HibernateException {
        Object version;
        Serializable id;
        EntityPersister persister;
        Object entity;
        EventSource source = event.getSession();
        PersistenceContext persistenceContext = source.getPersistenceContext();
        EntityEntry entityEntry = persistenceContext.getEntry(entity = persistenceContext.unproxyAndReassociate(event.getObject()));
        if (entityEntry == null) {
            log.trace((Object)"deleting a detached instance");
            persister = source.getEntityPersister(event.getEntityName(), entity);
            id = persister.getIdentifier(entity, source.getEntityMode());
            if (id == null) {
                throw new TransientObjectException("the detached instance passed to delete() had a null identifier");
            }
            EntityKey key = new EntityKey(id, persister, source.getEntityMode());
            persistenceContext.checkUniqueness(key, entity);
            new OnUpdateVisitor(source, id).process(entity, persister);
            version = persister.getVersion(entity, source.getEntityMode());
            entityEntry = persistenceContext.addEntity(entity, Status.MANAGED, persister.getPropertyValues(entity, source.getEntityMode()), key, version, LockMode.NONE, true, persister, false, false);
        } else {
            log.trace((Object)"deleting a persistent instance");
            if (entityEntry.getStatus() == Status.DELETED || entityEntry.getStatus() == Status.GONE) {
                log.trace((Object)"object was already deleted");
                return;
            }
            persister = entityEntry.getPersister();
            id = entityEntry.getId();
            version = entityEntry.getVersion();
        }
        if (this.invokeDeleteLifecycle(source, entity, persister)) {
            return;
        }
        this.deleteEntity(source, entity, entityEntry, event.isCascadeDeleteEnabled(), persister);
        if (source.getFactory().getSettings().isIdentifierRollbackEnabled()) {
            persister.resetIdentifier(entity, id, version, source.getEntityMode());
        }
    }

    protected final void deleteEntity(EventSource session, Object entity, EntityEntry entityEntry, boolean isCascadeDeleteEnabled, EntityPersister persister) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("deleting " + MessageHelper.infoString(persister, entityEntry.getId(), session.getFactory())));
        }
        PersistenceContext persistenceContext = session.getPersistenceContext();
        Type[] propTypes = persister.getPropertyTypes();
        Object version = entityEntry.getVersion();
        Object[] currentState = entityEntry.getLoadedState() == null ? persister.getPropertyValues(entity, session.getEntityMode()) : entityEntry.getLoadedState();
        Object[] deletedState = new Object[propTypes.length];
        TypeFactory.deepCopy(currentState, propTypes, persister.getPropertyUpdateability(), deletedState, session);
        entityEntry.setDeletedState(deletedState);
        session.getInterceptor().onDelete(entity, entityEntry.getId(), deletedState, persister.getPropertyNames(), propTypes);
        persistenceContext.setEntryStatus(entityEntry, Status.DELETED);
        EntityKey key = new EntityKey(entityEntry.getId(), persister, session.getEntityMode());
        this.cascadeBeforeDelete(session, persister, entity, entityEntry);
        new ForeignKeys.Nullifier(entity, true, false, session).nullifyTransientReferences(entityEntry.getDeletedState(), propTypes);
        new Nullability(session).checkNullability(entityEntry.getDeletedState(), persister, true);
        persistenceContext.getNullifiableEntityKeys().add(key);
        session.getActionQueue().addAction(new EntityDeleteAction(entityEntry.getId(), deletedState, version, entity, persister, isCascadeDeleteEnabled, session));
        this.cascadeAfterDelete(session, persister, entity);
    }

    protected boolean invokeDeleteLifecycle(EventSource session, Object entity, EntityPersister persister) {
        if (persister.implementsLifecycle(session.getEntityMode())) {
            log.debug((Object)"calling onDelete()");
            if (((Lifecycle)entity).onDelete(session)) {
                log.debug((Object)"deletion vetoed by onDelete()");
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeBeforeDelete(EventSource session, EntityPersister persister, Object entity, EntityEntry entityEntry) throws HibernateException {
        CacheMode cacheMode = session.getCacheMode();
        session.setCacheMode(CacheMode.GET);
        session.getPersistenceContext().incrementCascadeLevel();
        try {
            new Cascade(CascadingAction.DELETE, 1, session).cascade(persister, entity);
        }
        finally {
            session.getPersistenceContext().decrementCascadeLevel();
            session.setCacheMode(cacheMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeAfterDelete(EventSource session, EntityPersister persister, Object entity) throws HibernateException {
        CacheMode cacheMode = session.getCacheMode();
        session.setCacheMode(CacheMode.GET);
        session.getPersistenceContext().incrementCascadeLevel();
        try {
            new Cascade(CascadingAction.DELETE, 2, session).cascade(persister, entity);
        }
        finally {
            session.getPersistenceContext().decrementCascadeLevel();
            session.setCacheMode(cacheMode);
        }
    }
}

