/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.core;

import com.icesoft.faces.application.D2DViewHandler;
import com.icesoft.faces.component.FileUploadComponent;
import com.icesoft.faces.context.BridgeFacesContext;
import com.icesoft.faces.context.View;
import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.common.Request;
import com.icesoft.faces.webapp.http.common.Server;
import com.icesoft.faces.webapp.http.common.standard.StreamingContentHandler;
import com.icesoft.faces.webapp.xmlhttp.PersistentFacesState;
import com.icesoft.util.SeamUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UploadServer
implements Server {
    private static final Log Log = LogFactory.getLog((Class)UploadServer.class);
    private Map views;
    private long maxSize;
    private String uploadDirectory;
    private boolean uploadDirectoryAbsolute;

    public UploadServer(Map views, Configuration configuration) {
        this.views = views;
        this.maxSize = configuration.getAttributeAsLong("uploadMaxFileSize", 0x300000L);
        this.uploadDirectory = configuration.getAttribute("uploadDirectory", "");
        this.uploadDirectoryAbsolute = configuration.getAttributeAsBoolean("uploadDirectoryAbsolute", false);
    }

    public void service(final Request request) throws Exception {
        final ServletFileUpload uploader = new ServletFileUpload();
        final ProgressCalculator progressCalculator = new ProgressCalculator();
        uploader.setFileSizeMax(this.maxSize);
        uploader.setProgressListener(new ProgressListener(){

            public void update(long read, long total, int chunkIndex) {
                progressCalculator.progress(read, total);
            }
        });
        request.detectEnvironment(new Request.Environment(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void servlet(Object req, Object resp) throws Exception {
                HttpServletRequest servletRequest = (HttpServletRequest)req;
                FileItemIterator iter = uploader.getItemIterator(servletRequest);
                String viewIdentifier = null;
                String componentID = null;
                while (iter.hasNext()) {
                    FileItemStream item = iter.next();
                    if (item.isFormField()) {
                        String name = item.getFieldName();
                        if ("ice.component".equals(name)) {
                            componentID = Streams.asString((InputStream)item.openStream());
                            continue;
                        }
                        if (!"ice.view".equals(name)) continue;
                        viewIdentifier = Streams.asString((InputStream)item.openStream());
                        continue;
                    }
                    View view = (View)UploadServer.this.views.get(viewIdentifier);
                    BridgeFacesContext context = view.getFacesContext();
                    FileUploadComponent component = (FileUploadComponent)D2DViewHandler.findComponent(componentID, (UIComponent)context.getViewRoot());
                    view.makeCurrent();
                    progressCalculator.setListenerAndContextAndPFS(component, context, view.getPersistentFacesState());
                    try {
                        component.upload(item, UploadServer.this.uploadDirectory, UploadServer.this.uploadDirectoryAbsolute, UploadServer.this.maxSize, context, servletRequest.getSession().getServletContext(), servletRequest.getRequestedSessionId());
                    }
                    catch (IOException e) {
                        try {
                            progressCalculator.reset();
                        }
                        catch (Throwable tr) {
                            // empty catch block
                        }
                        request.respondWith(new StreamingContentHandler("text/html", "UTF-8", component, context){
                            private final /* synthetic */ FileUploadComponent val$component;
                            private final /* synthetic */ BridgeFacesContext val$context;
                            {
                                this.val$component = fileUploadComponent;
                                this.val$context = bridgeFacesContext;
                                super(x0, x1);
                            }

                            public void writeTo(Writer writer) throws IOException {
                                this.val$component.renderIFrame(writer, this.val$context);
                            }
                        });
                        continue;
                    }
                    catch (Throwable t) {
                        try {
                            progressCalculator.reset();
                        }
                        catch (Throwable tr) {
                            // empty catch block
                        }
                        Log.warn((Object)"File upload failed", t);
                        {
                            catch (Throwable throwable) {
                                request.respondWith(new /* invalid duplicate definition of identical inner class */);
                                throw throwable;
                            }
                        }
                        request.respondWith(new /* invalid duplicate definition of identical inner class */);
                        continue;
                    }
                    request.respondWith(new /* invalid duplicate definition of identical inner class */);
                }
            }

            public void portlet(Object request2, Object response, Object config) {
                throw new IllegalAccessError("Cannot upload using a portlet request/response.");
            }
        });
    }

    public void shutdown() {
    }

    private static class ProgressCalculator {
        private final int GRANULARITY = 10;
        private FileUploadComponent listener;
        private BridgeFacesContext context;
        private PersistentFacesState state;
        private int lastGranularlyNotifiablePercent = -1;

        private ProgressCalculator() {
        }

        public void progress(long read, long total) {
            if (total > 0L) {
                int percentage = (int)(read * 100L / total);
                int percentageAboveGranularity = percentage % 10;
                int granularNotifiablePercentage = percentage - percentageAboveGranularity;
                boolean shouldNotify = granularNotifiablePercentage > this.lastGranularlyNotifiablePercent;
                this.lastGranularlyNotifiablePercent = granularNotifiablePercentage;
                if (shouldNotify) {
                    this.potentiallyNotify();
                }
            }
        }

        public void setListenerAndContextAndPFS(FileUploadComponent listener, BridgeFacesContext context, PersistentFacesState state) {
            this.listener = listener;
            this.context = context;
            this.state = state;
            this.setCurrent();
            this.potentiallyNotify();
        }

        public void reset() {
            PersistentFacesState st = this.state;
            BridgeFacesContext ctx = this.context;
            FileUploadComponent component = this.listener;
            this.state = null;
            this.context = null;
            this.listener = null;
            if (ctx != null && component != null) {
                ctx.setCurrentInstance();
                st.setCurrentInstance();
                component.setProgress(0);
            }
        }

        protected void potentiallyNotify() {
            if (this.listener != null && this.context != null && this.state != null && this.lastGranularlyNotifiablePercent >= 0) {
                this.setCurrent();
                this.listener.setProgress(this.lastGranularlyNotifiablePercent);
                if (!this.state.isSynchronousMode() && this.listener.renderOnProgress()) {
                    try {
                        if (SeamUtilities.isSeamEnvironment()) {
                            this.state.setupAndExecuteAndRender();
                        } else {
                            this.state.renderLater();
                        }
                    }
                    catch (Exception e) {
                        Log.warn((Object)"Problem rendering view during file upload", (Throwable)e);
                    }
                }
            }
        }

        private void setCurrent() {
            if (this.context != null && this.state != null) {
                this.context.setCurrentInstance();
                this.state.setCurrentInstance();
            }
        }
    }
}

