/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.core;

import com.icesoft.faces.application.D2DViewHandler;
import com.icesoft.faces.el.PartialSubmitValueBinding;
import com.icesoft.faces.webapp.http.common.Request;
import com.icesoft.faces.webapp.http.common.Server;
import com.icesoft.faces.webapp.http.core.LifecycleExecutor;
import com.icesoft.faces.webapp.http.core.SendUpdates;
import com.icesoft.util.SeamUtilities;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.FactoryFinder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;

public class ReceiveSendUpdates
implements Server {
    private static final String REQUIRED = "required";
    private static final LifecycleFactory LifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
    private Lifecycle lifecycle = LifecycleFactory.getLifecycle("DEFAULT");
    private Map commandQueues;
    private Collection synchronouslyUpdatedViews;

    public ReceiveSendUpdates(Map commandQueues, Collection synchronouslyUpdatedViews) {
        this.commandQueues = commandQueues;
        this.synchronouslyUpdatedViews = synchronouslyUpdatedViews;
    }

    public void service(Request request) throws Exception {
        this.synchronouslyUpdatedViews.add(request.getParameter("ice.view"));
        FacesContext context = FacesContext.getCurrentInstance();
        if (request.getParameterAsBoolean("ice.submit.partial", false)) {
            String componentID = request.getParameter("ice.event.captured");
            UIComponent component = D2DViewHandler.findComponent(componentID, (UIComponent)context.getViewRoot());
            this.renderCyclePartial(context, component, componentID);
        } else {
            this.renderCycle(context);
        }
        request.respondWith(new SendUpdates.Handler(this.commandQueues, request));
    }

    public void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderCycle(FacesContext context) {
        FacesContext facesContext = context;
        synchronized (facesContext) {
            SeamUtilities.removeSeamDebugPhaseListener(this.lifecycle);
            LifecycleExecutor.getLifecycleExecutor(context).apply(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderCyclePartial(FacesContext context, UIComponent component, String clientId) {
        FacesContext facesContext = context;
        synchronized (facesContext) {
            Map alteredRequiredComponents = this.setRequiredFalseInFormContaining(component, clientId);
            SeamUtilities.removeSeamDebugPhaseListener(this.lifecycle);
            LifecycleExecutor.getLifecycleExecutor(context).apply(context);
            this.setRequiredTrue(alteredRequiredComponents);
        }
    }

    private void setRequiredTrue(Map requiredComponents) {
        Iterator i = requiredComponents.keySet().iterator();
        UIInput next = null;
        while (i.hasNext()) {
            next = (UIInput)i.next();
            ValueBinding valueBinding = (ValueBinding)requiredComponents.get(next);
            if (null != valueBinding) {
                next.setValueBinding(REQUIRED, valueBinding);
                continue;
            }
            next.setRequired(true);
        }
    }

    private Map setRequiredFalseInFormContaining(UIComponent component, String clientId) {
        HashMap alteredComponents = new HashMap();
        UIComponent form = this.getContainingForm(component);
        this.setRequiredFalseOnAllChildrenExceptOne(form, component, clientId, alteredComponents);
        return alteredComponents;
    }

    private void setRequiredFalseOnAllChildrenExceptOne(UIComponent parent, UIComponent componentToAvoid, String clientIdToAvoid, Map alteredComponents) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ValueBinding FALSE_BINDING = facesContext.getApplication().createValueBinding("#{false}");
        Iterator kidsAndFacets = parent.getFacetsAndChildren();
        while (kidsAndFacets.hasNext()) {
            UIComponent next = (UIComponent)kidsAndFacets.next();
            if (next instanceof UIInput) {
                UIInput input = (UIInput)next;
                ValueBinding valueBinding = input.getValueBinding(REQUIRED);
                if (null != valueBinding) {
                    ValueBinding replacementBinding = null;
                    replacementBinding = input == componentToAvoid ? new PartialSubmitValueBinding(valueBinding, input, clientIdToAvoid) : FALSE_BINDING;
                    input.setValueBinding(REQUIRED, replacementBinding);
                    alteredComponents.put(input, valueBinding);
                } else if (input.isRequired() && input != componentToAvoid && input.isValid()) {
                    input.setRequired(false);
                    alteredComponents.put(input, null);
                }
            }
            this.setRequiredFalseOnAllChildrenExceptOne(next, componentToAvoid, clientIdToAvoid, alteredComponents);
        }
    }

    private UIComponent getContainingForm(UIComponent component) {
        UIComponent parent;
        if (null == component) {
            return FacesContext.getCurrentInstance().getViewRoot();
        }
        for (parent = component.getParent(); parent != null && !(parent instanceof UIForm); parent = parent.getParent()) {
        }
        return (UIForm)parent;
    }
}

