/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.context;

import com.icesoft.faces.context.BridgeExternalContext;
import com.icesoft.faces.context.BridgeFacesContext;
import com.icesoft.faces.context.UnknownExternalContext;
import com.icesoft.faces.context.ViewListener;
import com.icesoft.faces.webapp.command.Command;
import com.icesoft.faces.webapp.command.CommandQueue;
import com.icesoft.faces.webapp.command.NOOP;
import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.common.Request;
import com.icesoft.faces.webapp.http.core.ResourceDispatcher;
import com.icesoft.faces.webapp.http.core.ViewQueue;
import com.icesoft.faces.webapp.http.portlet.PortletExternalContext;
import com.icesoft.faces.webapp.http.servlet.ServletExternalContext;
import com.icesoft.faces.webapp.http.servlet.SessionDispatcher;
import com.icesoft.faces.webapp.xmlhttp.PersistentFacesState;
import com.icesoft.util.SeamUtilities;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Lock;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class View
implements CommandQueue {
    private static final Log Log = LogFactory.getLog((Class)View.class);
    private static final NOOP NOOP = new NOOP();
    private static final Runnable DoNothing = new Runnable(){

        public void run() {
        }
    };
    private Lock lock = new ReentrantLock();
    private BridgeExternalContext externalContext;
    private BridgeFacesContext facesContext;
    private PersistentFacesState persistentFacesState;
    private Map bundles = Collections.EMPTY_MAP;
    private Command currentCommand = NOOP;
    private String viewIdentifier;
    private ArrayList onPutListeners = new ArrayList();
    private ArrayList onTakeListeners = new ArrayList();
    private Collection viewListeners = new ArrayList();
    private String sessionID;
    private Configuration configuration;
    private SessionDispatcher.Monitor sessionMonitor;
    private ResourceDispatcher resourceDispatcher;
    private Runnable dispose;

    public View(final String viewIdentifier, String sessionID, Request request, final ViewQueue allServedViews, final Configuration configuration, final SessionDispatcher.Monitor sessionMonitor, ResourceDispatcher resourceDispatcher) throws Exception {
        if (Log.isDebugEnabled()) {
            Log.debug((Object)("View Created: " + viewIdentifier + ", ice.session: " + sessionID));
        }
        this.sessionID = sessionID;
        this.configuration = configuration;
        this.viewIdentifier = viewIdentifier;
        this.sessionMonitor = sessionMonitor;
        this.resourceDispatcher = resourceDispatcher;
        this.externalContext = new UnknownExternalContext(this, configuration);
        request.detectEnvironment(new Request.Environment(){

            public void servlet(Object request, Object response) {
                View.this.externalContext = new ServletExternalContext(viewIdentifier, request, response, View.this, configuration, sessionMonitor);
            }

            public void portlet(Object request, Object response, Object portletConfig) {
                View.this.externalContext = new PortletExternalContext(viewIdentifier, request, response, View.this, configuration, sessionMonitor, portletConfig);
            }
        });
        this.facesContext = new BridgeFacesContext(this.externalContext, viewIdentifier, sessionID, this, configuration, resourceDispatcher);
        this.persistentFacesState = new PersistentFacesState(this.facesContext, this.viewListeners, configuration);
        this.onPut(new Runnable(){

            public void run() {
                try {
                    allServedViews.put(viewIdentifier);
                }
                catch (InterruptedException e) {
                    Log.warn((Object)"Failed to queue updated view", (Throwable)e);
                }
            }
        });
        this.dispose = new Runnable(){

            public void run() {
                if (Log.isDebugEnabled()) {
                    Log.debug((Object)("Disposing of View: " + viewIdentifier));
                }
                View.this.persistentFacesState.setCurrentInstance();
                View.this.facesContext.setCurrentInstance();
                View.this.notifyViewDisposal();
                View.this.release();
                View.this.persistentFacesState.dispose();
                View.this.facesContext.dispose();
                View.this.externalContext.dispose();
                allServedViews.remove(viewIdentifier);
                View.this.dispose = DoNothing;
            }
        };
    }

    public void updateOnXMLHttpRequest(Request request) throws Exception {
        request.detectEnvironment(new Request.Environment(){

            public void servlet(Object request, Object response) {
                View.this.externalContext.update((HttpServletRequest)request, (HttpServletResponse)response);
                View.this.externalContext.insertPostbackKey();
            }

            public void portlet(Object request, Object response, Object config) {
            }
        });
        this.makeCurrent();
    }

    public void updateOnPageRequest(Request request) throws Exception {
        request.detectEnvironment(new Request.Environment(){

            public void servlet(Object request, Object response) {
                if (View.this.differentURI((HttpServletRequest)request)) {
                    View.this.externalContext.dispose();
                    View.this.externalContext = new ServletExternalContext(View.this.viewIdentifier, request, response, View.this, View.this.configuration, View.this.sessionMonitor);
                    View.this.facesContext.dispose();
                    View.this.facesContext = new BridgeFacesContext(View.this.externalContext, View.this.viewIdentifier, View.this.sessionID, View.this, View.this.configuration, View.this.resourceDispatcher);
                    View.this.persistentFacesState.setFacesContext(View.this.facesContext);
                } else {
                    View.this.externalContext.updateOnPageLoad(request, response);
                }
            }

            public void portlet(Object request, Object response, Object config) {
                View.this.externalContext.updateOnPageLoad(request, response);
            }
        });
        this.makeCurrent();
    }

    public void switchToNormalMode() {
        this.facesContext.switchToNormalMode();
        this.externalContext.switchToNormalMode();
    }

    public void switchToPushMode() {
        this.bundles = this.externalContext.collectBundles();
        this.facesContext.switchToPushMode();
        this.externalContext.switchToPushMode();
    }

    public boolean differentURI(HttpServletRequest request) {
        return SeamUtilities.isSeamEnvironment() || !request.getRequestURI().equals(((HttpServletRequest)this.externalContext.getRequest()).getRequestURI());
    }

    public void put(Command command) {
        this.lock.lock();
        this.currentCommand = this.currentCommand.coalesceWith(command);
        this.lock.unlock();
        this.broadcastTo(this.onPutListeners);
    }

    public Command take() {
        this.lock.lock();
        Command command = this.currentCommand;
        this.currentCommand = NOOP;
        this.lock.unlock();
        this.broadcastTo(this.onTakeListeners);
        return command;
    }

    public void onPut(Runnable listener) {
        this.onPutListeners.add(listener);
    }

    public void onTake(Runnable listener) {
        this.onTakeListeners.add(listener);
    }

    private void broadcastTo(Collection listeners) {
        Iterator i = listeners.iterator();
        while (i.hasNext()) {
            Runnable listener = (Runnable)i.next();
            try {
                listener.run();
            }
            catch (Exception e) {
                Log.error((Object)("Failed to notify listener: " + listener), (Throwable)e);
            }
        }
    }

    public void release() {
        this.facesContext.release();
        this.persistentFacesState.release();
        this.externalContext.release();
    }

    public BridgeFacesContext getFacesContext() {
        return this.facesContext;
    }

    public PersistentFacesState getPersistentFacesState() {
        return this.persistentFacesState;
    }

    public void dispose() {
        this.dispose.run();
    }

    public void makeCurrent() {
        this.externalContext.injectBundles(this.bundles);
        this.persistentFacesState.setCurrentInstance();
        this.facesContext.setCurrentInstance();
        this.facesContext.applyBrowserDOMChanges();
    }

    private void notifyViewDisposal() {
        Iterator i = this.viewListeners.iterator();
        while (i.hasNext()) {
            try {
                ViewListener listener = (ViewListener)i.next();
                listener.viewDisposed();
            }
            catch (Throwable t) {
                Log.warn((Object)"Failed to invoke view listener", t);
            }
        }
    }
}

