/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.async.render;

import com.icesoft.faces.async.render.AsyncRenderer;
import com.icesoft.faces.async.render.RenderManager;
import com.icesoft.faces.async.render.RenderMessageHandler;
import com.icesoft.net.messaging.MessageSelector;
import com.icesoft.net.messaging.MessageServiceAdapter;
import com.icesoft.net.messaging.MessageServiceClient;
import com.icesoft.net.messaging.MessageServiceException;
import com.icesoft.net.messaging.expression.And;
import com.icesoft.net.messaging.expression.Equal;
import com.icesoft.net.messaging.expression.Identifier;
import com.icesoft.net.messaging.expression.NotEqual;
import com.icesoft.net.messaging.expression.StringLiteral;
import com.icesoft.net.messaging.jms.JMSAdapter;
import java.net.MalformedURLException;
import java.util.Properties;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BroadcastHub {
    private static final Log LOG = LogFactory.getLog((Class)BroadcastHub.class);
    private MessageServiceClient messageServiceClient;
    protected static final String MESSAGE_TYPE = "RenderBroadcast";
    protected static final String RENDERER_NAME_KEY = "rendererName";
    protected static final String COMMAND_KEY = "command";
    private RenderManager renderManager;
    private RenderMessageHandler messageHandler;

    public void init() {
        block8: {
            block7: {
                ServletContext servletContext = BroadcastHub.getServletContext();
                if (servletContext == null) {
                    throw new IllegalStateException("could not retrieve the ServletContext");
                }
                JMSAdapter messageServiceAdapter = new JMSAdapter(servletContext);
                this.messageServiceClient = new MessageServiceClient(messageServiceAdapter.getMessageServiceConfiguration(), (MessageServiceAdapter)messageServiceAdapter, servletContext);
                try {
                    String path = servletContext.getResource("/").getPath();
                    int index = path.lastIndexOf("/");
                    path = path.substring(path.lastIndexOf("/", index - 1) + 1, index);
                    MessageSelector messageSelector = new MessageSelector(new And(new And(new Equal(new Identifier("message_type"), new StringLiteral(MESSAGE_TYPE)), new Equal(new Identifier("source_servletContextPath"), new StringLiteral(path))), new NotEqual(new Identifier("source_id"), new StringLiteral(this.messageServiceClient.toString()))));
                    this.messageServiceClient.subscribe("icefacesRenderTopic", messageSelector, true);
                    this.messageHandler = new RenderMessageHandler(this.renderManager);
                    this.messageHandler.setMessageSelector(messageSelector);
                    this.messageServiceClient.addMessageHandler(this.messageHandler, "icefacesRenderTopic");
                }
                catch (MalformedURLException exception) {
                    if (LOG.isFatalEnabled()) {
                        LOG.fatal((Object)"Failed to get servlet context path!", (Throwable)exception);
                    }
                }
                catch (MessageServiceException exception) {
                    if (!LOG.isFatalEnabled()) break block7;
                    LOG.fatal((Object)"Failed to subscribe to topic: icefacesRenderTopic", (Throwable)exception);
                }
            }
            try {
                this.messageServiceClient.start();
            }
            catch (MessageServiceException exception) {
                if (!LOG.isFatalEnabled()) break block8;
                LOG.fatal((Object)"Failed to start message delivery!", (Throwable)exception);
            }
        }
    }

    private static ServletContext getServletContext() {
        Object context = FacesContext.getCurrentInstance().getExternalContext().getContext();
        if (context instanceof ServletContext) {
            return (ServletContext)context;
        }
        return null;
    }

    public RenderManager getRenderManager() {
        return this.renderManager;
    }

    public void setRenderManager(RenderManager renderManager) {
        this.renderManager = renderManager;
    }

    synchronized void relayRenderRequest(AsyncRenderer renderer) {
        if (renderer == null) {
            return;
        }
        if (this.messageServiceClient == null) {
            this.init();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Request render: " + renderer.getName()));
        }
        Properties msgProperties = new Properties();
        msgProperties.setProperty(RENDERER_NAME_KEY, renderer.getName());
        msgProperties.setProperty(COMMAND_KEY, "render");
        msgProperties.setProperty("message_type", MESSAGE_TYPE);
        msgProperties.setProperty("source_id", this.messageServiceClient.toString());
        this.messageServiceClient.publish("render broadcast to " + renderer.getName(), msgProperties, "icefacesRenderTopic");
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Broadcast render message sent to " + renderer.getName()));
        }
    }

    public synchronized void dispose() {
        block2: {
            try {
                this.messageServiceClient.stop();
                this.messageServiceClient.removeMessageHandler(this.messageHandler, "icefacesRenderTopic");
                this.renderManager = null;
                this.messageServiceClient.close();
            }
            catch (MessageServiceException exception) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)"Failed to dispose JMS resources", (Throwable)exception);
            }
        }
    }
}

